/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.api;

import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiHelper {
    public static String getBinaryMethodName(PsiMethod psiMethod) {
        return psiMethod.isConstructor() ? "<init>" : psiMethod.getName();
    }

    public static Iterator<String> getOverloadedSignatures(PsiMethod method) {
        final ArrayList<String> parameters = new ArrayList<String>();
        PsiType returnType = Optional.ofNullable(method.getReturnType()).orElse((PsiType)PsiTypes.voidType());
        String returnTypeRepresentation = ClassUtil.getBinaryPresentation((PsiType)returnType);
        if (returnTypeRepresentation.isEmpty()) {
            System.err.println("Failed to create binary representation for type " + returnType.getCanonicalText());
            returnTypeRepresentation = "ERROR";
        }
        final String retRep = returnTypeRepresentation;
        if (PsiHelper.isEnumConstructor(method)) {
            parameters.add("Ljava/lang/String;I");
        } else if (PsiHelper.isNonStaticInnerClassConstructor(method)) {
            PsiClass parent = Objects.requireNonNull(Objects.requireNonNull(method.getContainingClass()).getContainingClass());
            StringBuilder par = new StringBuilder();
            par.append("L");
            PsiHelper.getBinaryClassName(parent, par);
            par.append(";");
            parameters.add(par.toString());
        }
        for (PsiParameter param : method.getParameterList().getParameters()) {
            String binaryPresentation = ClassUtil.getBinaryPresentation((PsiType)param.getType());
            if (binaryPresentation.isEmpty()) {
                System.err.println("Failed to create binary representation for type " + param.getType().getCanonicalText());
                binaryPresentation = "ERROR";
            }
            parameters.add(binaryPresentation);
        }
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return !parameters.isEmpty();
            }

            @Override
            public String next() {
                StringBuilder signature = new StringBuilder();
                signature.append("(");
                parameters.forEach(signature::append);
                signature.append(")").append(retRep);
                parameters.remove(parameters.size() - 1);
                return signature.toString();
            }
        };
    }

    public static String getImplicitConstructorSignature(PsiClass psiClass) {
        StringBuilder signature = new StringBuilder();
        signature.append("(");
        if (PsiHelper.isNonStaticInnerClass(psiClass)) {
            PsiClass parent = Objects.requireNonNull(Objects.requireNonNull(psiClass.getContainingClass()));
            signature.append("L");
            PsiHelper.getBinaryClassName(parent, signature);
            signature.append(";");
        }
        signature.append(")V");
        return signature.toString();
    }

    public static String getBinaryMethodSignature(PsiMethod method) {
        StringBuilder signature = new StringBuilder();
        signature.append("(");
        if (PsiHelper.isEnumConstructor(method)) {
            signature.append("Ljava/lang/String;I");
        } else if (PsiHelper.isNonStaticInnerClassConstructor(method)) {
            PsiClass parent = Objects.requireNonNull(Objects.requireNonNull(method.getContainingClass()).getContainingClass());
            signature.append("L");
            PsiHelper.getBinaryClassName(parent, signature);
            signature.append(";");
        }
        for (PsiClass param : method.getParameterList().getParameters()) {
            String binaryPresentation = ClassUtil.getBinaryPresentation((PsiType)param.getType());
            if (binaryPresentation.isEmpty()) {
                System.err.println("Failed to create binary representation for type " + param.getType().getCanonicalText());
                binaryPresentation = "ERROR";
            }
            signature.append(binaryPresentation);
        }
        signature.append(")");
        PsiType returnType = Optional.ofNullable(method.getReturnType()).orElse((PsiType)PsiTypes.voidType());
        String returnTypeRepresentation = ClassUtil.getBinaryPresentation((PsiType)returnType);
        if (returnTypeRepresentation.isEmpty()) {
            System.err.println("Failed to create binary representation for type " + returnType.getCanonicalText());
            returnTypeRepresentation = "ERROR";
        }
        signature.append(returnTypeRepresentation);
        return signature.toString();
    }

    public static void getBinaryClassName(@NotNull PsiClass aClass, @NotNull StringBuilder buf) {
        String qName = ClassUtil.getJVMClassName((PsiClass)aClass);
        if (qName != null) {
            buf.append(qName.replace('.', '/'));
        } else {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
            if (parentClass != null) {
                PsiHelper.getBinaryClassName(parentClass, buf);
                buf.append("$");
                buf.append(PsiHelper.getNonQualifiedClassIdx(aClass, parentClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    private static int getNonQualifiedClassIdx(@NotNull PsiClass psiClass, @NotNull PsiClass containingClass) {
        ObjectIntHashMap indices = (ObjectIntHashMap)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
            ObjectIntHashMap map = new ObjectIntHashMap();
            int index = 0;
            for (PsiClass aClass : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)containingClass)).postOrderDfsTraversal().filter(PsiClass.class)) {
                if (aClass instanceof PsiTypeParameter || aClass.getQualifiedName() != null) continue;
                map.put((Object)aClass, ++index);
            }
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{containingClass});
        });
        return indices.get((Object)psiClass);
    }

    private static boolean isEnumConstructor(PsiMethod method) {
        if (method.isConstructor()) {
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && containingClass.isEnum();
        }
        return false;
    }

    private static boolean isNonStaticInnerClassConstructor(PsiMethod method) {
        if (method.isConstructor()) {
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && PsiHelper.isNonStaticInnerClass(containingClass);
        }
        return false;
    }

    public static boolean isNonStaticInnerClass(PsiClass psiClass) {
        return psiClass.getContainingClass() != null && !psiClass.hasModifierProperty("static");
    }

    public static int[] getParameterLvtIndices(PsiParameterListOwner methodOrLambda) {
        int currentIndex = 0;
        if (methodOrLambda instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)methodOrLambda;
            if (!psiMethod.hasModifierProperty("static")) {
                ++currentIndex;
            }
            if (PsiHelper.isEnumConstructor(psiMethod)) {
                currentIndex += 2;
            } else if (PsiHelper.isNonStaticInnerClassConstructor(psiMethod)) {
                ++currentIndex;
            }
        }
        PsiParameter[] parameters = methodOrLambda.getParameterList().getParameters();
        int[] lvti = new int[parameters.length];
        for (int i = 0; i < lvti.length; ++i) {
            PsiPrimitiveType primitiveType;
            JvmPrimitiveTypeKind kind;
            lvti[i] = currentIndex++;
            PsiType psiType = parameters[i].getType();
            if (!(psiType instanceof PsiPrimitiveType) || (kind = (primitiveType = (PsiPrimitiveType)psiType).getKind()) != JvmPrimitiveTypeKind.LONG && kind != JvmPrimitiveTypeKind.DOUBLE) continue;
            ++currentIndex;
        }
        return lvti;
    }

    public static boolean isRecordConstructor(PsiMethod psiMethod) {
        PsiClass containingClass = psiMethod.getContainingClass();
        return containingClass != null && containingClass.isRecord() && psiMethod.isConstructor();
    }

    public static int getLastLineLength(PsiWhiteSpace psiWhiteSpace) {
        int lastNewline = psiWhiteSpace.getText().lastIndexOf(10);
        if (lastNewline != -1) {
            return psiWhiteSpace.getTextLength() - lastNewline - 1;
        }
        return psiWhiteSpace.getTextLength();
    }

    @Nullable
    public static PsiElement resolve(PsiReferenceExpression expression) {
        try {
            return expression.resolve();
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

