/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.javadoctor.injector.DocFormatter;
import net.neoforged.javadoctor.injector.JavadocProvider;
import net.neoforged.javadoctor.injector.Result;
import net.neoforged.javadoctor.injector.ast.JClass;
import net.neoforged.javadoctor.injector.ast.JClassParser;
import net.neoforged.javadoctor.injector.ast.JElement;
import net.neoforged.javadoctor.injector.ast.JField;
import net.neoforged.javadoctor.injector.ast.JMethod;
import net.neoforged.javadoctor.injector.ast.JParameter;
import net.neoforged.javadoctor.spec.ClassJavadoc;
import net.neoforged.javadoctor.spec.JavadocEntry;
import org.jetbrains.annotations.Nullable;

public class JavadocInjector {
    private final JClassParser parser;
    private final JavadocProvider javadocProvider;

    public JavadocInjector(JClassParser parser, JavadocProvider javadocProvider) {
        this.parser = parser;
        this.javadocProvider = javadocProvider;
    }

    public Result<InjectionResult> injectDocs(String className, String sourceIn, @Nullable int[] mappingIn) {
        if (this.javadocProvider.get(className) == null) {
            return new Result<InjectionResult>(new InjectionResult(mappingIn, sourceIn));
        }
        return this.parser.parse(sourceIn).map(classes -> {
            ArrayList<String> newSource = new ArrayList<String>();
            for (String line : sourceIn.split(System.lineSeparator())) {
                newSource.add(line);
            }
            AtomicInteger offset = new AtomicInteger();
            ArrayList<Integer> newMapping = new ArrayList<Integer>();
            if (mappingIn != null) {
                for (int i2 : mappingIn) {
                    newMapping.add(i2);
                }
            }
            for (JClass type : classes) {
                ClassJavadoc javadoc = this.javadocProvider.get(type.getFullyQualifiedName());
                if (javadoc == null) continue;
                this.inject(newSource, type, javadoc, offset, newMapping, mappingIn == null);
            }
            return new InjectionResult(newMapping.stream().mapToInt(i -> i).toArray(), String.join((CharSequence)System.lineSeparator(), newSource));
        });
    }

    private void inject(List<String> newSource, JClass declaration, ClassJavadoc javadoc, AtomicInteger offset, List<Integer> mapping, boolean appendLineMappings) {
        ArrayList<JElement> members = new ArrayList<JElement>();
        members.addAll(declaration.getChildren());
        Collections.sort(members, Comparator.comparing(r -> r.getSourceLine().orElse(-1)));
        if (appendLineMappings) {
            declaration.getSourceLine().ifPresent(line -> {
                mapping.add(line);
                mapping.add(line);
            });
            for (JElement member2 : members) {
                member2.getSourceLine().ifPresent(line -> {
                    mapping.add(line);
                    mapping.add(line);
                });
            }
        }
        if (javadoc.clazz() != null) {
            declaration.getSourceLine().ifPresent(line -> {
                int offsetLine = line + offset.get() - 1;
                DocFormatter.WithLength formatted = DocFormatter.formatDoc(JavadocInjector.findIndent((String)newSource.get(offsetLine)), javadoc.clazz(), JavadocInjector.getParameters(declaration), JavadocInjector.getTypeParameters(declaration));
                offset.incrementAndGet();
                newSource.add(offsetLine, formatted.doc);
                JavadocInjector.pushMappingFix(mapping, line, formatted.length);
            });
        }
        Map<String, JavadocEntry> fields = (javadoc.fields() == null ? new HashMap() : javadoc.fields()).entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).split(":", 2)[0], Map.Entry::getValue));
        HashMap methods = javadoc.methods() == null ? new HashMap() : this.parser.processMethodMap(javadoc.methods());
        Consumer<JElement> memberConsumer = member -> {
            if (member instanceof JField) {
                JavadocEntry entry = (JavadocEntry)fields.get(member.getName());
                if (entry == null) {
                    return;
                }
                member.getSourceLine().ifPresent(line -> {
                    int offsetLine = line + offset.get() - 1;
                    DocFormatter.WithLength formatted = DocFormatter.formatDoc(JavadocInjector.findIndent((String)newSource.get(offsetLine)), entry, null, null);
                    offset.incrementAndGet();
                    newSource.add(offsetLine, formatted.doc);
                    JavadocInjector.pushMappingFix(mapping, line, formatted.length);
                });
            } else if (member instanceof JMethod) {
                JMethod method = (JMethod)member;
                String desc = method.getDescriptor();
                JavadocEntry entry = (JavadocEntry)methods.get(desc);
                if (entry == null) {
                    return;
                }
                member.getSourceLine().ifPresent(line -> {
                    int offsetLine = line + offset.get() - 1;
                    DocFormatter.WithLength formatted = DocFormatter.formatDoc(JavadocInjector.findIndent((String)newSource.get(offsetLine)), entry, method.getParameters().stream().map(JParameter::getName).collect(Collectors.toList()), JavadocInjector.getTypeParameters(method));
                    offset.incrementAndGet();
                    newSource.add(offsetLine, formatted.doc);
                    JavadocInjector.pushMappingFix(mapping, line, formatted.length);
                });
            } else if (member instanceof JClass) {
                JClass type = (JClass)member;
                ClassJavadoc innerDoc = (ClassJavadoc)javadoc.innerClasses().get(type.getName());
                if (innerDoc != null) {
                    this.inject(newSource, type, innerDoc, offset, mapping, appendLineMappings);
                }
            }
        };
        for (JElement member3 : members) {
            try {
                memberConsumer.accept(member3);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    private static List<String> getTypeParameters(Object declaration) {
        if (declaration instanceof JElement.WithTypeParameters) {
            return ((JElement.WithTypeParameters)declaration).getTypeParameters().stream().map(JParameter::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    private static List<String> getParameters(Object declaration) {
        if (declaration instanceof JElement.WithParameters) {
            return ((JElement.WithParameters)declaration).getParameters().stream().map(JParameter::getName).collect(Collectors.toList());
        }
        return null;
    }

    private static void pushMappingFix(List<Integer> mapping, int start, int amount) {
        for (int i = 0; i < mapping.size(); i += 2) {
            int originalLine = mapping.get(i);
            if (originalLine < start) continue;
            mapping.set(i + 1, mapping.get(i + 1) + amount);
        }
    }

    private static String findIndent(String line) {
        StringBuilder builder = new StringBuilder();
        for (char ch : line.toCharArray()) {
            if (ch != '\t' && ch != ' ') break;
            builder.append(ch);
        }
        return builder.toString();
    }

    public static final class InjectionResult {
        public final int @Nullable [] mapping;
        public final String newSource;

        public InjectionResult(int @Nullable [] mapping, String newSource) {
            this.mapping = mapping;
            this.newSource = newSource;
        }
    }
}

