/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector.spoon;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.javadoctor.injector.Result;
import net.neoforged.javadoctor.injector.ast.JClass;
import net.neoforged.javadoctor.injector.ast.JClassParser;
import net.neoforged.javadoctor.injector.ast.JElement;
import net.neoforged.javadoctor.injector.ast.JField;
import net.neoforged.javadoctor.injector.ast.JMethod;
import net.neoforged.javadoctor.injector.ast.JParameter;
import net.neoforged.javadoctor.injector.ast.JRecord;
import net.neoforged.javadoctor.injector.spoon.JVMSignatureBuilder;
import spoon.Launcher;
import spoon.compiler.SpoonResource;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtRecordComponent;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.support.compiler.VirtualFile;

public class SpoonClassParser
implements JClassParser {
    private final Supplier<Launcher> launcherFactory;

    public SpoonClassParser(Supplier<Launcher> launcherFactory) {
        this.launcherFactory = launcherFactory;
    }

    public Result<List<JClass>> parse(String classText) {
        Launcher launcher = this.launcherFactory.get();
        launcher.addInputResource((SpoonResource)new VirtualFile(classText));
        return new Result(launcher.buildModel().getAllTypes().stream().map(this::createClass).collect(Collectors.toList()));
    }

    private JClass createClass(CtType<?> declaration) {
        if (declaration instanceof CtRecord) {
            return new BaseRecord((CtRecord)declaration);
        }
        return new BaseClass(this, declaration);
    }

    private JField createField(final String name, final SourcePosition pos) {
        return new JField(){
            private int linePos = -1;

            public OptionalInt getSourceLine() {
                if (this.linePos == -1) {
                    this.linePos = SpoonClassParser.searchLineNumber((CtCompilationUnit)pos.getCompilationUnit(), pos.getSourceStart());
                }
                return OptionalInt.of(this.linePos);
            }

            public String getName() {
                return name;
            }

            public String toString() {
                return "JField[name=" + name + "]";
            }
        };
    }

    private static int searchLineNumber(CtCompilationUnit compilationUnit, int position) {
        int[] lineSeparatorPositions = SpoonClassParser.getLineSeparatorPositions(compilationUnit);
        if (lineSeparatorPositions == null) {
            return 1;
        }
        int length = lineSeparatorPositions.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            int start = lineSeparatorPositions[m];
            if (position < start) {
                d = m - 1;
                continue;
            }
            if (position > start) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < lineSeparatorPositions[m]) {
            return m + 1;
        }
        return m + 2;
    }

    private static int[] getLineSeparatorPositions(CtCompilationUnit compilationUnit) {
        return compilationUnit == null ? null : compilationUnit.getLineSeparatorPositions();
    }

    private static <T extends CtElement> Consumer<T> nonImplicit(Consumer<T> consumer) {
        return it -> {
            if (!it.isImplicit()) {
                consumer.accept(it);
            }
        };
    }

    private static class BaseClass<T extends CtType<?>>
    implements JClass {
        protected final T declaration;
        private final List<JElement> children;
        private int linePos = -1;
        final /* synthetic */ SpoonClassParser this$0;

        private BaseClass(T declaration) {
            this.this$0 = var1_1;
            this.declaration = declaration;
            this.children = new ArrayList<JElement>();
            declaration.getFields().forEach(SpoonClassParser.nonImplicit(field -> this.children.add((JElement)this.this$0.createField(field.getSimpleName(), field.getPosition()))));
            Stream.concat(declaration.getMethods().stream(), declaration instanceof CtClass ? ((CtClass)declaration).getConstructors().stream() : Stream.of(new CtConstructor[0])).forEach(SpoonClassParser.nonImplicit(method -> this.children.add((JElement)new JMethod((CtExecutable)method){
                final boolean isCtor;
                final String name;
                final String desc;
                private int linePos;
                final /* synthetic */ CtExecutable val$method;
                {
                    this.val$method = ctExecutable;
                    this.isCtor = this.val$method instanceof CtConstructor;
                    this.name = this.isCtor ? "<init>" : this.val$method.getSimpleName();
                    this.desc = this.name + JVMSignatureBuilder.getJvmMethodSignature(this.val$method);
                    this.linePos = -1;
                }

                public String getDescriptor() {
                    return this.desc;
                }

                public boolean isConstructor() {
                    return this.isCtor;
                }

                public OptionalInt getSourceLine() {
                    if (this.linePos == -1) {
                        this.linePos = SpoonClassParser.searchLineNumber((CtCompilationUnit)this.val$method.getPosition().getCompilationUnit(), this.val$method.getPosition().getSourceStart());
                    }
                    return OptionalInt.of(this.linePos);
                }

                public String getName() {
                    return this.name;
                }

                public List<JParameter> getParameters() {
                    return this.val$method.getParameters().stream().map(it -> () -> ((CtParameter)it).getSimpleName()).collect(Collectors.toList());
                }

                public List<JParameter> getTypeParameters() {
                    return ((CtFormalTypeDeclarer)this.val$method).getFormalCtTypeParameters().stream().map(it -> () -> ((CtTypeParameter)it).getSimpleName()).collect(Collectors.toList());
                }
            })));
            declaration.getNestedTypes().forEach(type -> this.children.add((JElement)this.this$0.createClass((CtType<?>)type)));
        }

        public String getFullyQualifiedName() {
            return this.declaration.getQualifiedName();
        }

        public List<JElement> getChildren() {
            return this.children;
        }

        public OptionalInt getSourceLine() {
            if (this.linePos == -1) {
                this.linePos = SpoonClassParser.searchLineNumber((CtCompilationUnit)this.declaration.getPosition().getCompilationUnit(), this.declaration.getPosition().getSourceStart());
            }
            return OptionalInt.of(this.linePos);
        }

        public String getName() {
            return this.declaration.getSimpleName();
        }

        public List<JParameter> getTypeParameters() {
            return this.declaration.getFormalCtTypeParameters().stream().map(it -> () -> ((CtTypeParameter)it).getSimpleName()).collect(Collectors.toList());
        }
    }

    private class BaseRecord
    extends BaseClass<CtRecord>
    implements JRecord {
        private BaseRecord(CtRecord declaration) {
            super(SpoonClassParser.this, (CtType)declaration);
        }

        public List<JParameter> getParameters() {
            return ((CtRecord)this.declaration).getRecordComponents().stream().map(it -> () -> ((CtRecordComponent)it).getSimpleName()).collect(Collectors.toList());
        }
    }
}

