/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector.spoon;

import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;

public class JVMSignatureBuilder {
    public static String getJvmMethodSignature(CtExecutable<?> method) {
        String argTypes = method.getParameters().stream().map(CtTypedElement::getType).map(JVMSignatureBuilder::getJvmTypeSignature).collect(Collectors.joining());
        String returnType = method instanceof CtConstructor ? "V" : JVMSignatureBuilder.getJvmTypeSignature(method.getType());
        return String.format("(%s)%s", argTypes, returnType);
    }

    public static String getJvmTypeSignature(CtTypeReference<?> typeRef) {
        TypeFactory typeFactory = typeRef.getFactory().Type();
        HashMap<CtTypeReference, String> primitiveToSignature = new HashMap<CtTypeReference, String>();
        primitiveToSignature.put(typeFactory.booleanPrimitiveType(), "Z");
        primitiveToSignature.put(typeFactory.bytePrimitiveType(), "B");
        primitiveToSignature.put(typeFactory.characterPrimitiveType(), "C");
        primitiveToSignature.put(typeFactory.shortPrimitiveType(), "S");
        primitiveToSignature.put(typeFactory.integerPrimitiveType(), "I");
        primitiveToSignature.put(typeFactory.longPrimitiveType(), "L");
        primitiveToSignature.put(typeFactory.floatPrimitiveType(), "F");
        primitiveToSignature.put(typeFactory.doublePrimitiveType(), "D");
        primitiveToSignature.put(typeFactory.voidPrimitiveType(), "V");
        if (typeRef.isPrimitive()) {
            return (String)primitiveToSignature.get(typeRef);
        }
        if (typeRef.isArray()) {
            CtArrayTypeReference arrayTypeRef = (CtArrayTypeReference)typeRef;
            String brackets = IntStream.range(0, arrayTypeRef.getDimensionCount()).mapToObj(i -> "[").collect(Collectors.joining());
            String elementTypeSignature = JVMSignatureBuilder.getJvmTypeSignature(arrayTypeRef.getArrayType());
            return brackets + elementTypeSignature;
        }
        return String.format("L%s;", typeRef.getQualifiedName().replace(".", "/"));
    }
}

