/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector.javaparser;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.LazyType;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnnotationDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserMethodDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeAdapter;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import com.github.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SymbolResolverWithRecordSupport
implements SymbolResolver {
    private final TypeSolver typeSolver;
    private final JavaSymbolSolver wrapped;

    public SymbolResolverWithRecordSupport(TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
        JavaParserFacade facade = JavaParserFacade.get((TypeSolver)typeSolver);
        try {
            Field field = facade.getClass().getDeclaredField("symbolResolver");
            field.setAccessible(true);
            field.set(facade, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.wrapped = new JavaSymbolSolver(typeSolver);
    }

    public <T> T resolveDeclaration(Node node, Class<T> resultClass) {
        return (T)this.wrapped.resolveDeclaration(node, resultClass);
    }

    public <T> T toResolvedType(Type javaparserType, Class<T> resultClass) {
        return (T)this.wrapped.toResolvedType(javaparserType, resultClass);
    }

    public ResolvedType calculateType(Expression expression) {
        return this.wrapped.calculateType(expression);
    }

    public ResolvedReferenceTypeDeclaration toTypeDeclaration(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration cNode = (ClassOrInterfaceDeclaration)node;
            if (cNode.isInterface()) {
                return new JavaParserInterfaceDeclaration(cNode, this.typeSolver);
            }
            return new JavaParserClassDeclaration(cNode, this.typeSolver);
        }
        if (node instanceof RecordDeclaration) {
            return new RecordClassDeclaration((RecordDeclaration)node, this.typeSolver);
        }
        if (node instanceof TypeParameter) {
            return new JavaParserTypeParameter((TypeParameter)node, this.typeSolver);
        }
        if (node instanceof EnumDeclaration) {
            return new JavaParserEnumDeclaration((EnumDeclaration)node, this.typeSolver);
        }
        if (node instanceof AnnotationDeclaration) {
            return new JavaParserAnnotationDeclaration((AnnotationDeclaration)node, this.typeSolver);
        }
        if (node instanceof EnumConstantDeclaration) {
            return new JavaParserEnumDeclaration((EnumDeclaration)Navigator.demandParentNode((Node)node), this.typeSolver);
        }
        throw new IllegalArgumentException("Cannot get a reference type declaration from " + node.getClass().getCanonicalName());
    }

    public static final class RecordClassDeclaration
    extends AbstractClassDeclaration
    implements MethodUsageResolutionCapability,
    SymbolResolutionCapability {
        private TypeSolver typeSolver;
        private RecordDeclaration wrappedNode;
        private JavaParserTypeAdapter<RecordDeclaration> javaParserTypeAdapter;
        private static final Class<?> RECORD_CLASS;

        public RecordClassDeclaration(RecordDeclaration wrappedNode, TypeSolver typeSolver) {
            this.wrappedNode = wrappedNode;
            this.typeSolver = typeSolver;
            this.javaParserTypeAdapter = new JavaParserTypeAdapter((Node)wrappedNode, typeSolver);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            RecordClassDeclaration that = (RecordClassDeclaration)((Object)o);
            return this.wrappedNode.equals((Object)that.wrappedNode);
        }

        public int hashCode() {
            return this.wrappedNode.hashCode();
        }

        public String toString() {
            return "RecordClassDeclaration{wrappedNode=" + this.wrappedNode + '}';
        }

        public List<ResolvedFieldDeclaration> getAllFields() {
            List fields = this.javaParserTypeAdapter.getFieldsForDeclaredVariables();
            this.getAncestors(true).stream().filter(ancestor -> ancestor.getTypeDeclaration().isPresent()).forEach(ancestor -> ((ResolvedReferenceTypeDeclaration)ancestor.getTypeDeclaration().get()).getAllFields().forEach(f -> fields.add(new ResolvedFieldDeclaration((ResolvedFieldDeclaration)f, (ResolvedReferenceType)ancestor){
                final /* synthetic */ ResolvedFieldDeclaration val$f;
                final /* synthetic */ ResolvedReferenceType val$ancestor;
                {
                    this.val$f = resolvedFieldDeclaration;
                    this.val$ancestor = resolvedReferenceType;
                }

                public AccessSpecifier accessSpecifier() {
                    return this.val$f.accessSpecifier();
                }

                public String getName() {
                    return this.val$f.getName();
                }

                public ResolvedType getType() {
                    return this.val$ancestor.useThisTypeParametersOnTheGivenType(this.val$f.getType());
                }

                public boolean isStatic() {
                    return this.val$f.isStatic();
                }

                public boolean isVolatile() {
                    return this.val$f.isVolatile();
                }

                public ResolvedTypeDeclaration declaringType() {
                    return this.val$f.declaringType();
                }

                public Optional<Node> toAst() {
                    return this.val$f.toAst();
                }
            })));
            return fields;
        }

        public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> parameterTypes) {
            Context ctx = this.getContext();
            return ctx.solveMethod(name, parameterTypes, false);
        }

        public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentTypes, Context invocationContext, List<ResolvedType> typeParameters) {
            return this.getContext().solveMethodAsUsage(name, argumentTypes);
        }

        @Deprecated
        public Context getContext() {
            return JavaParserFactory.getContext((Node)this.wrappedNode, (TypeSolver)this.typeSolver);
        }

        public ResolvedType getUsage(Node node) {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this.wrappedNode.getName().getId();
        }

        public Optional<ResolvedReferenceType> getSuperClass() {
            return Optional.of(this.record());
        }

        public List<ResolvedReferenceType> getInterfaces() {
            ArrayList<ResolvedReferenceType> interfaces = new ArrayList<ResolvedReferenceType>();
            if (this.wrappedNode.getImplementedTypes() != null) {
                for (ClassOrInterfaceType t : this.wrappedNode.getImplementedTypes()) {
                    interfaces.add(this.toReferenceType(t));
                }
            }
            return interfaces;
        }

        public List<ResolvedConstructorDeclaration> getConstructors() {
            return Collections.emptyList();
        }

        public boolean hasDirectlyAnnotation(String canonicalName) {
            return false;
        }

        public Set<ResolvedAnnotationDeclaration> getDeclaredAnnotations() {
            return this.javaParserTypeAdapter.getDeclaredAnnotations();
        }

        public boolean isInterface() {
            return false;
        }

        public String getPackageName() {
            return this.javaParserTypeAdapter.getPackageName();
        }

        public String getClassName() {
            return this.javaParserTypeAdapter.getClassName();
        }

        public String getQualifiedName() {
            return this.javaParserTypeAdapter.getQualifiedName();
        }

        public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
            return this.javaParserTypeAdapter.isAssignableBy(other);
        }

        public boolean isAssignableBy(ResolvedType type) {
            return this.javaParserTypeAdapter.isAssignableBy(type);
        }

        public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
            ResolvedReferenceTypeDeclaration superclassTypeDeclaration;
            Optional optionalSuperclassTypeDeclaration;
            if (this.getQualifiedName().equals(other.getQualifiedName())) {
                return true;
            }
            Optional<ResolvedReferenceType> optionalSuperClass = this.getSuperClass();
            if (optionalSuperClass.isPresent() && (optionalSuperclassTypeDeclaration = optionalSuperClass.get().getTypeDeclaration()).isPresent() && (superclassTypeDeclaration = (ResolvedReferenceTypeDeclaration)optionalSuperclassTypeDeclaration.get()) != this && superclassTypeDeclaration.isClass() && superclassTypeDeclaration.asClass().canBeAssignedTo(other)) {
                return true;
            }
            if (this.wrappedNode.getImplementedTypes() != null) {
                for (ClassOrInterfaceType type : this.wrappedNode.getImplementedTypes()) {
                    ResolvedReferenceTypeDeclaration ancestor = (ResolvedReferenceTypeDeclaration)new SymbolSolver(this.typeSolver).solveType((Type)type);
                    if (!ancestor.canBeAssignedTo(other)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isTypeParameter() {
            return false;
        }

        @Deprecated
        public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
            if (this.wrappedNode.getName().getId().equals(name)) {
                return SymbolReference.solved((ResolvedDeclaration)this);
            }
            SymbolReference ref = this.javaParserTypeAdapter.solveType(name);
            if (ref.isSolved()) {
                return ref;
            }
            String prefix = this.wrappedNode.getName().asString() + ".";
            if (name.startsWith(prefix) && name.length() > prefix.length()) {
                return new RecordClassDeclaration(this.wrappedNode, this.typeSolver).solveType(name.substring(prefix.length()));
            }
            return ((Context)this.getContext().getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty."))).solveType(name);
        }

        public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
            return this.getContext().solveMethod(name, argumentsTypes, staticOnly);
        }

        public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
            return this.getContext().solveSymbol(name);
        }

        public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
            Optional qualifiedName;
            ArrayList<ResolvedReferenceType> ancestors;
            block8: {
                ancestors = new ArrayList<ResolvedReferenceType>();
                if (this.isJavaLangObject()) {
                    return ancestors;
                }
                qualifiedName = this.wrappedNode.getFullyQualifiedName();
                if (!qualifiedName.isPresent()) {
                    return ancestors;
                }
                try {
                    Optional<ResolvedReferenceType> superClass = this.getSuperClass();
                    if (superClass.isPresent() && this.isAncestor(superClass.get(), (String)qualifiedName.get())) {
                        ancestors.add(superClass.get());
                    }
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) break block8;
                    throw e;
                }
            }
            for (ClassOrInterfaceType implemented : this.wrappedNode.getImplementedTypes()) {
                try {
                    ResolvedReferenceType rrt = this.toReferenceType(implemented);
                    if (!this.isAncestor(rrt, (String)qualifiedName.get())) continue;
                    ancestors.add(rrt);
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) continue;
                    throw e;
                }
            }
            return ancestors;
        }

        private boolean isAncestor(ResolvedReferenceType candidateAncestor, String ownQualifiedName) {
            Optional resolvedReferenceTypeDeclaration = candidateAncestor.getTypeDeclaration();
            if (resolvedReferenceTypeDeclaration.isPresent()) {
                ResolvedTypeDeclaration rtd = ((ResolvedReferenceTypeDeclaration)resolvedReferenceTypeDeclaration.get()).asType();
                return !rtd.hasInternalType(ownQualifiedName);
            }
            return false;
        }

        public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
            HashSet<ResolvedMethodDeclaration> methods = new HashSet<ResolvedMethodDeclaration>();
            for (BodyDeclaration member : this.wrappedNode.getMembers()) {
                if (!(member instanceof MethodDeclaration)) continue;
                methods.add((ResolvedMethodDeclaration)new JavaParserMethodDeclaration((MethodDeclaration)member, this.typeSolver));
            }
            return methods;
        }

        public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
            return this.wrappedNode.getTypeParameters().stream().map(tp -> new JavaParserTypeParameter(tp, this.typeSolver)).collect(Collectors.toList());
        }

        public RecordDeclaration getWrappedNode() {
            return this.wrappedNode;
        }

        public AccessSpecifier accessSpecifier() {
            return this.wrappedNode.getAccessSpecifier();
        }

        public Optional<Node> toAst() {
            return Optional.of(this.wrappedNode);
        }

        protected ResolvedReferenceType object() {
            ResolvedReferenceTypeDeclaration solvedJavaLangObject = this.typeSolver.getSolvedJavaLangObject();
            return new ReferenceTypeImpl(solvedJavaLangObject);
        }

        private ResolvedReferenceType record() {
            ResolvedReferenceTypeDeclaration solvedJavaLangObject = this.typeSolver.solveType(RECORD_CLASS.getCanonicalName());
            return new ReferenceTypeImpl(solvedJavaLangObject);
        }

        public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
            return this.javaParserTypeAdapter.internalTypes();
        }

        public Optional<ResolvedReferenceTypeDeclaration> containerType() {
            return this.javaParserTypeAdapter.containerType();
        }

        private ResolvedReferenceType toReferenceType(ClassOrInterfaceType classOrInterfaceType) {
            Optional localScope;
            SymbolReference<ResolvedTypeDeclaration> ref;
            String className = classOrInterfaceType.getName().getId();
            if (classOrInterfaceType.getScope().isPresent()) {
                className = classOrInterfaceType.getScope().get() + "." + className;
            }
            if (!(ref = this.solveType(className)).isSolved() && (localScope = classOrInterfaceType.getScope()).isPresent()) {
                String localName = ((ClassOrInterfaceType)localScope.get()).getName().getId() + "." + classOrInterfaceType.getName().getId();
                ref = this.solveType(localName);
            }
            if (!ref.isSolved()) {
                throw new UnsolvedSymbolException(classOrInterfaceType.getName().getId());
            }
            if (!classOrInterfaceType.getTypeArguments().isPresent()) {
                return new ReferenceTypeImpl(((ResolvedTypeDeclaration)ref.getCorrespondingDeclaration()).asReferenceType());
            }
            List superClassTypeParameters = ((NodeList)classOrInterfaceType.getTypeArguments().get()).stream().map(ta -> new LazyType(v -> JavaParserFacade.get((TypeSolver)this.typeSolver).convert(ta, (Node)ta))).collect(Collectors.toList());
            return new ReferenceTypeImpl(((ResolvedTypeDeclaration)ref.getCorrespondingDeclaration()).asReferenceType(), superClassTypeParameters);
        }

        static {
            Class recClass = Object.class;
            try {
                recClass = Class.forName("java.lang.Record");
            }
            catch (Exception exception) {
                // empty catch block
            }
            RECORD_CLASS = recClass;
        }
    }
}

