/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector.javaparser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.Problem;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.type.TypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.javadoctor.injector.Result;
import net.neoforged.javadoctor.injector.ast.JClass;
import net.neoforged.javadoctor.injector.ast.JClassParser;
import net.neoforged.javadoctor.injector.ast.JElement;
import net.neoforged.javadoctor.injector.ast.JField;
import net.neoforged.javadoctor.injector.ast.JMethod;
import net.neoforged.javadoctor.injector.ast.JParameter;
import net.neoforged.javadoctor.injector.ast.JRecord;
import net.neoforged.javadoctor.spec.JavadocEntry;

public class JavaparserClassParser
implements JClassParser {
    private final JavaParser parser;

    public JavaparserClassParser(JavaParser parser) {
        this.parser = parser;
    }

    public Result<List<JClass>> parse(String classText) {
        ParseResult result = this.parser.parse(classText);
        if (result.isSuccessful()) {
            CompilationUnit unit = (CompilationUnit)result.getResult().get();
            return new Result(unit.getTypes().stream().map(this::createClass).collect(Collectors.toList()));
        }
        return new Result(result.getProblems().stream().map(Problem::toString).collect(Collectors.toList()));
    }

    public Map<String, JavadocEntry> processMethodMap(Map<String, JavadocEntry> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).replace('$', '/'), Map.Entry::getValue));
    }

    private JClass createClass(TypeDeclaration<?> declaration) {
        if (declaration instanceof RecordDeclaration) {
            return new BaseRecord((RecordDeclaration)declaration);
        }
        return new BaseClass(this, declaration);
    }

    private JField createField(final String name, final Optional<Range> pos) {
        return new JField(){

            public OptionalInt getSourceLine() {
                return pos.map(range -> OptionalInt.of(range.begin.line)).orElseGet(OptionalInt::empty);
            }

            public String getName() {
                return name;
            }

            public String toString() {
                return "JField[name=" + name + "]";
            }
        };
    }

    private static class BaseClass<T extends TypeDeclaration<?>>
    implements JClass {
        protected final T declaration;
        private final List<JElement> children;
        final /* synthetic */ JavaparserClassParser this$0;

        private BaseClass(T declaration) {
            this.this$0 = var1_1;
            this.declaration = declaration;
            this.children = declaration.getMembers().stream().map(it -> {
                if (it instanceof FieldDeclaration) {
                    return this.this$0.createField(((FieldDeclaration)it).getVariable(0).getNameAsString(), it.getRange());
                }
                if (it instanceof CallableDeclaration) {
                    boolean ctor;
                    Supplier<String> desc;
                    final CallableDeclaration method = (CallableDeclaration)it;
                    if (method instanceof MethodDeclaration) {
                        MethodDeclaration m = (MethodDeclaration)method;
                        desc = () -> m.getNameAsString() + m.toDescriptor();
                        ctor = false;
                    } else {
                        desc = () -> "<init>" + ((ConstructorDeclaration)method).toDescriptor();
                        ctor = true;
                    }
                    return new JMethod(){

                        public String getDescriptor() {
                            return (String)desc.get();
                        }

                        public boolean isConstructor() {
                            return ctor;
                        }

                        public OptionalInt getSourceLine() {
                            return method.getRange().map(range -> OptionalInt.of(range.begin.line)).orElseGet(OptionalInt::empty);
                        }

                        public String getName() {
                            return method.getNameAsString();
                        }

                        public List<JParameter> getParameters() {
                            return method.getParameters().stream().map(t -> () -> ((Parameter)t).getNameAsString()).collect(Collectors.toList());
                        }

                        public List<JParameter> getTypeParameters() {
                            return method.getTypeParameters().stream().map(t -> () -> ((TypeParameter)t).getNameAsString()).collect(Collectors.toList());
                        }
                    };
                }
                if (it instanceof TypeDeclaration) {
                    return this.this$0.createClass((TypeDeclaration)it);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
            if (declaration instanceof EnumDeclaration) {
                ((EnumDeclaration)declaration).getEntries().forEach(enumField -> this.children.add((JElement)this.this$0.createField(enumField.getNameAsString(), enumField.getRange())));
            }
        }

        public String getFullyQualifiedName() {
            return this.declaration.getFullyQualifiedName().orElseGet(this::getName);
        }

        public List<JElement> getChildren() {
            return this.children;
        }

        public OptionalInt getSourceLine() {
            if (this.declaration.getRange().isPresent()) {
                return OptionalInt.of(((Range)this.declaration.getRange().get()).begin.line);
            }
            return OptionalInt.empty();
        }

        public String getName() {
            return this.declaration.getNameAsString();
        }

        public List<JParameter> getTypeParameters() {
            if (this.declaration instanceof NodeWithTypeParameters) {
                return ((NodeWithTypeParameters)this.declaration).getTypeParameters().stream().map(t -> () -> ((TypeParameter)t).getNameAsString()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    private class BaseRecord
    extends BaseClass<RecordDeclaration>
    implements JRecord {
        private BaseRecord(RecordDeclaration declaration) {
            super(JavaparserClassParser.this, (TypeDeclaration)declaration);
        }

        public List<JParameter> getParameters() {
            return ((RecordDeclaration)this.declaration).getParameters().stream().map(it -> () -> ((Parameter)it).getNameAsString()).collect(Collectors.toList());
        }
    }
}

