/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.spec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.neoforged.javadoctor.spec.JavadocEntry;
import org.jetbrains.annotations.Nullable;

public final class ClassJavadoc {
    @Nullable
    private final JavadocEntry clazz;
    @Nullable
    private final Map<String, JavadocEntry> methods;
    @Nullable
    private final Map<String, JavadocEntry> fields;
    private final Map<String, ClassJavadoc> innerClasses;

    public ClassJavadoc() {
        this(null, null, null, null);
    }

    public ClassJavadoc(@Nullable JavadocEntry clazz, @Nullable Map<String, JavadocEntry> methods, @Nullable Map<String, JavadocEntry> fields, @Nullable Map<String, ClassJavadoc> innerClasses) {
        this.clazz = clazz;
        this.methods = methods;
        this.fields = fields;
        this.innerClasses = innerClasses == null ? new HashMap() : innerClasses;
    }

    @Nullable
    public JavadocEntry clazz() {
        return this.clazz;
    }

    @Nullable
    public Map<String, JavadocEntry> methods() {
        return this.methods;
    }

    @Nullable
    public Map<String, JavadocEntry> fields() {
        return this.fields;
    }

    public Map<String, ClassJavadoc> innerClasses() {
        return this.innerClasses;
    }

    public ClassJavadoc merge(@Nullable ClassJavadoc other) {
        if (other == null) {
            return this;
        }
        return new ClassJavadoc(this.clazz == null ? other.clazz : this.clazz, ClassJavadoc.mergeMaps(JavadocEntry::merge, this.methods, other.methods), ClassJavadoc.mergeMaps(JavadocEntry::merge, this.fields, other.fields), ClassJavadoc.mergeMaps(ClassJavadoc::merge, this.innerClasses, other.innerClasses));
    }

    public boolean isEmpty() {
        return this.clazz == null && this.methods == null && this.fields == null && this.innerClasses.isEmpty();
    }

    @SafeVarargs
    static <K, V> Map<K, V> mergeMaps(BiFunction<V, V, V> valueMerger, Map<K, V> ... maps) {
        if (maps.length == 1) {
            return maps[0];
        }
        HashMap newMap = new HashMap();
        for (Map<Object, Object> map : maps) {
            if (map == null) continue;
            map.forEach((k, v) -> {
                Object oldValue = newMap.get(k);
                if (oldValue == null) {
                    newMap.put(k, v);
                } else {
                    newMap.replace(k, valueMerger.apply(oldValue, v));
                }
            });
        }
        return newMap;
    }

    @SafeVarargs
    static <T> List<T> mergeLists(List<T> ... lists) {
        if (lists.length == 1) {
            return lists[0];
        }
        ArrayList<T> list = new ArrayList<T>();
        for (List<T> ts : lists) {
            if (ts == null) continue;
            list.addAll(ts);
        }
        return list;
    }
}

