/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector.javaparser;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.LazyType;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnnotationDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserMethodDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeAdapter;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import com.github.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SymbolResolverWithRecordSupport
implements SymbolResolver {
    private final TypeSolver typeSolver;
    private final JavaSymbolSolver wrapped;

    public SymbolResolverWithRecordSupport(TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
        JavaParserFacade facade = JavaParserFacade.get(typeSolver);
        try {
            Field field = facade.getClass().getDeclaredField("symbolResolver");
            field.setAccessible(true);
            field.set(facade, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.wrapped = new JavaSymbolSolver(typeSolver);
    }

    @Override
    public <T> T resolveDeclaration(Node node, Class<T> resultClass) {
        return this.wrapped.resolveDeclaration(node, resultClass);
    }

    @Override
    public <T> T toResolvedType(Type javaparserType, Class<T> resultClass) {
        return this.wrapped.toResolvedType(javaparserType, resultClass);
    }

    @Override
    public ResolvedType calculateType(Expression expression) {
        return this.wrapped.calculateType(expression);
    }

    @Override
    public ResolvedReferenceTypeDeclaration toTypeDeclaration(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration cNode = (ClassOrInterfaceDeclaration)node;
            if (cNode.isInterface()) {
                return new JavaParserInterfaceDeclaration(cNode, this.typeSolver);
            }
            return new JavaParserClassDeclaration(cNode, this.typeSolver);
        }
        if (node instanceof RecordDeclaration) {
            return new RecordClassDeclaration((RecordDeclaration)node, this.typeSolver);
        }
        if (node instanceof TypeParameter) {
            return new JavaParserTypeParameter((TypeParameter)node, this.typeSolver);
        }
        if (node instanceof EnumDeclaration) {
            return new JavaParserEnumDeclaration((EnumDeclaration)node, this.typeSolver);
        }
        if (node instanceof AnnotationDeclaration) {
            return new JavaParserAnnotationDeclaration((AnnotationDeclaration)node, this.typeSolver);
        }
        if (node instanceof EnumConstantDeclaration) {
            return new JavaParserEnumDeclaration((EnumDeclaration)Navigator.demandParentNode(node), this.typeSolver);
        }
        throw new IllegalArgumentException("Cannot get a reference type declaration from " + node.getClass().getCanonicalName());
    }

    public static final class RecordClassDeclaration
    extends AbstractClassDeclaration
    implements MethodUsageResolutionCapability,
    SymbolResolutionCapability {
        private TypeSolver typeSolver;
        private RecordDeclaration wrappedNode;
        private JavaParserTypeAdapter<RecordDeclaration> javaParserTypeAdapter;
        private static final Class<?> RECORD_CLASS;

        public RecordClassDeclaration(RecordDeclaration wrappedNode, TypeSolver typeSolver) {
            this.wrappedNode = wrappedNode;
            this.typeSolver = typeSolver;
            this.javaParserTypeAdapter = new JavaParserTypeAdapter<RecordDeclaration>(wrappedNode, typeSolver);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordClassDeclaration that = (RecordClassDeclaration)o;
            return this.wrappedNode.equals(that.wrappedNode);
        }

        public int hashCode() {
            return this.wrappedNode.hashCode();
        }

        public String toString() {
            return "RecordClassDeclaration{wrappedNode=" + this.wrappedNode + '}';
        }

        @Override
        public List<ResolvedFieldDeclaration> getAllFields() {
            List<ResolvedFieldDeclaration> fields = this.javaParserTypeAdapter.getFieldsForDeclaredVariables();
            this.getAncestors(true).stream().filter(ancestor -> ancestor.getTypeDeclaration().isPresent()).forEach(ancestor -> ancestor.getTypeDeclaration().get().getAllFields().forEach(f -> fields.add(new ResolvedFieldDeclaration((ResolvedFieldDeclaration)f, (ResolvedReferenceType)ancestor){
                final /* synthetic */ ResolvedFieldDeclaration val$f;
                final /* synthetic */ ResolvedReferenceType val$ancestor;
                {
                    this.val$f = resolvedFieldDeclaration;
                    this.val$ancestor = resolvedReferenceType;
                }

                @Override
                public AccessSpecifier accessSpecifier() {
                    return this.val$f.accessSpecifier();
                }

                @Override
                public String getName() {
                    return this.val$f.getName();
                }

                @Override
                public ResolvedType getType() {
                    return this.val$ancestor.useThisTypeParametersOnTheGivenType(this.val$f.getType());
                }

                @Override
                public boolean isStatic() {
                    return this.val$f.isStatic();
                }

                @Override
                public boolean isVolatile() {
                    return this.val$f.isVolatile();
                }

                @Override
                public ResolvedTypeDeclaration declaringType() {
                    return this.val$f.declaringType();
                }

                @Override
                public Optional<Node> toAst() {
                    return this.val$f.toAst();
                }
            })));
            return fields;
        }

        public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> parameterTypes) {
            Context ctx = this.getContext();
            return ctx.solveMethod(name, parameterTypes, false);
        }

        @Override
        public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentTypes, Context invocationContext, List<ResolvedType> typeParameters) {
            return this.getContext().solveMethodAsUsage(name, argumentTypes);
        }

        @Deprecated
        public Context getContext() {
            return JavaParserFactory.getContext(this.wrappedNode, this.typeSolver);
        }

        public ResolvedType getUsage(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.wrappedNode.getName().getId();
        }

        @Override
        public Optional<ResolvedReferenceType> getSuperClass() {
            return Optional.of(this.record());
        }

        @Override
        public List<ResolvedReferenceType> getInterfaces() {
            ArrayList<ResolvedReferenceType> interfaces = new ArrayList<ResolvedReferenceType>();
            if (this.wrappedNode.getImplementedTypes() != null) {
                for (ClassOrInterfaceType t : this.wrappedNode.getImplementedTypes()) {
                    interfaces.add(this.toReferenceType(t));
                }
            }
            return interfaces;
        }

        @Override
        public List<ResolvedConstructorDeclaration> getConstructors() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasDirectlyAnnotation(String canonicalName) {
            return false;
        }

        @Override
        public Set<ResolvedAnnotationDeclaration> getDeclaredAnnotations() {
            return this.javaParserTypeAdapter.getDeclaredAnnotations();
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public String getPackageName() {
            return this.javaParserTypeAdapter.getPackageName();
        }

        @Override
        public String getClassName() {
            return this.javaParserTypeAdapter.getClassName();
        }

        @Override
        public String getQualifiedName() {
            return this.javaParserTypeAdapter.getQualifiedName();
        }

        @Override
        public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
            return this.javaParserTypeAdapter.isAssignableBy(other);
        }

        @Override
        public boolean isAssignableBy(ResolvedType type) {
            return this.javaParserTypeAdapter.isAssignableBy(type);
        }

        @Override
        public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
            ResolvedReferenceTypeDeclaration superclassTypeDeclaration;
            Optional<ResolvedReferenceTypeDeclaration> optionalSuperclassTypeDeclaration;
            if (this.getQualifiedName().equals(other.getQualifiedName())) {
                return true;
            }
            Optional<ResolvedReferenceType> optionalSuperClass = this.getSuperClass();
            if (optionalSuperClass.isPresent() && (optionalSuperclassTypeDeclaration = optionalSuperClass.get().getTypeDeclaration()).isPresent() && (superclassTypeDeclaration = optionalSuperclassTypeDeclaration.get()) != this && superclassTypeDeclaration.isClass() && superclassTypeDeclaration.asClass().canBeAssignedTo(other)) {
                return true;
            }
            if (this.wrappedNode.getImplementedTypes() != null) {
                for (ClassOrInterfaceType type : this.wrappedNode.getImplementedTypes()) {
                    ResolvedReferenceTypeDeclaration ancestor = (ResolvedReferenceTypeDeclaration)new SymbolSolver(this.typeSolver).solveType(type);
                    if (!ancestor.canBeAssignedTo(other)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isTypeParameter() {
            return false;
        }

        @Deprecated
        public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
            if (this.wrappedNode.getName().getId().equals(name)) {
                return SymbolReference.solved(this);
            }
            SymbolReference<ResolvedTypeDeclaration> ref = this.javaParserTypeAdapter.solveType(name);
            if (ref.isSolved()) {
                return ref;
            }
            String prefix = this.wrappedNode.getName().asString() + ".";
            if (name.startsWith(prefix) && name.length() > prefix.length()) {
                return new RecordClassDeclaration(this.wrappedNode, this.typeSolver).solveType(name.substring(prefix.length()));
            }
            return this.getContext().getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty.")).solveType(name);
        }

        @Override
        public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
            return this.getContext().solveMethod(name, argumentsTypes, staticOnly);
        }

        @Override
        public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
            return this.getContext().solveSymbol(name);
        }

        @Override
        public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
            Optional<String> qualifiedName;
            ArrayList<ResolvedReferenceType> ancestors;
            block8: {
                ancestors = new ArrayList<ResolvedReferenceType>();
                if (this.isJavaLangObject()) {
                    return ancestors;
                }
                qualifiedName = this.wrappedNode.getFullyQualifiedName();
                if (!qualifiedName.isPresent()) {
                    return ancestors;
                }
                try {
                    Optional<ResolvedReferenceType> superClass = this.getSuperClass();
                    if (superClass.isPresent() && this.isAncestor(superClass.get(), qualifiedName.get())) {
                        ancestors.add(superClass.get());
                    }
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) break block8;
                    throw e;
                }
            }
            for (ClassOrInterfaceType implemented : this.wrappedNode.getImplementedTypes()) {
                try {
                    ResolvedReferenceType rrt = this.toReferenceType(implemented);
                    if (!this.isAncestor(rrt, qualifiedName.get())) continue;
                    ancestors.add(rrt);
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) continue;
                    throw e;
                }
            }
            return ancestors;
        }

        private boolean isAncestor(ResolvedReferenceType candidateAncestor, String ownQualifiedName) {
            Optional<ResolvedReferenceTypeDeclaration> resolvedReferenceTypeDeclaration = candidateAncestor.getTypeDeclaration();
            if (resolvedReferenceTypeDeclaration.isPresent()) {
                ResolvedTypeDeclaration rtd = resolvedReferenceTypeDeclaration.get().asType();
                return !rtd.hasInternalType(ownQualifiedName);
            }
            return false;
        }

        @Override
        public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
            HashSet<ResolvedMethodDeclaration> methods = new HashSet<ResolvedMethodDeclaration>();
            for (BodyDeclaration<?> member : this.wrappedNode.getMembers()) {
                if (!(member instanceof MethodDeclaration)) continue;
                methods.add(new JavaParserMethodDeclaration((MethodDeclaration)member, this.typeSolver));
            }
            return methods;
        }

        @Override
        public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
            return this.wrappedNode.getTypeParameters().stream().map(tp -> new JavaParserTypeParameter((TypeParameter)tp, this.typeSolver)).collect(Collectors.toList());
        }

        public RecordDeclaration getWrappedNode() {
            return this.wrappedNode;
        }

        @Override
        public AccessSpecifier accessSpecifier() {
            return this.wrappedNode.getAccessSpecifier();
        }

        @Override
        public Optional<Node> toAst() {
            return Optional.of(this.wrappedNode);
        }

        @Override
        protected ResolvedReferenceType object() {
            ResolvedReferenceTypeDeclaration solvedJavaLangObject = this.typeSolver.getSolvedJavaLangObject();
            return new ReferenceTypeImpl(solvedJavaLangObject);
        }

        private ResolvedReferenceType record() {
            ResolvedReferenceTypeDeclaration solvedJavaLangObject = this.typeSolver.solveType(RECORD_CLASS.getCanonicalName());
            return new ReferenceTypeImpl(solvedJavaLangObject);
        }

        @Override
        public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
            return this.javaParserTypeAdapter.internalTypes();
        }

        @Override
        public Optional<ResolvedReferenceTypeDeclaration> containerType() {
            return this.javaParserTypeAdapter.containerType();
        }

        private ResolvedReferenceType toReferenceType(ClassOrInterfaceType classOrInterfaceType) {
            Optional<ClassOrInterfaceType> localScope;
            SymbolReference<ResolvedTypeDeclaration> ref;
            String className = classOrInterfaceType.getName().getId();
            if (classOrInterfaceType.getScope().isPresent()) {
                className = classOrInterfaceType.getScope().get() + "." + className;
            }
            if (!(ref = this.solveType(className)).isSolved() && (localScope = classOrInterfaceType.getScope()).isPresent()) {
                String localName = localScope.get().getName().getId() + "." + classOrInterfaceType.getName().getId();
                ref = this.solveType(localName);
            }
            if (!ref.isSolved()) {
                throw new UnsolvedSymbolException(classOrInterfaceType.getName().getId());
            }
            if (!classOrInterfaceType.getTypeArguments().isPresent()) {
                return new ReferenceTypeImpl(ref.getCorrespondingDeclaration().asReferenceType());
            }
            List<ResolvedType> superClassTypeParameters = classOrInterfaceType.getTypeArguments().get().stream().map(ta -> new LazyType(v -> JavaParserFacade.get(this.typeSolver).convert((Type)ta, (Node)ta))).collect(Collectors.toList());
            return new ReferenceTypeImpl(ref.getCorrespondingDeclaration().asReferenceType(), superClassTypeParameters);
        }

        static {
            Class recClass = Object.class;
            try {
                recClass = Class.forName("java.lang.Record");
            }
            catch (Exception exception) {
                // empty catch block
            }
            RECORD_CLASS = recClass;
        }
    }
}

