/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.injector.javaparser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.Problem;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.javadoctor.injector.Result;
import net.neoforged.javadoctor.injector.ast.JClass;
import net.neoforged.javadoctor.injector.ast.JClassParser;
import net.neoforged.javadoctor.injector.ast.JElement;
import net.neoforged.javadoctor.injector.ast.JField;
import net.neoforged.javadoctor.injector.ast.JMethod;
import net.neoforged.javadoctor.injector.ast.JParameter;
import net.neoforged.javadoctor.injector.ast.JRecord;
import net.neoforged.javadoctor.spec.JavadocEntry;

public class JavaparserClassParser
implements JClassParser {
    private final JavaParser parser;

    public JavaparserClassParser(JavaParser parser) {
        this.parser = parser;
    }

    @Override
    public Result<List<JClass>> parse(String classText) {
        ParseResult<CompilationUnit> result = this.parser.parse(classText);
        if (result.isSuccessful()) {
            CompilationUnit unit = result.getResult().get();
            return new Result<List<JClass>>(unit.getTypes().stream().map(this::createClass).collect(Collectors.toList()));
        }
        return new Result<List<JClass>>(result.getProblems().stream().map(Problem::toString).collect(Collectors.toList()));
    }

    @Override
    public Map<String, JavadocEntry> processMethodMap(Map<String, JavadocEntry> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).replace('$', '/'), Map.Entry::getValue));
    }

    private JClass createClass(TypeDeclaration<?> declaration) {
        if (declaration instanceof RecordDeclaration) {
            return new BaseRecord((RecordDeclaration)declaration);
        }
        return new BaseClass(this, declaration);
    }

    private JField createField(final String name, final Optional<Range> pos) {
        return new JField(){

            @Override
            public OptionalInt getSourceLine() {
                return pos.map(range -> OptionalInt.of(range.begin.line)).orElseGet(OptionalInt::empty);
            }

            @Override
            public String getName() {
                return name;
            }

            public String toString() {
                return "JField[name=" + name + "]";
            }
        };
    }

    private static class BaseClass<T extends TypeDeclaration<?>>
    implements JClass {
        protected final T declaration;
        private final List<JElement> children;
        final /* synthetic */ JavaparserClassParser this$0;

        private BaseClass(T declaration) {
            this.this$0 = var1_1;
            this.declaration = declaration;
            this.children = ((TypeDeclaration)declaration).getMembers().stream().map(it -> {
                if (it instanceof FieldDeclaration) {
                    return this.this$0.createField(((FieldDeclaration)it).getVariable(0).getNameAsString(), it.getRange());
                }
                if (it instanceof CallableDeclaration) {
                    boolean ctor;
                    Supplier<String> desc;
                    final CallableDeclaration method = (CallableDeclaration)it;
                    if (method instanceof MethodDeclaration) {
                        MethodDeclaration m3 = (MethodDeclaration)method;
                        desc = () -> m3.getNameAsString() + m3.toDescriptor();
                        ctor = false;
                    } else {
                        desc = () -> "<init>" + ((ConstructorDeclaration)method).toDescriptor();
                        ctor = true;
                    }
                    return new JMethod(){

                        @Override
                        public String getDescriptor() {
                            return (String)desc.get();
                        }

                        @Override
                        public boolean isConstructor() {
                            return ctor;
                        }

                        @Override
                        public OptionalInt getSourceLine() {
                            return method.getRange().map(range -> OptionalInt.of(range.begin.line)).orElseGet(OptionalInt::empty);
                        }

                        @Override
                        public String getName() {
                            return method.getNameAsString();
                        }

                        @Override
                        public List<JParameter> getParameters() {
                            return method.getParameters().stream().map(t -> t::getNameAsString).collect(Collectors.toList());
                        }

                        @Override
                        public List<JParameter> getTypeParameters() {
                            return method.getTypeParameters().stream().map(t -> t::getNameAsString).collect(Collectors.toList());
                        }
                    };
                }
                if (it instanceof TypeDeclaration) {
                    return this.this$0.createClass((TypeDeclaration)it);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
            if (declaration instanceof EnumDeclaration) {
                ((EnumDeclaration)declaration).getEntries().forEach(enumField -> this.children.add(this.this$0.createField(enumField.getNameAsString(), enumField.getRange())));
            }
        }

        @Override
        public String getFullyQualifiedName() {
            return ((TypeDeclaration)this.declaration).getFullyQualifiedName().orElseGet(this::getName);
        }

        @Override
        public List<JElement> getChildren() {
            return this.children;
        }

        @Override
        public OptionalInt getSourceLine() {
            if (((Node)this.declaration).getRange().isPresent()) {
                return OptionalInt.of(((Node)this.declaration).getRange().get().begin.line);
            }
            return OptionalInt.empty();
        }

        @Override
        public String getName() {
            return this.declaration.getNameAsString();
        }

        @Override
        public List<JParameter> getTypeParameters() {
            if (this.declaration instanceof NodeWithTypeParameters) {
                return ((NodeWithTypeParameters)this.declaration).getTypeParameters().stream().map(t -> t::getNameAsString).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    private class BaseRecord
    extends BaseClass<RecordDeclaration>
    implements JRecord {
        private BaseRecord(RecordDeclaration declaration) {
            super(JavaparserClassParser.this, declaration);
        }

        @Override
        public List<JParameter> getParameters() {
            return ((RecordDeclaration)this.declaration).getParameters().stream().map(it -> it::getNameAsString).collect(Collectors.toList());
        }
    }
}

