/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typeinference;

import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.model.typesystem.NullType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.resolution.types.parametrization.ResolvedTypeParametersMap;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeHelper;
import com.github.javaparser.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class LeastUpperBoundLogic {
    private Set<Set<ResolvedType>> lubCache = new HashSet<Set<ResolvedType>>();

    public static LeastUpperBoundLogic of() {
        return new LeastUpperBoundLogic();
    }

    private LeastUpperBoundLogic() {
    }

    public ResolvedType lub(Set<ResolvedType> types) {
        HashSet<ResolvedType> searchedTypes;
        ResolvedType erasedBest;
        if (types.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Set<ResolvedType> resolvedTypes = types.stream().filter(type -> !(type instanceof NullType)).collect(Collectors.toSet());
        if (resolvedTypes.size() == 1) {
            return (ResolvedType)resolvedTypes.stream().findFirst().get();
        }
        List<Set<ResolvedType>> supertypes = this.supertypes(resolvedTypes);
        List<Set<ResolvedType>> erasedSupertypes = this.erased(supertypes);
        List<ResolvedType> erasedCandidates = this.intersection(erasedSupertypes);
        List<ResolvedType> minimalErasedCandidates = this.minimalCandidates(erasedCandidates);
        if (minimalErasedCandidates.isEmpty()) {
            return null;
        }
        Multimap<ResolvedType, ResolvedType> relevantParameterizations = this.relevantParameterizations(minimalErasedCandidates, supertypes);
        Collection<ResolvedType> erasedTypeParameterizations = relevantParameterizations.get(erasedBest = this.best(minimalErasedCandidates));
        if (erasedTypeParameterizations != null && !erasedTypeParameterizations.contains(erasedBest) && !this.lubCache.contains(searchedTypes = new HashSet<ResolvedType>(resolvedTypes))) {
            this.lubCache.add(searchedTypes);
            return this.leastContainingParameterization(new ArrayList<ResolvedType>(erasedTypeParameterizations));
        }
        return erasedBest;
    }

    private List<Set<ResolvedType>> supertypes(Set<ResolvedType> types) {
        return types.stream().map(type -> this.supertypes((ResolvedType)type).stream().collect(Collectors.toCollection(LinkedHashSet::new))).collect(Collectors.toList());
    }

    private Set<ResolvedType> supertypes(ResolvedType type) {
        return type.isReferenceType() ? this.supertypes(type.asReferenceType()) : new LinkedHashSet();
    }

    private Set<ResolvedType> supertypes(ResolvedReferenceType type) {
        LinkedHashSet<ResolvedType> supertypes = new LinkedHashSet<ResolvedType>();
        supertypes.add(type);
        supertypes.addAll(type.getAllAncestors());
        return supertypes;
    }

    private List<Set<ResolvedType>> erased(List<Set<ResolvedType>> typeSets) {
        return typeSets.stream().map(set -> set.stream().map(ResolvedType::erasure).collect(Collectors.toCollection(LinkedHashSet::new))).collect(Collectors.toList());
    }

    private List<ResolvedType> intersection(List<Set<ResolvedType>> supertypes) {
        return new ArrayList<ResolvedType>((Collection)supertypes.stream().reduce(this.union(supertypes), Sets::intersection));
    }

    private Set<ResolvedType> union(List<Set<ResolvedType>> supertypes) {
        return supertypes.stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<ResolvedType> minimalCandidates(List<ResolvedType> erasedCandidates) {
        ArrayList<ResolvedType> results = new ArrayList<ResolvedType>();
        for (ResolvedType v : erasedCandidates) {
            if (!erasedCandidates.stream().noneMatch(w -> !w.equals(v) && v.isAssignableBy((ResolvedType)w))) continue;
            results.add(v);
        }
        return results;
    }

    private Multimap<ResolvedType, ResolvedType> relevantParameterizations(List<ResolvedType> minimalErasedCandidates, List<Set<ResolvedType>> supertypes) {
        SetMultimap<ResolvedType, ResolvedType> result = Multimaps.newSetMultimap(new HashMap(), LinkedHashSet::new);
        for (Set<ResolvedType> supertypesSet : supertypes) {
            for (ResolvedType supertype : supertypesSet) {
                ResolvedType erasedSupertype = supertype.erasure();
                if (!minimalErasedCandidates.contains(erasedSupertype)) continue;
                result.put(erasedSupertype, supertype);
            }
        }
        return result;
    }

    private ResolvedType best(List<ResolvedType> minimalCandidates) {
        Collections.sort(minimalCandidates, (t1, t2) -> {
            ResolvedReferenceTypeDeclaration t1Symbol = t1.asReferenceType().getTypeDeclaration().get();
            ResolvedReferenceTypeDeclaration t2Symbol = t2.asReferenceType().getTypeDeclaration().get();
            if (t1Symbol.isInterface() && t2Symbol.isInterface()) {
                return t1Symbol.getQualifiedName().compareTo(t2Symbol.getQualifiedName());
            }
            if (t1Symbol.isInterface()) {
                return 1;
            }
            if (t2Symbol.isInterface()) {
                return -1;
            }
            return t1Symbol.getQualifiedName().compareTo(t2Symbol.getQualifiedName());
        });
        return minimalCandidates.get(0);
    }

    private ResolvedType leastContainingParameterization(List<ResolvedType> types) {
        if (types.size() == 1) {
            return types.get(0);
        }
        ResolvedType type1 = types.get(0);
        ResolvedType type2 = types.get(1);
        ResolvedType reduction = this.leastContainingTypeArgument(type1, type2);
        ArrayList<ResolvedType> reducedList = Lists.newArrayList(reduction);
        reducedList.addAll(types.subList(2, types.size()));
        return this.leastContainingParameterization(reducedList);
    }

    private ResolvedType leastContainingTypeArgument(ResolvedType type1, ResolvedType type2) {
        TypeSubstitution substitution1 = this.substitution(type1.asReferenceType().getTypeParametersMap());
        TypeSubstitution substitution2 = this.substitution(type2.asReferenceType().getTypeParametersMap());
        TypeSubstitution typeSubstitution = TypeSubstitution.empty();
        for (ResolvedTypeParameterDeclaration typeDecl : substitution1.typeParameterDeclarations()) {
            ResolvedType subs1 = substitution1.substitutedType(typeDecl);
            ResolvedType subs2 = substitution2.substitutedType(typeDecl);
            subs1 = this.isSubstituable(typeDecl, subs1) && subs2.isReferenceType() ? subs2 : subs1;
            subs2 = this.isSubstituable(typeDecl, subs2) && subs1.isReferenceType() ? subs1 : subs2;
            ResolvedType newType = this.lcta(subs1, subs2);
            typeSubstitution.withPair(typeDecl, newType);
        }
        return typeSubstitution.isEmpty() ? this.lcta(type1, type2) : this.substituteType(type1, typeSubstitution);
    }

    private boolean isSubstituable(ResolvedTypeParameterDeclaration typeDecl, ResolvedType type) {
        return type.isTypeVariable() && (!typeDecl.hasBound() || this.boundedAsObject(typeDecl));
    }

    private boolean boundedAsObject(ResolvedTypeParameterDeclaration typeDecl) {
        List<ResolvedTypeParameterDeclaration.Bound> bounds = typeDecl.getBounds();
        return bounds.size() == 1 && bounds.get(0).getType().equals(typeDecl.object());
    }

    private ResolvedType substituteType(ResolvedType type1, TypeSubstitution typeSubstitution) {
        ResolvedTypeParametersMap.Builder typeParametersMapBuilder = type1.asReferenceType().typeParametersMap().toBuilder();
        for (ResolvedTypeParameterDeclaration rtpd : typeSubstitution.typeParameterDeclarations) {
            typeParametersMapBuilder.setValue(rtpd, typeSubstitution.substitutedType(rtpd));
        }
        return type1.asReferenceType().deriveTypeParameters(typeParametersMapBuilder.build());
    }

    private TypeSubstitution substitution(List<Pair<ResolvedTypeParameterDeclaration, ResolvedType>> pairs) {
        TypeSubstitution substitution = TypeSubstitution.empty();
        pairs.stream().forEach(pair -> substitution.withPair((ResolvedTypeParameterDeclaration)pair.a, (ResolvedType)pair.b));
        return substitution;
    }

    private ResolvedType lcta(ResolvedType type1, ResolvedType type2) {
        ResolvedType result;
        boolean isWildcard1 = type1.isWildcard();
        boolean isWildcard2 = type2.isWildcard();
        if (type1.equals(type2)) {
            result = type1;
        } else if (isWildcard1 && isWildcard2) {
            result = this.lctaBothWildcards(type1.asWildcard(), type2.asWildcard());
        } else if (isWildcard1 ^ isWildcard2) {
            ResolvedType rawType = isWildcard1 ? type2 : type1;
            ResolvedWildcard wildcardType = (ResolvedWildcard)(isWildcard1 ? type1 : type2);
            result = this.lctaOneWildcard(rawType, wildcardType);
        } else {
            result = this.lctaNoWildcard(type1, type2);
        }
        return result;
    }

    private ResolvedType lctaNoWildcard(ResolvedType type1, ResolvedType type2) {
        ResolvedType lub = this.lub(this.toSet(type1, type2));
        return this.bound(lub, ResolvedWildcard.BoundType.EXTENDS);
    }

    private ResolvedType lctaOneWildcard(ResolvedType rawType, ResolvedWildcard wildcardType) {
        if (wildcardType.isUpperBounded()) {
            ResolvedType glb = TypeHelper.glb(this.toSet(rawType, wildcardType.getBoundedType()));
            return this.bound(glb, ResolvedWildcard.BoundType.SUPER);
        }
        ResolvedType lub = this.lub(this.toSet(rawType, wildcardType.getBoundedType()));
        return this.bound(lub, ResolvedWildcard.BoundType.EXTENDS);
    }

    private ResolvedType lctaBothWildcards(ResolvedWildcard type1, ResolvedWildcard type2) {
        if (type1.isUpperBounded() && type2.isUpperBounded()) {
            ResolvedType glb = TypeHelper.glb(this.toSet(type1.getBoundedType(), type2.getBoundedType()));
            return this.bound(glb, ResolvedWildcard.BoundType.SUPER);
        }
        if (type1.isLowerBounded() && type2.isLowerBounded()) {
            ResolvedType lub = this.lub(this.toSet(type1.getBoundedType(), type2.getBoundedType()));
            return this.bound(lub, ResolvedWildcard.BoundType.EXTENDS);
        }
        if (type1.getBoundedType().equals(type2.getBoundedType())) {
            return type1.getBoundedType();
        }
        return ResolvedWildcard.UNBOUNDED;
    }

    private ResolvedType bound(ResolvedType type, ResolvedWildcard.BoundType boundType) {
        if (type != null && type.isReferenceType() && type.asReferenceType().isJavaLangObject()) {
            return type;
        }
        return boundType.equals((Object)ResolvedWildcard.BoundType.EXTENDS) ? ResolvedWildcard.extendsBound(type) : ResolvedWildcard.superBound(type);
    }

    private Set<ResolvedType> toSet(ResolvedType ... resolvedTypes) {
        return new HashSet<ResolvedType>(Arrays.asList(resolvedTypes));
    }

    static class TypeSubstitution {
        private List<ResolvedTypeParameterDeclaration> typeParameterDeclarations = new LinkedList<ResolvedTypeParameterDeclaration>();
        private List<ResolvedType> types = new LinkedList<ResolvedType>();
        private static final TypeSubstitution EMPTY = new TypeSubstitution();

        public static TypeSubstitution empty() {
            return new TypeSubstitution();
        }

        private TypeSubstitution() {
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        public void withPair(ResolvedTypeParameterDeclaration typeParameterDeclaration, ResolvedType type) {
            this.typeParameterDeclarations.add(typeParameterDeclaration);
            this.types.add(type);
        }

        public List<ResolvedTypeParameterDeclaration> typeParameterDeclarations() {
            return this.typeParameterDeclarations;
        }

        public ResolvedType substitutedType(ResolvedTypeParameterDeclaration typeDecl) {
            int index = this.typeParameterDeclarations.indexOf(typeDecl);
            return index > -1 ? this.types.get(index) : typeDecl.object();
        }
    }
}

