/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedMethodLikeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javassist.bytecode.SignatureAttribute;

public class JavassistTypeParameter
implements ResolvedTypeParameterDeclaration {
    private SignatureAttribute.TypeParameter wrapped;
    private TypeSolver typeSolver;
    private ResolvedTypeParametrizable container;

    public JavassistTypeParameter(SignatureAttribute.TypeParameter wrapped, ResolvedTypeParametrizable container, TypeSolver typeSolver) {
        this.wrapped = wrapped;
        this.typeSolver = typeSolver;
        this.container = container;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedTypeParameterDeclaration)) {
            return false;
        }
        ResolvedTypeParameterDeclaration that = (ResolvedTypeParameterDeclaration)o;
        if (!this.getQualifiedName().equals(that.getQualifiedName())) {
            return false;
        }
        if (this.declaredOnType() != that.declaredOnType()) {
            return false;
        }
        return this.declaredOnMethod() == that.declaredOnMethod();
    }

    public int hashCode() {
        return Objects.hash(this.getQualifiedName(), this.declaredOnType(), this.declaredOnMethod());
    }

    public String toString() {
        return "JavassistTypeParameter{" + this.wrapped.getName() + '}';
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public String getContainerQualifiedName() {
        if (this.container instanceof ResolvedReferenceTypeDeclaration) {
            return ((ResolvedReferenceTypeDeclaration)this.container).getQualifiedName();
        }
        if (this.container instanceof ResolvedMethodLikeDeclaration) {
            return ((ResolvedMethodLikeDeclaration)this.container).getQualifiedName();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getContainerId() {
        return this.getContainerQualifiedName();
    }

    @Override
    public ResolvedTypeParametrizable getContainer() {
        return this.container;
    }

    @Override
    public List<ResolvedTypeParameterDeclaration.Bound> getBounds() {
        ArrayList<ResolvedTypeParameterDeclaration.Bound> bounds = new ArrayList<ResolvedTypeParameterDeclaration.Bound>();
        SignatureAttribute.ObjectType classBound = this.wrapped.getClassBound();
        if (classBound != null) {
            bounds.add(ResolvedTypeParameterDeclaration.Bound.extendsBound(JavassistUtils.signatureTypeToType(classBound, this.typeSolver, this.getContainer())));
        }
        for (SignatureAttribute.ObjectType ot : this.wrapped.getInterfaceBound()) {
            bounds.add(ResolvedTypeParameterDeclaration.Bound.extendsBound(JavassistUtils.signatureTypeToType(ot, this.typeSolver, this.getContainer())));
        }
        return bounds;
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        if (this.container instanceof ResolvedReferenceTypeDeclaration) {
            return Optional.of((ResolvedReferenceTypeDeclaration)this.container);
        }
        return Optional.empty();
    }

    @Override
    public ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject());
    }
}

