/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistConstructorDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public class JavassistTypeDeclarationAdapter {
    private static final String JDK_ANNOTATION_CLASS_NAME = "java.lang.annotation.Annotation";
    private static Method JDK_ANNOTATION_TYPE_METHOD = null;
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private ResolvedReferenceTypeDeclaration typeDeclaration;

    public JavassistTypeDeclarationAdapter(CtClass ctClass, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration typeDeclaration) {
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.typeDeclaration = typeDeclaration;
    }

    public Optional<ResolvedReferenceType> getSuperClass() {
        try {
            if ("java.lang.Object".equals(this.ctClass.getClassFile().getName())) {
                return Optional.empty();
            }
            if (this.ctClass.getGenericSignature() == null) {
                return Optional.of(new ReferenceTypeImpl(this.typeSolver.solveType(JavassistUtils.internalNameToCanonicalName(this.ctClass.getClassFile().getSuperclass()))));
            }
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature(this.ctClass.getGenericSignature());
            return Optional.ofNullable(JavassistUtils.signatureTypeToType(classSignature.getSuperClass(), this.typeSolver, this.typeDeclaration).asReferenceType());
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public List<ResolvedReferenceType> getInterfaces() {
        return this.getInterfaces(false);
    }

    private List<ResolvedReferenceType> getInterfaces(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> interfaces = new ArrayList<ResolvedReferenceType>();
        try {
            if (this.ctClass.getGenericSignature() == null) {
                for (String interfaceType : this.ctClass.getClassFile().getInterfaces()) {
                    try {
                        ResolvedReferenceTypeDeclaration declaration = this.typeSolver.solveType(JavassistUtils.internalNameToCanonicalName(interfaceType));
                        interfaces.add(new ReferenceTypeImpl(declaration));
                    }
                    catch (UnsolvedSymbolException e) {
                        if (acceptIncompleteList) continue;
                        throw e;
                    }
                }
            } else {
                SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature(this.ctClass.getGenericSignature());
                for (SignatureAttribute.ClassType interfaceType : classSignature.getInterfaces()) {
                    try {
                        interfaces.add(JavassistUtils.signatureTypeToType(interfaceType, this.typeSolver, this.typeDeclaration).asReferenceType());
                    }
                    catch (UnsolvedSymbolException e) {
                        if (acceptIncompleteList) continue;
                        throw e;
                    }
                }
            }
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
        return interfaces;
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> ancestors;
        block2: {
            ancestors = new ArrayList<ResolvedReferenceType>();
            try {
                this.getSuperClass().ifPresent(superClass -> ancestors.add((ResolvedReferenceType)superClass));
            }
            catch (UnsolvedSymbolException e) {
                if (acceptIncompleteList) break block2;
                throw e;
            }
        }
        ancestors.addAll(this.getInterfaces(acceptIncompleteList));
        return ancestors;
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.ctClass.getDeclaredMethods()).filter(m3 -> (m3.getMethodInfo().getAccessFlags() & 0x40) == 0 && (m3.getMethodInfo().getAccessFlags() & 0x1000) == 0).map(m3 -> new JavassistMethodDeclaration((CtMethod)m3, this.typeSolver)).collect(Collectors.toSet());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Arrays.stream(this.ctClass.getConstructors()).filter(m3 -> (m3.getMethodInfo().getAccessFlags() & 0x1000) == 0).map(m3 -> new JavassistConstructorDeclaration((CtConstructor)m3, this.typeSolver)).collect(Collectors.toList());
    }

    public List<ResolvedFieldDeclaration> getDeclaredFields() {
        ArrayList<ResolvedFieldDeclaration> fields = new ArrayList<ResolvedFieldDeclaration>();
        for (CtField field : this.ctClass.getDeclaredFields()) {
            fields.add(new JavassistFieldDeclaration(field, this.typeSolver));
        }
        for (ResolvedReferenceType ancestor : this.typeDeclaration.getAllAncestors()) {
            ancestor.getTypeDeclaration().ifPresent(ancestorTypeDeclaration -> fields.addAll(ancestorTypeDeclaration.getAllFields()));
        }
        return fields;
    }

    public Set<ResolvedAnnotationDeclaration> getDeclaredAnnotations() {
        try {
            Object[] annotations = this.ctClass.getAnnotations();
            return Stream.of(annotations).map(annotation -> this.getAnnotationType(annotation)).filter(annotationType -> annotationType != null).map(annotationType -> this.typeSolver.solveType((String)annotationType)).map(rrtd -> rrtd.asAnnotation()).collect(Collectors.toSet());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Collections.EMPTY_SET;
        }
    }

    private String getAnnotationType(Object annotation) {
        String typeName = null;
        try {
            Class annotationClass = (Class)Proxy.getInvocationHandler(annotation).invoke(annotation, JDK_ANNOTATION_TYPE_METHOD, null);
            typeName = annotationClass.getTypeName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return typeName;
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        if (null == this.ctClass.getGenericSignature()) {
            return Collections.emptyList();
        }
        try {
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature(this.ctClass.getGenericSignature());
            return Arrays.stream(classSignature.getParameters()).map(tp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)tp, JavassistFactory.toTypeDeclaration(this.ctClass, this.typeSolver), this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        try {
            return this.ctClass.getDeclaringClass() == null ? Optional.empty() : Optional.of(JavassistFactory.toTypeDeclaration(this.ctClass.getDeclaringClass(), this.typeSolver));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAssignableBy(ResolvedType other) {
        if (other.isNull()) {
            return true;
        }
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return this.typeDeclaration.isFunctionalInterface();
        }
        return other.isAssignableBy(new ReferenceTypeImpl(this.typeDeclaration));
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy(new ReferenceTypeImpl(other));
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        try {
            return Stream.of(this.ctClass.getNestedClasses()).map(clazz -> JavassistFactory.toTypeDeclaration(clazz, this.typeSolver)).collect(Collectors.toSet());
        }
        catch (NotFoundException e) {
            throw new UnsupportedOperationException("Please report this issue at https://github.com/javaparser/javaparser/issues/new/choose", e);
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName(JDK_ANNOTATION_CLASS_NAME);
            JDK_ANNOTATION_TYPE_METHOD = clazz.getMethod("annotationType", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

