/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.AstResolutionUtils;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnnotationDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeVariableDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaParserTypeAdapter<T extends Node & NodeWithMembers<T>> {
    private T wrappedNode;
    private TypeSolver typeSolver;

    public JavaParserTypeAdapter(T wrappedNode, TypeSolver typeSolver) {
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    public String getPackageName() {
        return AstResolutionUtils.getPackageName(this.wrappedNode);
    }

    public String getClassName() {
        return AstResolutionUtils.getClassName("", this.wrappedNode);
    }

    public String getQualifiedName() {
        String containerName = AstResolutionUtils.containerName(((Node)this.wrappedNode).getParentNode().orElse(null));
        if (containerName.isEmpty()) {
            return ((NodeWithSimpleName)this.wrappedNode).getName().getId();
        }
        return containerName + "." + ((NodeWithSimpleName)this.wrappedNode).getName().getId();
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        List<ResolvedReferenceType> ancestorsOfOther = other.getAllAncestors();
        ancestorsOfOther.add(new ReferenceTypeImpl(other));
        for (ResolvedReferenceType ancestorOfOther : ancestorsOfOther) {
            if (!ancestorOfOther.getQualifiedName().equals(this.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableBy(ResolvedType type) {
        if (type.isNull()) {
            return true;
        }
        if (type.isReferenceType()) {
            ResolvedReferenceTypeDeclaration other = this.typeSolver.solveType(type.describe());
            return this.isAssignableBy(other);
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
        if (this.wrappedNode instanceof NodeWithTypeParameters) {
            NodeList<TypeParameter> typeParameters = ((NodeWithTypeParameters)this.wrappedNode).getTypeParameters();
            for (TypeParameter typeParameter : typeParameters) {
                if (!typeParameter.getName().getId().equals(name)) continue;
                return SymbolReference.solved(new JavaParserTypeVariableDeclaration(typeParameter, this.typeSolver));
            }
        }
        for (BodyDeclaration<?> member : ((NodeWithMembers)this.wrappedNode).getMembers()) {
            if (!(member instanceof TypeDeclaration)) continue;
            TypeDeclaration internalType = (TypeDeclaration)member;
            String prefix = internalType.getName().asString() + ".";
            if (internalType.getName().getId().equals(name)) {
                if (internalType instanceof ClassOrInterfaceDeclaration) {
                    if (((ClassOrInterfaceDeclaration)internalType).isInterface()) {
                        return SymbolReference.solved(new JavaParserInterfaceDeclaration((ClassOrInterfaceDeclaration)internalType, this.typeSolver));
                    }
                    return SymbolReference.solved(new JavaParserClassDeclaration((ClassOrInterfaceDeclaration)internalType, this.typeSolver));
                }
                if (internalType instanceof EnumDeclaration) {
                    return SymbolReference.solved(new JavaParserEnumDeclaration((EnumDeclaration)internalType, this.typeSolver));
                }
                if (internalType instanceof AnnotationDeclaration) {
                    return SymbolReference.solved(new JavaParserAnnotationDeclaration((AnnotationDeclaration)internalType, this.typeSolver));
                }
                throw new UnsupportedOperationException();
            }
            if (!name.startsWith(prefix) || name.length() <= prefix.length()) continue;
            if (internalType instanceof ClassOrInterfaceDeclaration) {
                if (((ClassOrInterfaceDeclaration)internalType).isInterface()) {
                    return new JavaParserInterfaceDeclaration((ClassOrInterfaceDeclaration)internalType, this.typeSolver).solveType(name.substring(prefix.length()));
                }
                return new JavaParserClassDeclaration((ClassOrInterfaceDeclaration)internalType, this.typeSolver).solveType(name.substring(prefix.length()));
            }
            if (internalType instanceof EnumDeclaration) {
                return new SymbolSolver(this.typeSolver).solveTypeInType(new JavaParserEnumDeclaration((EnumDeclaration)internalType, this.typeSolver), name.substring(prefix.length()));
            }
            if (internalType instanceof AnnotationDeclaration) {
                return SymbolReference.solved(new JavaParserAnnotationDeclaration((AnnotationDeclaration)internalType, this.typeSolver));
            }
            throw new UnsupportedOperationException();
        }
        return SymbolReference.unsolved();
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return ((Node)this.wrappedNode).getParentNode().map(node -> node.getSymbolResolver().toTypeDeclaration((Node)node));
    }

    public List<ResolvedFieldDeclaration> getFieldsForDeclaredVariables() {
        ArrayList<ResolvedFieldDeclaration> fields = new ArrayList<ResolvedFieldDeclaration>();
        if (((NodeWithMembers)this.wrappedNode).getMembers() != null) {
            for (BodyDeclaration<?> member : ((NodeWithMembers)this.wrappedNode).getMembers()) {
                if (!(member instanceof FieldDeclaration)) continue;
                FieldDeclaration field = (FieldDeclaration)member;
                for (VariableDeclarator vd : field.getVariables()) {
                    fields.add(new JavaParserFieldDeclaration(vd, this.typeSolver));
                }
            }
        }
        return fields;
    }

    public Set<ResolvedAnnotationDeclaration> getDeclaredAnnotations() {
        return ((NodeWithAnnotations)this.wrappedNode).getAnnotations().stream().map(annotation -> annotation.resolve()).collect(Collectors.toSet());
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        Set<ResolvedReferenceTypeDeclaration> res = Collections.newSetFromMap(new IdentityHashMap());
        for (BodyDeclaration<?> member : ((NodeWithMembers)this.wrappedNode).getMembers()) {
            if (!(member instanceof TypeDeclaration)) continue;
            res.add(JavaParserFacade.get(this.typeSolver).getTypeDeclaration((TypeDeclaration)member));
        }
        return res;
    }
}

