/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.collector.util;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import net.neoforged.javadoctor.collector.util.Hierarchy;

public record Names(Types types, Elements elements) {
    public String getDesc(ExecutableElement method) {
        StringBuilder signatureBuilder = new StringBuilder("(");
        for (VariableElement variableElement : method.getParameters()) {
            signatureBuilder.append(this.getParamDescriptor(variableElement.asType()));
        }
        return signatureBuilder + ")" + this.getParamDescriptor(method.getReturnType());
    }

    public String getParamDescriptor(TypeMirror type) {
        type = this.types.erasure(type);
        return switch (type.getKind()) {
            case TypeKind.ARRAY -> "[" + this.getParamDescriptor(((ArrayType)type).getComponentType());
            case TypeKind.BOOLEAN -> "Z";
            case TypeKind.BYTE -> "B";
            case TypeKind.CHAR -> "C";
            case TypeKind.DOUBLE -> "D";
            case TypeKind.FLOAT -> "F";
            case TypeKind.INT -> "I";
            case TypeKind.LONG -> "J";
            case TypeKind.SHORT -> "S";
            case TypeKind.VOID -> "V";
            case TypeKind.DECLARED -> "L" + this.getClassDescriptor(type) + ";";
            default -> throw new IllegalStateException("Unexpected value: " + type.getKind());
        };
    }

    public String getClassDescriptor(TypeMirror type) {
        return this.getTypeName(type).replace('.', '/');
    }

    public String getTypeName(TypeMirror type) {
        return this.getTypeName(this.types.asElement(type));
    }

    public String getTypeName(Element el) {
        if (!(el instanceof TypeElement)) {
            throw new IllegalArgumentException();
        }
        TypeElement element = (TypeElement)el;
        PackageElement pkg = this.elements.getPackageOf(element);
        String packageName = pkg.getQualifiedName().toString();
        String subClasses = String.join((CharSequence)"$", Hierarchy.walkEnclosingClasses(element).map(e -> e.getSimpleName().toString()).toList());
        String className = (String)(subClasses.isEmpty() ? "" : subClasses + "$") + element.getSimpleName().toString();
        if (packageName.isEmpty()) {
            return className.replace('.', '$');
        }
        return packageName + "." + className.replace('.', '$');
    }
}

