/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.collector.util;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class AnnotationUtils {
    private final Types types;
    private final AnnotationMirror mirror;

    public AnnotationUtils(Types types, AnnotationMirror mirror) {
        this.types = types;
        this.mirror = mirror;
    }

    public List<TypeElement> getClasses(String key) {
        return this.mirror.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals(key)).map(e -> this.listOf((AnnotationValue)e.getValue(), o -> (TypeElement)this.types.asElement((TypeMirror)o))).findFirst().orElse(List.of());
    }

    private <T> List<T> listOf(AnnotationValue annotationValue, Function<Object, T> cast) {
        Object val = annotationValue.getValue();
        if (val instanceof List) {
            return ((List)val).stream().map(o -> cast.apply(((AnnotationValue)o).getValue())).toList();
        }
        return List.of(cast.apply(val));
    }

    public String toString() {
        return this.mirror.getElementValues().keySet().stream().map(Object::getClass).collect(Collectors.toSet()).toString();
    }
}

