/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.collector;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.sun.source.util.Trees;
import java.io.Writer;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import net.neoforged.javadoctor.collector.JavadocCollector;
import net.neoforged.javadoctor.collector.MixinTypes;
import net.neoforged.javadoctor.io.gson.GsonJDocIO;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"collectionPackages"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class Processor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        String[] toCollect = this.processingEnv.getOptions().get("collectionPackages").split(",");
        Predicate<String> isCollectible = s -> {
            for (String c : toCollect) {
                if (!s.startsWith(c)) continue;
                return true;
            }
            return false;
        };
        JavadocCollector collector = new JavadocCollector(this.processingEnv.getTypeUtils(), this.processingEnv.getMessager(), this.processingEnv.getElementUtils(), Trees.instance(this.processingEnv));
        this.processingEnv.getElementUtils().getAllModuleElements().stream().flatMap(el -> el.getEnclosedElements().stream().map(PackageElement.class::cast)).filter(pkg -> isCollectible.test(pkg.getQualifiedName().toString())).flatMap(pkg -> pkg.getEnclosedElements().stream().map(TypeElement.class::cast)).distinct().forEach(collector::collect);
        if (Boolean.parseBoolean(this.processingEnv.getOptions().getOrDefault("mixinCollect", "true"))) {
            MixinTypes types = new MixinTypes(this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
            roundEnv.getElementsAnnotatedWith(types.Mixin).stream().filter(el -> el.getKind() == ElementKind.CLASS).map(TypeElement.class::cast).forEach(type -> collector.collectMixin((TypeElement)type, types));
        }
        try (Writer writer = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "javadocs.json", new Element[0]).openWriter();){
            GsonJDocIO.GSON.toJson((JsonElement)GsonJDocIO.write((Gson)GsonJDocIO.GSON, collector.javadocs), (Appendable)writer);
        }
        catch (Exception exception) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not write javadocs json: " + exception);
        }
        return false;
    }
}

