/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.collector;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import net.neoforged.javadoctor.collector.DocFQNExpander;
import net.neoforged.javadoctor.collector.MixinTypes;
import net.neoforged.javadoctor.collector.util.AnnotationUtils;
import net.neoforged.javadoctor.collector.util.Hierarchy;
import net.neoforged.javadoctor.collector.util.Names;
import net.neoforged.javadoctor.spec.ClassJavadoc;
import net.neoforged.javadoctor.spec.JavadocEntry;
import org.jetbrains.annotations.Nullable;

public class JavadocCollector {
    public static final Pattern GENERIC = Pattern.compile("<(.+)>");
    public static final Pattern LINKS = Pattern.compile("(@link|@linkplain|@see|@value) ([a-zA-Z0-9\\._]+)");
    private final Types types;
    private final Messager messager;
    private final Elements elements;
    private final Trees trees;
    private final Names names;
    final Map<String, ClassJavadoc> javadocs = new HashMap<String, ClassJavadoc>();

    public JavadocCollector(Types types, Messager messager, Elements elements, Trees trees) {
        this.types = types;
        this.messager = messager;
        this.elements = elements;
        this.trees = trees;
        this.names = new Names(types, elements);
    }

    public void collectMixin(TypeElement typeElement, MixinTypes types) {
        Imports imports = Imports.fromTree(this.trees.getPath(typeElement), typeElement);
        AnnotationUtils mixinAn = types.getAnnotation(typeElement, types.Mixin);
        List<TypeElement> mixind = mixinAn.getClasses("value");
        typeElement.getEnclosedElements().forEach(element -> {
            HashMap<CallSite, JavadocEntry> methods = new HashMap<CallSite, JavadocEntry>();
            HashMap<CallSite, JavadocEntry> fields = new HashMap<CallSite, JavadocEntry>();
            if (element.getKind() == ElementKind.METHOD && (types.getAnnotation((Element)element, types.Shadow) != null || types.getAnnotation((Element)element, types.Unique) != null) || element.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement executableElement = (ExecutableElement)element;
                methods.put((CallSite)((Object)(executableElement.getSimpleName().toString() + this.names.getDesc(executableElement))), this.createJavadoc(executableElement, imports, ParameterProvider.provider(executableElement.getParameters()), ParameterProvider.provider(executableElement.getTypeParameters())));
            } else if (element.getKind() == ElementKind.FIELD && (types.getAnnotation((Element)element, types.Shadow) != null || types.getAnnotation((Element)element, types.Unique) != null)) {
                fields.put((CallSite)((Object)(element.getSimpleName().toString() + ":" + this.names.getParamDescriptor(element.asType()))), this.createJavadoc((Element)element, imports, null, null));
            }
            if (!methods.isEmpty() || !fields.isEmpty()) {
                mixind.forEach(mx -> this.mergeWithExisting((TypeElement)mx, new ClassJavadoc(null, methods.isEmpty() ? null : methods, fields.isEmpty() ? null : fields, null)));
            }
        });
    }

    public void mergeWithExisting(TypeElement type, ClassJavadoc doc) {
        ClassJavadoc root;
        List parents = Stream.concat(Hierarchy.walkEnclosingClasses(type), Stream.of(type)).collect(Collectors.toCollection(ArrayList::new));
        ClassJavadoc parentDoc = null;
        for (TypeElement parent : parents) {
            if (parentDoc == null) {
                parentDoc = this.javadocs.get(parent.getQualifiedName().toString());
                continue;
            }
            if ((parentDoc = (ClassJavadoc)parentDoc.innerClasses().get(parent.getSimpleName().toString())) != null) continue;
            break;
        }
        ClassJavadoc newDoc = doc.merge(parentDoc);
        ClassJavadoc toMergeWith = root = this.javadocs.computeIfAbsent(((TypeElement)parents.get(0)).getQualifiedName().toString(), s -> new ClassJavadoc());
        Map inners = root.innerClasses();
        for (int i = 1; i < parents.size(); ++i) {
            inners = toMergeWith.innerClasses();
            toMergeWith = toMergeWith.innerClasses().computeIfAbsent(((TypeElement)parents.get(i)).getSimpleName().toString(), s -> new ClassJavadoc());
        }
        if (parents.size() == 1) {
            this.javadocs.put(((TypeElement)parents.get(0)).getQualifiedName().toString(), newDoc);
        } else {
            inners.put(((TypeElement)parents.get(parents.size() - 1)).getSimpleName().toString(), doc);
        }
    }

    public void collect(TypeElement typeElement) {
        ClassJavadoc classJavadoc = this.buildClass(typeElement);
        if (classJavadoc.clazz() != null || classJavadoc.methods() != null || classJavadoc.fields() != null || !classJavadoc.innerClasses().isEmpty()) {
            this.javadocs.put(typeElement.getQualifiedName().toString(), classJavadoc);
        }
    }

    public ClassJavadoc buildClass(TypeElement clazz) {
        Imports imports = Imports.fromTree(this.trees.getPath(clazz), clazz);
        JavadocEntry clazzdoc = this.createJavadoc(clazz, imports, clazz.getKind() == ElementKind.RECORD ? ParameterProvider.provider(ElementFilter.recordComponentsIn(clazz.getEnclosedElements())) : null, ParameterProvider.provider(clazz.getTypeParameters()));
        HashMap methods = new HashMap();
        HashMap fields = new HashMap();
        HashMap innerClasses = new HashMap();
        clazz.getEnclosedElements().forEach(element -> {
            if (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement executableElement = (ExecutableElement)element;
                methods.put(executableElement.getSimpleName().toString() + this.names.getDesc(executableElement), this.createJavadoc(executableElement, imports, ParameterProvider.provider(executableElement.getParameters()), ParameterProvider.provider(executableElement.getTypeParameters())));
            } else if (element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.ENUM_CONSTANT) {
                fields.put(element.getSimpleName().toString() + ":" + this.names.getParamDescriptor(element.asType()), this.createJavadoc((Element)element, imports, null, null));
            } else if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                innerClasses.put(typeElement.getSimpleName().toString(), this.buildClass(typeElement));
            }
        });
        methods.values().removeIf(Objects::isNull);
        fields.values().removeIf(Objects::isNull);
        return new ClassJavadoc(clazzdoc, methods.isEmpty() ? null : methods, fields.isEmpty() ? null : fields, innerClasses);
    }

    @Nullable
    private JavadocEntry createJavadoc(final Element collectingElement, Imports imports, final @Nullable ParameterProvider paramsGetter, final @Nullable ParameterProvider genericParamsGetter) {
        TypeElement typeElement;
        String docComment = this.elements.getDocComment(collectingElement);
        if (docComment == null || docComment.isBlank()) {
            return null;
        }
        docComment = DocFQNExpander.expand(collectingElement instanceof TypeElement ? (typeElement = (TypeElement)collectingElement) : (TypeElement)collectingElement.getEnclosingElement(), s -> this.messager.printMessage(Diagnostic.Kind.ERROR, (CharSequence)s, collectingElement), docComment, imports);
        docComment = LINKS.matcher(docComment).replaceAll(matchResult -> matchResult.group(1) + " " + imports.getQualified(matchResult.group(2)));
        final ArrayList docs = new ArrayList();
        final HashMap tags = new HashMap();
        Map.Entry<String[], String[]> params = this.walk(docComment, new JDocWalker<Map.Entry<String[], String[]>>(){
            String[] parameters = null;
            String[] typeParameters = null;

            @Override
            public void onLine(String line) {
                docs.add(line);
            }

            @Override
            public void onTag(String tag, String line) {
                if (tag.equals("param")) {
                    String[] splitWithParam = line.split(" ", 2);
                    String paramName = splitWithParam[0];
                    Matcher generic = GENERIC.matcher(paramName);
                    if (generic.find()) {
                        if (genericParamsGetter == null) {
                            JavadocCollector.this.messager.printMessage(Diagnostic.Kind.WARNING, "Found generic parameter but the element does not support generic parameters!", collectingElement);
                        } else {
                            int idx = genericParamsGetter.getIndex(generic.group(1));
                            if (idx == -1) {
                                JavadocCollector.this.messager.printMessage(Diagnostic.Kind.WARNING, "Unknown generic parameter named '" + generic.group(1) + "'", collectingElement);
                            } else {
                                (this.typeParameters == null ? (this.typeParameters = genericParamsGetter.provide()) : this.typeParameters)[idx] = splitWithParam[1];
                            }
                        }
                    } else if (paramsGetter == null) {
                        JavadocCollector.this.messager.printMessage(Diagnostic.Kind.WARNING, "Found named parameter but the element does not support named parameters!", collectingElement);
                    } else {
                        int idx = paramsGetter.getIndex(paramName);
                        if (idx == -1) {
                            JavadocCollector.this.messager.printMessage(Diagnostic.Kind.WARNING, "Unknown parameter named '" + paramName + "'", collectingElement);
                        } else {
                            (this.parameters == null ? (this.parameters = paramsGetter.provide()) : this.parameters)[idx] = splitWithParam[1];
                        }
                    }
                } else {
                    tags.computeIfAbsent(tag, k -> new ArrayList()).add(line);
                }
            }

            @Override
            public Map.Entry<String[], String[]> finish() {
                return new AbstractMap.SimpleEntry<String[], String[]>(this.parameters, this.typeParameters);
            }
        });
        return new JavadocEntry(String.join((CharSequence)"\n", docs).trim(), tags, params.getKey(), params.getValue());
    }

    private <T> T walk(String comment, JDocWalker<T> walker) {
        StringBuilder current = new StringBuilder();
        String tagName = null;
        String[] lines = comment.split("\n");
        if (lines.length == 0) {
            return walker.finish();
        }
        int indentAmount = 0;
        if (!lines[0].trim().startsWith("@")) {
            String line = lines[0];
            for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
                ++indentAmount;
            }
        }
        for (String line : lines) {
            String[] split;
            if (line.length() >= indentAmount) {
                line = line.substring(indentAmount);
            }
            if (line.startsWith("@") && (split = line.substring(1).split(" ", 2)).length == 2) {
                if (tagName != null) {
                    walker.onTag(tagName, current.toString());
                }
                tagName = split[0];
                current = new StringBuilder().append(split[1]);
                continue;
            }
            if ((line.isEmpty() || line.charAt(0) == ' ') && tagName != null) {
                current.append(line.trim());
                continue;
            }
            if (tagName != null) {
                walker.onTag(tagName, current.toString());
                current = null;
            }
            walker.onLine(line.trim());
        }
        if (tagName != null) {
            walker.onTag(tagName, current.toString());
        }
        return walker.finish();
    }

    static <T> Supplier<T> memoized(final Supplier<T> value) {
        return new Supplier<T>(){
            T val;

            @Override
            public T get() {
                return this.val == null ? (this.val = value.get()) : this.val;
            }
        };
    }

    private static int lastReferenceLocation(String str) {
        int idx = str.indexOf(46);
        if (idx == -1 && (idx = str.indexOf(35)) == 0) {
            return str.length();
        }
        return idx == -1 ? str.length() : idx;
    }

    public static interface Imports {
        public String getQualified(String var1);

        public static Imports fromTree(TreePath tree, TypeElement owner) {
            Supplier<Map> imports = JavadocCollector.memoized(() -> {
                HashMap i = new HashMap();
                tree.getCompilationUnit().getImports().forEach(importTree -> {
                    String name = importTree.getQualifiedIdentifier().toString();
                    if (importTree.isStatic()) {
                        i.put("#" + name.substring(name.lastIndexOf(46) + 1), name);
                    } else {
                        i.put(name.substring(name.lastIndexOf(46) + 1), name);
                    }
                });
                return i;
            });
            TypeElement finalTopLevel = Hierarchy.getTopLevel(owner);
            Supplier<Map> topChildren = JavadocCollector.memoized(() -> Stream.concat(Stream.of(finalTopLevel), Hierarchy.walkChildren(finalTopLevel)).collect(Collectors.toMap(it -> it.getSimpleName().toString(), Function.identity())));
            return inputName -> {
                TypeElement child;
                String last = inputName.substring(0, JavadocCollector.lastReferenceLocation(inputName));
                String imp = (String)((Map)imports.get()).get(last);
                if (imp != null) {
                    return imp;
                }
                if (!inputName.startsWith("#") && (child = (TypeElement)((Map)topChildren.get()).get(last)) != null) {
                    return child.getQualifiedName().toString();
                }
                return inputName;
            };
        }
    }

    public static interface ParameterProvider {
        public String[] provide();

        public int getIndex(String var1);

        public static ParameterProvider provider(final List<? extends Element> generics) {
            return new ParameterProvider(){
                private List<String> parameterTypes;

                @Override
                public String[] provide() {
                    Object[] array = new String[generics.size()];
                    Arrays.fill(array, null);
                    return array;
                }

                @Override
                public int getIndex(String name) {
                    return (this.parameterTypes == null ? (this.parameterTypes = generics.stream().map(t -> t.getSimpleName().toString()).toList()) : this.parameterTypes).indexOf(name);
                }
            };
        }
    }

    public static interface JDocWalker<T> {
        public void onLine(String var1);

        public void onTag(String var1, String var2);

        public T finish();
    }
}

