/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.javadoctor.collector;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import net.neoforged.javadoctor.collector.JavadocCollector;
import net.neoforged.javadoctor.collector.util.Hierarchy;

public class DocFQNExpander {
    public static final Pattern PATTERN = Pattern.compile("@(?<tag>link|linkplain|see|value)(?<space>\\s+)(?<owner>[\\w$.]*)(?:#(?<member>[\\w%]+)?(\\((?<desc>[\\w$., ]+)?\\))?)?");

    public static String expand(TypeElement declaringClass, Consumer<String> messager, String doc, JavadocCollector.Imports imports) {
        TypeElement topLevel = Hierarchy.getTopLevel(declaringClass);
        Supplier<Map> members = JavadocCollector.memoized(() -> {
            HashMap memberMap = new HashMap();
            Stream.concat(Stream.of(topLevel), Hierarchy.walkChildren(topLevel)).forEach(t -> t.getEnclosedElements().stream().filter(f -> f.getKind() == ElementKind.ENUM_CONSTANT || f.getKind() == ElementKind.FIELD || f.getKind() == ElementKind.METHOD).forEach(element -> memberMap.put(element.getKind() == ElementKind.METHOD ? element.getSimpleName().toString() : "#" + element.getSimpleName(), t)));
            return memberMap;
        });
        return PATTERN.matcher(doc).replaceAll(result -> {
            StringBuffer text = new StringBuffer().append('@').append(result.group(1)).append(result.group(2));
            String owner = imports.getQualified(result.group(3));
            String member = result.group(4);
            String desc = result.group(6);
            if (owner == null || owner.isBlank()) {
                if (member == null) {
                    messager.accept("Cannot resolve " + result.group(1) + " tag. Owner and member are missing.");
                    return "";
                }
                TypeElement actualOwner = (TypeElement)((Map)members.get()).get(desc == null ? "#" + member : member);
                if (actualOwner != null) {
                    text.append(actualOwner.getQualifiedName());
                }
            } else {
                text.append(owner);
            }
            if (member == null) {
                return text.toString();
            }
            text.append('#').append(member);
            if (desc == null) {
                return text.toString();
            }
            return text.append('(').append(String.join((CharSequence)", ", DocFQNExpander.getParameterTypes(desc, imports))).append(')').toString();
        });
    }

    private static String[] getParameterTypes(String desc, JavadocCollector.Imports imports) {
        String[] sDesc = desc.split(",");
        String[] nDesc = new String[sDesc.length];
        for (int i = 0; i < sDesc.length; ++i) {
            nDesc[i] = imports.getQualified(sDesc[i].trim());
        }
        return nDesc;
    }
}

