/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jarcompatibilitychecker.core;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.jarcompatibilitychecker.core.AnnotationCheckMode;
import net.neoforged.jarcompatibilitychecker.core.AnnotationIncompatibility;
import net.neoforged.jarcompatibilitychecker.core.ClassIncompatibility;
import net.neoforged.jarcompatibilitychecker.core.FieldIncompatibility;
import net.neoforged.jarcompatibilitychecker.core.Incompatibility;
import net.neoforged.jarcompatibilitychecker.core.MethodIncompatibility;
import net.neoforged.jarcompatibilitychecker.data.AnnotationInfo;
import net.neoforged.jarcompatibilitychecker.data.ClassInfo;
import net.neoforged.jarcompatibilitychecker.data.FieldInfo;
import net.neoforged.jarcompatibilitychecker.data.MemberInfo;
import net.neoforged.jarcompatibilitychecker.data.MethodInfo;

public class ClassInfoComparisonResults {
    public final ClassInfo classInfo;
    private List<Incompatibility<?>> incompatibilities;

    ClassInfoComparisonResults(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    void addIncompatibility(Incompatibility<?> incompatibility) {
        if (this.incompatibilities == null) {
            this.incompatibilities = new ArrayList();
        }
        this.incompatibilities.add(incompatibility);
    }

    void addClassIncompatibility(ClassInfo classInfo, String message) {
        this.addClassIncompatibility(classInfo, message, true);
    }

    void addClassIncompatibility(ClassInfo classInfo, String message, boolean isError) {
        this.addIncompatibility(new ClassIncompatibility(classInfo, message, isError));
    }

    void addMethodIncompatibility(MethodInfo methodInfo, String message) {
        this.addMethodIncompatibility(methodInfo, message, true);
    }

    void addMethodIncompatibility(MethodInfo methodInfo, String message, boolean isError) {
        this.addIncompatibility(new MethodIncompatibility(methodInfo, message, isError));
    }

    void addFieldIncompatibility(FieldInfo fieldInfo, String message) {
        this.addFieldIncompatibility(fieldInfo, message, true);
    }

    void addFieldIncompatibility(FieldInfo fieldInfo, String message, boolean isError) {
        this.addIncompatibility(new FieldIncompatibility(fieldInfo, message, isError));
    }

    <I extends MemberInfo> void addAnnotationIncompatibility(AnnotationCheckMode mode, I memberInfo, AnnotationInfo annotationInfo, String message) {
        this.addAnnotationIncompatibility(mode, memberInfo, annotationInfo, message, true);
    }

    <I extends MemberInfo> void addAnnotationIncompatibility(AnnotationCheckMode mode, I memberInfo, AnnotationInfo annotationInfo, String message, boolean isError) {
        this.addIncompatibility(new AnnotationIncompatibility<I>(memberInfo, annotationInfo, message, isError && mode.shouldError()));
    }

    public boolean isCompatible() {
        return this.incompatibilities == null || this.incompatibilities.isEmpty();
    }

    public boolean isIncompatible() {
        return this.incompatibilities != null && !this.incompatibilities.isEmpty();
    }

    public List<Incompatibility<?>> getIncompatibilities() {
        return this.incompatibilities == null ? ImmutableList.of() : this.incompatibilities;
    }

    public String toString() {
        if (this.incompatibilities == null || this.incompatibilities.isEmpty()) {
            return "[]";
        }
        return this.incompatibilities.toString();
    }
}

