/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jarcompatibilitychecker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.EnumConverter;
import net.neoforged.jarcompatibilitychecker.JarCompatibilityChecker;
import net.neoforged.jarcompatibilitychecker.core.AnnotationCheckMode;
import net.neoforged.jarcompatibilitychecker.core.ClassInfoComparisonResults;
import net.neoforged.jarcompatibilitychecker.core.InternalAnnotationCheckMode;
import net.neoforged.jarcompatibilitychecker.json.JCCJsonEncoder;

public class ConsoleTool {
    public static void main(String[] args) {
        try {
            OptionSet options;
            OptionParser parser = new OptionParser();
            OptionSpecBuilder apiO = parser.accepts("api", "Enables the API compatibility checking mode");
            OptionSpecBuilder binaryO = parser.accepts("binary", "Enables the binary compatibility checking mode. This option will override the API compatibility flag. Defaults to true.");
            ArgumentAcceptingOptionSpec baseJarO = parser.accepts("base-jar", "Base JAR file that will be matched against for compatibility").withRequiredArg().ofType(File.class).required();
            ArgumentAcceptingOptionSpec inputJarO = parser.accepts("input-jar", "JAR file to validate against the base JAR").withRequiredArg().ofType(File.class).required();
            ArgumentAcceptingOptionSpec libO = parser.acceptsAll((List)ImmutableList.of((Object)"lib", (Object)"library"), "Libraries that the base JAR and input JAR both use").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec baseLibO = parser.acceptsAll((List)ImmutableList.of((Object)"base-lib", (Object)"base-library"), "Libraries that only the base JAR uses").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec concreteLibO = parser.acceptsAll((List)ImmutableList.of((Object)"concrete-lib", (Object)"concrete-library"), "Libraries that only the input JAR uses").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec annotationCheckModeO = parser.acceptsAll((List)ImmutableList.of((Object)"annotation-check-mode", (Object)"ann-mode"), "What mode to use for checking annotations").withRequiredArg().withValuesConvertedBy((ValueConverter)new EnumConverter<AnnotationCheckMode>(AnnotationCheckMode.class){});
            ArgumentAcceptingOptionSpec internalAnnotationO = parser.acceptsAll((List)ImmutableList.of((Object)"internal-annotation", (Object)"internal-ann"), "The fully resolved classname of an allowed internal API annotation").withRequiredArg().defaultsTo((Object[])InternalAnnotationCheckMode.DEFAULT_INTERNAL_ANNOTATIONS.toArray(new String[0]));
            ArgumentAcceptingOptionSpec internalAnnotationCheckModeO = parser.acceptsAll((List)ImmutableList.of((Object)"internal-annotation-check-mode", (Object)"internal-ann-mode"), "What mode to use for checking elements marked with an internal API annotation").withRequiredArg().withValuesConvertedBy((ValueConverter)new EnumConverter<InternalAnnotationCheckMode>(InternalAnnotationCheckMode.class){}).defaultsTo((Object)InternalAnnotationCheckMode.DEFAULT_MODE, (Object[])new InternalAnnotationCheckMode[0]);
            OptionSpecBuilder failO = parser.accepts("fail", "If enabled, the tool will fail if incompatibilities are detected");
            ArgumentAcceptingOptionSpec outputO = parser.accepts("output", "A file to which the incompatibilities should be dumped to").withRequiredArg().ofType(File.class);
            try {
                options = parser.parse(args);
            }
            catch (OptionException ex) {
                System.err.println("Error: " + ex.getMessage());
                System.err.println();
                parser.printHelpOn((OutputStream)System.err);
                System.exit(-1);
                return;
            }
            File baseJar = (File)options.valueOf((OptionSpec)baseJarO);
            File inputJar = (File)options.valueOf((OptionSpec)inputJarO);
            List commonLibs = options.valuesOf((OptionSpec)libO);
            List baseLibs = options.valuesOf((OptionSpec)baseLibO);
            List concreteLibs = options.valuesOf((OptionSpec)concreteLibO);
            boolean checkBinary = !options.has((OptionSpec)apiO) || options.has((OptionSpec)binaryO);
            AnnotationCheckMode annotationCheckMode = (AnnotationCheckMode)((Object)options.valueOf((OptionSpec)annotationCheckModeO));
            List internalAnnotations = options.valuesOf((OptionSpec)internalAnnotationO);
            InternalAnnotationCheckMode internalAnnotationCheckMode = (InternalAnnotationCheckMode)((Object)options.valueOf((OptionSpec)internalAnnotationCheckModeO));
            JarCompatibilityChecker checker = new JarCompatibilityChecker(baseJar, inputJar, checkBinary, annotationCheckMode, internalAnnotations, internalAnnotationCheckMode, commonLibs, baseLibs, concreteLibs, System.out::println, System.err::println);
            Map.Entry<Integer, List<ClassInfoComparisonResults>> incompatibilities = checker.check();
            if (options.has((OptionSpec)outputO)) {
                HashMap incompats = new HashMap();
                incompatibilities.getValue().forEach(result -> result.getIncompatibilities().forEach(incompat -> JCCJsonEncoder.accept(incompats, incompat)));
                Path output = ((File)options.valueOf((OptionSpec)outputO)).toPath();
                if (output.getParent() != null) {
                    Files.createDirectories(output.getParent(), new FileAttribute[0]);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(output, new OpenOption[0]);){
                    new GsonBuilder().registerTypeAdapter(ListMultimap.class, (src, typeOfSrc, context) -> context.serialize((Object)src.asMap())).create().toJson(incompats, (Appendable)writer);
                }
            }
            if (options.has((OptionSpec)failO)) {
                System.exit(Math.min(125, incompatibilities.getKey()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

