/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jarcompatibilitychecker.data;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import net.neoforged.jarcompatibilitychecker.data.AnnotationInfo;
import net.neoforged.jarcompatibilitychecker.data.ClassInfo;
import net.neoforged.jarcompatibilitychecker.data.MemberInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;

public class FieldInfo
implements MemberInfo {
    public final String name;
    public final String desc;
    public final int access;
    public final List<AnnotationInfo> annotations;
    public final ClassInfo parent;

    public FieldInfo(FieldNode node, ClassInfo parent) {
        this.name = node.name;
        this.desc = node.desc;
        this.access = node.access;
        this.parent = parent;
        this.annotations = AnnotationInfo.create(node.visibleAnnotations, node.invisibleAnnotations);
    }

    public FieldInfo(Field node, ClassInfo parent) {
        this.name = node.getName();
        this.desc = Type.getType(node.getType()).getDescriptor();
        this.access = node.getModifiers();
        this.parent = parent;
        this.annotations = ImmutableList.of();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescriptor() {
        return this.desc;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    @NotNull
    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return this.name + ':' + this.desc;
    }
}

