/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.problems;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.neoforged.problems.Problem;
import net.neoforged.problems.ProblemReporter;
import org.jetbrains.annotations.VisibleForTesting;

public class FileProblemReporter
implements ProblemReporter,
AutoCloseable {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Path.class, (Object)new TypeAdapter<Path>(){

        public void write(JsonWriter out, Path value) throws IOException {
            out.value(value.toAbsolutePath().toString());
        }

        public Path read(JsonReader in) throws IOException {
            return Paths.get(in.nextString(), new String[0]);
        }
    }).create();
    private final Path problemsReport;
    private final List<Problem> problems = new ArrayList<Problem>();

    public FileProblemReporter(Path problemsReport) {
        this.problemsReport = problemsReport;
    }

    @Override
    public synchronized void report(Problem problem) {
        this.problems.add(problem);
    }

    @Override
    public void close() throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.problemsReport, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(this.problems, (Appendable)writer);
        }
    }

    @VisibleForTesting
    public static List<Problem> loadRecords(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file);){
            List<Object> list = Arrays.asList((Object[])GSON.fromJson((Reader)reader, Problem[].class));
            return list;
        }
    }
}

