/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import java.util.EnumSet;

public enum PatchBase {
    CLIENT(1),
    SERVER(2),
    JOINED(4);

    private final int mask;

    private PatchBase(int mask) {
        this.mask = mask;
    }

    static int toBitfield(EnumSet<PatchBase> distributions) {
        int result = 0;
        for (PatchBase dist : distributions) {
            result |= dist.mask;
        }
        return result;
    }

    static EnumSet<PatchBase> fromBitfield(int bitfield) {
        EnumSet<PatchBase> result = EnumSet.noneOf(PatchBase.class);
        for (PatchBase dist : PatchBase.values()) {
            if ((bitfield & dist.mask) == 0) continue;
            result.add(dist);
        }
        return result;
    }
}

