/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.binarypatcher.DiffOptions;
import net.neoforged.binarypatcher.Generator;
import net.neoforged.binarypatcher.Patch;
import net.neoforged.binarypatcher.PatchBase;
import net.neoforged.binarypatcher.PatchBundleReader;
import net.neoforged.binarypatcher.PatchOperation;
import net.neoforged.binarypatcher.Patcher;
import net.neoforged.binarypatcher.Util;

public class ConsoleTool {
    public static final boolean DEBUG = Boolean.getBoolean("net.neoforged.binarypatcher.debug");

    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder diffO = parser.accepts("diff");
        OptionSpecBuilder patchO = parser.accepts("patch");
        OptionSpecBuilder listO = parser.accepts("list");
        parser.mutuallyExclusive(new OptionSpecBuilder[]{diffO, patchO, listO});
        ArgumentAcceptingOptionSpec clientBaseO = parser.accepts("base-client").availableIf((OptionSpec)diffO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec serverBaseO = parser.accepts("base-server").availableIf((OptionSpec)diffO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec joinedBaseO = parser.accepts("base-joined").availableIf((OptionSpec)diffO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec clientModifiedO = parser.accepts("modified-client").availableIf((OptionSpec)diffO, new OptionSpec[]{clientBaseO}).requiredIf((OptionSpec)clientBaseO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec serverModifiedO = parser.accepts("modified-server").availableIf((OptionSpec)diffO, new OptionSpec[]{serverBaseO}).requiredIf((OptionSpec)serverBaseO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec joinedModifiedO = parser.accepts("modified-joined").availableIf((OptionSpec)diffO, new OptionSpec[]{joinedBaseO}).requiredIf((OptionSpec)joinedBaseO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        OptionSpecBuilder optimizeConstantPoolO = parser.accepts("optimize-constantpool").availableIf((OptionSpec)diffO, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec includeO = parser.accepts("include").availableIf((OptionSpec)diffO, new OptionSpec[0]).withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec excludeO = parser.accepts("exclude").availableIf((OptionSpec)diffO, new OptionSpec[0]).withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec patchesO = parser.accepts("patches").requiredIf((OptionSpec)patchO, new OptionSpec[]{listO}).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec baseFileO = parser.accepts("base").requiredIf((OptionSpec)patchO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec baseTypeO = parser.accepts("base-type").requiredIf((OptionSpec)patchO, new OptionSpec[0]).withRequiredArg().ofType(PatchBase.class);
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").availableIf((OptionSpec)diffO, new OptionSpec[]{patchO}).requiredIf((OptionSpec)diffO, new OptionSpec[]{patchO}).withRequiredArg().ofType(File.class);
        AbstractOptionSpec helpO = parser.acceptsAll(Arrays.asList("?", "help")).forHelp();
        try {
            OptionSet options = parser.parse(args);
            if (options.has((OptionSpec)helpO)) {
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            if (options.has((OptionSpec)listO)) {
                ConsoleTool.listPatchBundle((File)options.valueOf((OptionSpec)patchesO));
                return;
            }
            File output = ((File)options.valueOf((OptionSpec)outputO)).getAbsoluteFile();
            if (output.exists() && !output.delete()) {
                ConsoleTool.err("Could not delete output file: " + output);
            }
            if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                ConsoleTool.err("Could not make output folders: " + output.getParentFile());
            }
            if (options.has((OptionSpec)diffO)) {
                File joinedBase;
                File serverBase;
                boolean optimizeConstantPool = options.has((OptionSpec)optimizeConstantPoolO);
                Predicate<String> pathFilter = ConsoleTool.createPathFilter(options.valuesOf((OptionSpec)includeO), options.valuesOf((OptionSpec)excludeO));
                EnumMap<PatchBase, File> baseFiles = new EnumMap<PatchBase, File>(PatchBase.class);
                EnumMap<PatchBase, File> modifiedFiles = new EnumMap<PatchBase, File>(PatchBase.class);
                File clientBase = (File)options.valueOf((OptionSpec)clientBaseO);
                if (clientBase != null) {
                    baseFiles.put(PatchBase.CLIENT, clientBase);
                    modifiedFiles.put(PatchBase.CLIENT, (File)Objects.requireNonNull(options.valueOf((OptionSpec)clientModifiedO)));
                }
                if ((serverBase = (File)options.valueOf((OptionSpec)serverBaseO)) != null) {
                    baseFiles.put(PatchBase.SERVER, serverBase);
                    modifiedFiles.put(PatchBase.SERVER, (File)Objects.requireNonNull(options.valueOf((OptionSpec)serverModifiedO)));
                }
                if ((joinedBase = (File)options.valueOf((OptionSpec)joinedBaseO)) != null) {
                    baseFiles.put(PatchBase.JOINED, joinedBase);
                    modifiedFiles.put(PatchBase.JOINED, (File)Objects.requireNonNull(options.valueOf((OptionSpec)joinedModifiedO)));
                }
                if (baseFiles.isEmpty()) {
                    ConsoleTool.err("A base file must be given via any combination of --base-client, --base-server, --base-joined");
                }
                ConsoleTool.log("Generating: ");
                ConsoleTool.log("  Bases:  " + baseFiles);
                ConsoleTool.log("  Modified:  " + modifiedFiles);
                ConsoleTool.log("  Output:  " + output);
                ConsoleTool.log("Diff Options: ");
                ConsoleTool.log("  Optimize Constant Table: " + optimizeConstantPool);
                DiffOptions diffOptions = new DiffOptions();
                diffOptions.setOptimizeConstantPool(optimizeConstantPool);
                diffOptions.setPathFilter(pathFilter);
                Generator.createPatchBundle(baseFiles, modifiedFiles, output, diffOptions);
            } else if (options.has((OptionSpec)patchO)) {
                File baseFile = (File)options.valueOf((OptionSpec)baseFileO);
                PatchBase baseType = (PatchBase)((Object)options.valueOf((OptionSpec)baseTypeO));
                List patches = options.valuesOf((OptionSpec)patchesO);
                long start = System.currentTimeMillis();
                ConsoleTool.log("Applying: ");
                ConsoleTool.log("  Base:      " + baseFile);
                ConsoleTool.log("  Base Type: " + (Object)((Object)baseType));
                ConsoleTool.log("  Output:    " + output);
                ConsoleTool.log("  Patches:   " + patches);
                long startLoadingPatches = System.currentTimeMillis();
                ConsoleTool.debug("Loaded patches in " + (System.currentTimeMillis() - startLoadingPatches) + "ms");
                Patcher.patch(baseFile, baseType, patches, output);
                ConsoleTool.debug("Completed in " + (System.currentTimeMillis() - start) + "ms");
            } else {
                parser.printHelpOn((OutputStream)System.out);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private static Predicate<String> createPathFilter(List<String> includes, List<String> excludes) {
        Predicate<String> includeFilter = includes.isEmpty() ? path -> true : Util.createPathFilter(includes);
        Predicate<String> excludeFilter = excludes.isEmpty() ? path -> false : Util.createPathFilter(excludes);
        return excludeFilter.negate().and(includeFilter);
    }

    private static void listPatchBundle(File patchBundleFile) throws IOException {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        try (PatchBundleReader reader = new PatchBundleReader(patchBundleFile);){
            ArrayList<PatchBase> bases = new ArrayList<PatchBase>(reader.getSupportedBaseTypes());
            int colCount = 4 + bases.size();
            String[] headerRow = new String[colCount];
            headerRow[0] = "Path";
            headerRow[1] = "Operation";
            headerRow[2] = "Base Checksum";
            headerRow[3] = "Size";
            for (int i = 0; i < bases.size(); ++i) {
                headerRow[4 + i] = ((PatchBase)((Object)bases.get(i))).name();
            }
            rows.add(headerRow);
            ArrayList<Object[]> patchSizes = new ArrayList<Object[]>(reader.getEntryCount());
            for (Patch patch : reader) {
                String[] col = new String[colCount];
                col[0] = patch.getTargetPath();
                col[1] = patch.getOperation().name();
                col[2] = patch.getOperation() == PatchOperation.MODIFY ? Long.toHexString(patch.getBaseChecksumUnsigned()) : "";
                col[3] = patch.getOperation() != PatchOperation.REMOVE ? String.valueOf(patch.getData().length) : "";
                for (int i = 0; i < bases.size(); ++i) {
                    col[4 + i] = patch.getBaseTypes().contains(bases.get(i)) ? "X" : "";
                }
                rows.add(col);
                if (patch.getOperation() != PatchOperation.MODIFY) continue;
                patchSizes.add(new Object[]{patch.getTargetPath(), patch.getData().length});
            }
            ConsoleTool.printMarkdownTable(rows);
            System.out.println();
            patchSizes.sort(Comparator.comparingInt(row -> (Integer)row[1]).reversed());
            System.out.println("Largest MODIFY patches:");
            System.out.println();
            ArrayList<String[]> maxSizeRows = new ArrayList<String[]>(11);
            maxSizeRows.add(new String[]{"Target Path", "Size"});
            for (int i = 0; i < Math.min(10, patchSizes.size()); ++i) {
                maxSizeRows.add(new String[]{((Object[])patchSizes.get(i))[0].toString(), ((Object[])patchSizes.get(i))[1].toString()});
            }
            ConsoleTool.printMarkdownTable(maxSizeRows);
        }
    }

    private static void printMarkdownTable(List<String[]> rows) {
        int[] colWidths = new int[rows.get(0).length];
        for (String[] row : rows) {
            for (int i = 0; i < row.length; ++i) {
                colWidths[i] = Math.max(colWidths[i], row[i].length());
            }
        }
        boolean printingHeaderRow = true;
        for (String[] row : rows) {
            for (int i = 0; i < row.length; ++i) {
                String s = row[i];
                System.out.print("| ");
                System.out.print(s);
                System.out.print(ConsoleTool.repeat(' ', colWidths[i] - s.length()));
                System.out.print(" ");
            }
            System.out.print(" |");
            System.out.println();
            if (!printingHeaderRow) continue;
            for (int colWidth : colWidths) {
                System.out.print("| ");
                System.out.print(ConsoleTool.repeat('-', colWidth));
                System.out.print(" ");
            }
            System.out.println(" |");
            printingHeaderRow = false;
        }
    }

    private static String repeat(char ch, int repeat) {
        char[] buffer = new char[repeat];
        Arrays.fill(buffer, ch);
        return String.valueOf(buffer);
    }

    public static void log(String message) {
        System.out.println(message);
    }

    public static void debug(String message) {
        if (DEBUG) {
            ConsoleTool.log(message);
        }
    }

    public static void err(String message) {
        System.out.println(message);
        throw new IllegalStateException(message);
    }
}

