/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import com.nothome.delta.GDiffPatcher;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.neoforged.binarypatcher.ConsoleTool;
import net.neoforged.binarypatcher.Patch;
import net.neoforged.binarypatcher.PatchBase;
import net.neoforged.binarypatcher.PatchBundleReader;
import net.neoforged.binarypatcher.Util;

public class Patcher {
    static final byte[] DELETION_MARKER = new byte[0];
    private static final long ZIPTIME = 628041600000L;

    private Patcher() {
    }

    public static void patch(File baseFile, PatchBase baseType, List<File> patchBundleFiles, File outputFile) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        try (ZipFile baseZip = new ZipFile(baseFile);){
            HashMap<String, byte[]> patchedContent = new HashMap<String, byte[]>();
            for (File patchBundleFile : patchBundleFiles) {
                Patcher.applyPatchBundle(baseFile, baseType, patchBundleFile, patchedContent, baseZip);
            }
            try (ZipOutputStream zOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));){
                Enumeration<? extends ZipEntry> entries = baseZip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    byte[] patched = (byte[])patchedContent.remove(entry.getName());
                    if (patched == DELETION_MARKER) {
                        Patcher.debug("Deleting " + entry.getName());
                        continue;
                    }
                    ZipEntry newEntry = Util.copyEntry(entry);
                    zOut.putNextEntry(newEntry);
                    if (patched != null) {
                        zOut.write(patched);
                    } else {
                        Util.copy(baseZip, entry, zOut);
                    }
                    zOut.closeEntry();
                }
                for (Map.Entry entry : patchedContent.entrySet()) {
                    if (entry.getValue() == DELETION_MARKER) {
                        throw new IllegalStateException("Somehow " + (String)entry.getKey() + " was deleted although it does not exist.");
                    }
                    zOut.putNextEntry(Patcher.getNewEntry((String)entry.getKey()));
                    zOut.write((byte[])entry.getValue());
                    zOut.closeEntry();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void applyPatchBundle(File baseFile, PatchBase baseType, File patchBundleFile, Map<String, byte[]> patchedContent, ZipFile baseZip) throws IOException {
        try (PatchBundleReader patchBundle = new PatchBundleReader(patchBundleFile);){
            if (!patchBundle.getSupportedBaseTypes().contains((Object)baseType)) {
                throw new IllegalArgumentException("Cannot apply patch bundle " + patchBundleFile + " to " + baseFile + " because it only applies to the base types " + patchBundle.getSupportedBaseTypes());
            }
            for (Patch patch : patchBundle) {
                if (!patch.getBaseTypes().contains((Object)baseType)) continue;
                switch (patch.getOperation()) {
                    case CREATE: {
                        patchedContent.put(patch.getTargetPath(), patch.getData());
                        break;
                    }
                    case MODIFY: {
                        Patcher.applyPatch(patch, baseZip, patchedContent);
                        break;
                    }
                    case REMOVE: {
                        patchedContent.put(patch.getTargetPath(), DELETION_MARKER);
                    }
                }
            }
        }
    }

    private static void applyPatch(Patch patch, ZipFile baseZip, Map<String, byte[]> patchedContent) throws IOException {
        byte[] currentData = patchedContent.get(patch.getTargetPath());
        if (currentData == null) {
            ZipEntry entry = baseZip.getEntry(patch.getTargetPath());
            if (entry == null) {
                throw new IllegalStateException("Patch targets " + patch.getTargetPath() + ", but it does not exist in the base.");
            }
            currentData = Util.toByteArray(baseZip, entry);
        } else if (currentData == DELETION_MARKER) {
            throw new IllegalStateException("Patch targets " + patch.getTargetPath() + ", but it was deleted by an earlier patch bundle.");
        }
        long checksum = Patch.checksum(currentData);
        if (checksum != patch.getBaseChecksumUnsigned()) {
            throw new IOException("Patch expected " + patch.getTargetPath() + " to have the checksum " + Long.toHexString(patch.getBaseChecksumUnsigned()) + " but it was " + Long.toHexString(checksum));
        }
        byte[] patchedData = new GDiffPatcher().patch(currentData, patch.getData());
        patchedContent.put(patch.getTargetPath(), patchedData);
    }

    private static ZipEntry getNewEntry(String name) {
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(628041600000L);
        return ret;
    }

    private static void debug(String message) {
        if (ConsoleTool.DEBUG) {
            System.out.println(message);
        }
    }

    private void log(String message) {
        System.out.println(message);
    }
}

