/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Util {
    public static byte[] toByteArray(ZipFile zf, ZipEntry entry) throws IOException {
        int estimatedSize = entry.getSize() != -1L ? (int)entry.getSize() : (entry.getCompressedSize() != -1L ? (int)(entry.getCompressedSize() * 2L) : 8192);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(estimatedSize);
        byte[] data = new byte[8192];
        try (InputStream in = zf.getInputStream(entry);){
            int nRead;
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static void copy(ZipFile zipFile, ZipEntry entry, OutputStream target) throws IOException {
        try (InputStream in = zipFile.getInputStream(entry);){
            Util.copy(in, target);
        }
    }

    public static void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) != -1) {
            target.write(buf, 0, length);
        }
    }

    static ZipEntry copyEntry(ZipEntry entry) {
        ZipEntry newEntry = new ZipEntry(entry.getName());
        newEntry.setTime(entry.getTime());
        if (entry.getLastModifiedTime() != null) {
            newEntry.setLastModifiedTime(entry.getLastModifiedTime());
        }
        if (entry.getLastAccessTime() != null) {
            newEntry.setLastAccessTime(entry.getLastAccessTime());
        }
        if (entry.getCreationTime() != null) {
            newEntry.setCreationTime(entry.getCreationTime());
        }
        return newEntry;
    }

    public static Predicate<String> createPathFilter(Collection<String> filters) {
        String regexp = Util.pathFilterToRegexp(filters);
        return Pattern.compile(regexp).asPredicate();
    }

    public static String pathFilterToRegexp(Collection<String> filters) {
        if (filters.isEmpty()) {
            throw new IllegalArgumentException("Can't build an empty filter");
        }
        StringBuilder regex = new StringBuilder("^(?:");
        boolean first = true;
        for (String filter : filters) {
            if (first) {
                first = false;
            } else {
                regex.append('|');
            }
            int i = 0;
            while (i < filter.length()) {
                char c = filter.charAt(i);
                if (c == '*') {
                    if (i + 1 < filter.length() && filter.charAt(i + 1) == '*') {
                        if (i + 2 < filter.length() && filter.charAt(i + 2) == '/') {
                            regex.append("(?:.*/)?");
                            i += 3;
                            continue;
                        }
                        if (i + 2 == filter.length()) {
                            regex.append(".*");
                            i += 2;
                            continue;
                        }
                        regex.append(".*");
                        i += 2;
                        continue;
                    }
                    regex.append("[^/]*");
                    ++i;
                    continue;
                }
                if (c == '?') {
                    regex.append("[^/]");
                    ++i;
                    continue;
                }
                if ("\\[](){}+|^$.".indexOf(c) != -1) {
                    regex.append('\\');
                }
                regex.append(c);
                ++i;
            }
        }
        regex.append(")$");
        return regex.toString();
    }
}

