/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import com.nothome.delta.Delta;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.Adler32;
import net.neoforged.binarypatcher.DiffOptions;
import net.neoforged.binarypatcher.PatchBase;
import net.neoforged.binarypatcher.PatchOperation;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class Patch {
    private final PatchOperation operation;
    private final String targetPath;
    private final EnumSet<PatchBase> baseTypes;
    private final long baseChecksum;
    private final byte[] data;

    Patch(PatchOperation operation, String targetPath, EnumSet<PatchBase> baseTypes, Long baseChecksum, byte[] data) {
        this.operation = operation;
        this.targetPath = targetPath;
        this.baseTypes = baseTypes;
        this.baseChecksum = operation == PatchOperation.MODIFY ? Objects.requireNonNull(baseChecksum, "baseChecksum") : -1L;
        this.data = data;
    }

    public PatchOperation getOperation() {
        return this.operation;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public EnumSet<PatchBase> getBaseTypes() {
        return this.baseTypes;
    }

    public long getBaseChecksum() {
        return this.baseChecksum;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getBaseChecksumUnsigned() {
        if (this.baseChecksum == -1L) {
            throw new IllegalStateException("Base checksum not available for " + (Object)((Object)this.operation) + " entries");
        }
        return this.baseChecksum & 0xFFFFFFFFL;
    }

    public static void from(String targetPath, EnumMap<PatchBase, byte[]> baseData, byte @Nullable [] patchedData, DiffOptions options, Consumer<Patch> consumer) throws IOException {
        EnumSet<PatchBase> basesWithFile = EnumSet.noneOf(PatchBase.class);
        for (Map.Entry<PatchBase, byte[]> entry : baseData.entrySet()) {
            if (entry.getValue() == null) continue;
            basesWithFile.add(entry.getKey());
        }
        if (patchedData == null) {
            if (!basesWithFile.isEmpty()) {
                consumer.accept(new Patch(PatchOperation.REMOVE, targetPath, basesWithFile, null, null));
            }
            return;
        }
        EnumSet<PatchBase> basesWithoutFile = EnumSet.copyOf(baseData.keySet());
        basesWithoutFile.removeAll(basesWithFile);
        if (!basesWithoutFile.isEmpty()) {
            consumer.accept(new Patch(PatchOperation.CREATE, targetPath, basesWithoutFile, null, patchedData));
        }
        if (basesWithFile.isEmpty()) {
            return;
        }
        Collection<List<Map.Entry>> baseDataGroups = baseData.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.groupingBy(e -> Patch.hashContent((byte[])e.getValue()))).values();
        for (List<Map.Entry> baseDataGroup : baseDataGroups) {
            byte[] base = (byte[])baseDataGroup.get(0).getValue();
            byte[] actualPatchData = patchedData;
            if (options.isOptimizeConstantPool() && targetPath.endsWith(".class")) {
                actualPatchData = Patch.shrinkDirtyForPatch(base, actualPatchData);
            }
            EnumSet<PatchBase> baseTypes = EnumSet.noneOf(PatchBase.class);
            for (Map.Entry groupEntry : baseDataGroup) {
                baseTypes.add((PatchBase)((Object)groupEntry.getKey()));
            }
            byte[] patchData = new Delta().compute(base, actualPatchData);
            long checksum = Patch.checksum(base);
            consumer.accept(new Patch(PatchOperation.MODIFY, targetPath, baseTypes, checksum, patchData));
        }
    }

    public static Patch createAdd(String targetPath, byte[] patchedData, EnumSet<PatchBase> bases) {
        return new Patch(PatchOperation.CREATE, targetPath, bases, null, patchedData);
    }

    public static Patch createRemove(String targetPath, EnumSet<PatchBase> bases) {
        return new Patch(PatchOperation.REMOVE, targetPath, bases, null, null);
    }

    public static Patch createModified(String targetPath, byte[] baseData, byte[] patchedData, EnumSet<PatchBase> bases, DiffOptions options) throws IOException {
        byte[] actualPatchData = patchedData;
        if (options.isOptimizeConstantPool() && targetPath.endsWith(".class")) {
            actualPatchData = Patch.shrinkDirtyForPatch(baseData, actualPatchData);
        }
        byte[] patchData = new Delta().compute(baseData, actualPatchData);
        long checksum = Patch.checksum(baseData);
        return new Patch(PatchOperation.MODIFY, targetPath, bases, checksum, patchData);
    }

    private static String hashContent(byte[] value) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return Base64.getEncoder().encodeToString(digest.digest(value));
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    private static byte[] shrinkDirtyForPatch(byte[] clean, byte[] dirty) {
        if (clean.length == 0 || dirty.length == 0) {
            return dirty;
        }
        ClassReader cleanReader = new ClassReader(clean);
        ClassReader dirtyReader = new ClassReader(dirty);
        ClassWriter writer = new ClassWriter(cleanReader, 0);
        dirtyReader.accept(writer, 0);
        return writer.toByteArray();
    }

    public static long checksum(byte[] input) {
        Adler32 hasher = new Adler32();
        hasher.update(input);
        return hasher.getValue();
    }
}

