/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Set;
import net.neoforged.binarypatcher.Patch;
import net.neoforged.binarypatcher.PatchBase;
import net.neoforged.binarypatcher.PatchBundleConstants;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAOutputStream;

public class PatchBundleWriter
implements AutoCloseable {
    private final OutputStream output;
    private final EnumSet<PatchBase> bundleDistributions;
    private final ByteArrayOutputStream entryBuffer;
    private int entryCount;
    private boolean closed;

    public PatchBundleWriter(OutputStream output, Set<PatchBase> bundleDistributions) {
        if (bundleDistributions.isEmpty()) {
            throw new IllegalArgumentException("Bundle must target at least one distribution");
        }
        this.output = output;
        this.bundleDistributions = EnumSet.copyOf(bundleDistributions);
        this.entryBuffer = new ByteArrayOutputStream();
    }

    public void writeCreateEntry(String targetPath, byte[] fileContent, EnumSet<PatchBase> entryDistributions) throws IOException {
        this.validateEntry(entryDistributions, targetPath);
        int flags = 0 | PatchBase.toBitfield(entryDistributions);
        this.writeEntryInternal(flags, targetPath, 0L, fileContent);
    }

    public void writeModifyEntry(String targetPath, long baseChecksum, byte[] patchData, EnumSet<PatchBase> entryDistributions) throws IOException {
        this.validateEntry(entryDistributions, targetPath);
        if (baseChecksum < 0L || baseChecksum > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Base checksum must be a valid 32-bit unsigned value");
        }
        int flags = 8 | PatchBase.toBitfield(entryDistributions);
        this.writeEntryInternal(flags, targetPath, baseChecksum, patchData);
    }

    public void writeRemoveEntry(String targetPath, EnumSet<PatchBase> entryDistributions) throws IOException {
        this.validateEntry(entryDistributions, targetPath);
        int flags = 0x10 | PatchBase.toBitfield(entryDistributions);
        this.writeEntryInternal(flags, targetPath, 0L, new byte[0]);
    }

    public void write(Patch patch) throws IOException {
        switch (patch.getOperation()) {
            case CREATE: {
                this.writeCreateEntry(patch.getTargetPath(), patch.getData(), patch.getBaseTypes());
                break;
            }
            case MODIFY: {
                this.writeModifyEntry(patch.getTargetPath(), patch.getBaseChecksumUnsigned(), patch.getData(), patch.getBaseTypes());
                break;
            }
            case REMOVE: {
                this.writeRemoveEntry(patch.getTargetPath(), patch.getBaseTypes());
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(buffer);
            dos.write(PatchBundleConstants.BUNDLE_SIGNATURE);
            dos.writeInt(this.entryCount);
            dos.writeByte(PatchBase.toBitfield(this.bundleDistributions));
            this.entryBuffer.writeTo(buffer);
            LZMA2Options options = new LZMA2Options();
            try (LZMAOutputStream lzmaOutput = new LZMAOutputStream(this.output, options, buffer.size());){
                lzmaOutput.write(buffer.toByteArray());
            }
            this.output.close();
            this.closed = true;
        }
    }

    private void validateEntry(EnumSet<PatchBase> entryDistributions, String targetPath) {
        if (this.closed) {
            throw new IllegalStateException("Bundle already closed");
        }
        this.validatePath(targetPath);
        if (entryDistributions.isEmpty()) {
            throw new IllegalArgumentException(String.format("Entry '%s' must target at least one distribution", targetPath));
        }
        for (PatchBase dist : entryDistributions) {
            if (this.bundleDistributions.contains((Object)dist)) continue;
            throw new IllegalArgumentException(String.format("Entry '%s' targets distribution %s not declared in bundle", new Object[]{targetPath, dist}));
        }
    }

    private void writeEntryInternal(int flags, String targetPath, long baseChecksum, byte[] data) throws IOException {
        this.validatePath(targetPath);
        DataOutputStream dos = new DataOutputStream(this.entryBuffer);
        dos.writeByte(flags);
        this.writeString(dos, targetPath);
        if ((flags & 0x18) == 8) {
            dos.writeInt((int)baseChecksum);
        }
        dos.writeInt(data.length);
        dos.write(data);
        ++this.entryCount;
    }

    private void writeString(DataOutputStream dos, String str) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
        if (bytes.length > 65535) {
            throw new IllegalArgumentException("String too long: " + str);
        }
        for (byte b : bytes) {
            if (b >= 32 && b <= 126) continue;
            throw new IllegalArgumentException("String contains invalid characters: " + str);
        }
        dos.writeShort(bytes.length);
        dos.write(bytes);
    }

    private void validatePath(String path) {
        String[] segments;
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path cannot be null or empty");
        }
        path.codePoints().forEach(codePoint -> {
            if (codePoint < 32 || codePoint > 126) {
                throw new IllegalArgumentException("Path '" + path + "' contains invalid characters.");
            }
        });
        for (String segment : segments = path.split("/", -1)) {
            if (segment.isEmpty()) {
                throw new IllegalArgumentException("Path contains empty segment: " + path);
            }
            if (!segment.equals(".") && !segment.equals("..")) continue;
            throw new IllegalArgumentException("Path contains . or .. segment: " + path);
        }
    }
}

