/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.neoforged.binarypatcher.Patch;
import net.neoforged.binarypatcher.PatchBase;
import net.neoforged.binarypatcher.PatchBundleConstants;
import net.neoforged.binarypatcher.PatchOperation;
import org.tukaani.xz.LZMAInputStream;

public class PatchBundleReader
implements Iterable<Patch>,
AutoCloseable {
    private final DataInputStream input;
    private final EnumSet<PatchBase> supportedBaseTypes;
    private final int entryCount;
    private int entriesRead;
    private boolean closed;

    public PatchBundleReader(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public PatchBundleReader(InputStream input) throws IOException {
        this.input = new DataInputStream((InputStream)new LZMAInputStream(input));
        byte[] signature = new byte[PatchBundleConstants.BUNDLE_SIGNATURE.length];
        this.input.readFully(signature);
        if (!Arrays.equals(signature, PatchBundleConstants.BUNDLE_SIGNATURE)) {
            throw new IOException("Invalid bundle signature");
        }
        this.entryCount = this.input.readInt();
        if (this.entryCount < 0) {
            throw new IOException("Invalid entry count: " + this.entryCount);
        }
        int distBitfield = this.input.readUnsignedByte();
        this.supportedBaseTypes = PatchBase.fromBitfield(distBitfield);
        this.entriesRead = 0;
        this.closed = false;
    }

    public EnumSet<PatchBase> getSupportedBaseTypes() {
        return EnumSet.copyOf(this.supportedBaseTypes);
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public int getEntriesRead() {
        return this.entriesRead;
    }

    public boolean hasMoreEntries() {
        return this.entriesRead < this.entryCount;
    }

    @Override
    public Iterator<Patch> iterator() {
        if (this.entriesRead > 0) {
            throw new IllegalStateException("Cannot create multiple iterators or iterate after manual read");
        }
        return new EntryIterator();
    }

    public Patch readEntry() throws IOException {
        int dataLength;
        PatchOperation type;
        if (this.closed) {
            throw new IllegalStateException("Reader is closed");
        }
        if (!this.hasMoreEntries()) {
            return null;
        }
        int flags = this.input.readUnsignedByte();
        int entryTypeBits = flags & 0x18;
        int distBitfield = flags & 7;
        switch (entryTypeBits) {
            case 0: {
                type = PatchOperation.CREATE;
                break;
            }
            case 8: {
                type = PatchOperation.MODIFY;
                break;
            }
            case 16: {
                type = PatchOperation.REMOVE;
                break;
            }
            default: {
                throw new IOException("Unknown entry type: " + entryTypeBits);
            }
        }
        EnumSet<PatchBase> entryDists = PatchBase.fromBitfield(distBitfield);
        for (PatchBase dist : entryDists) {
            if (this.supportedBaseTypes.contains((Object)dist)) continue;
            throw new IOException("Entry targets distribution " + (Object)((Object)dist) + " not declared in bundle");
        }
        String targetPath = this.readString();
        Long baseChecksum = null;
        if (type == PatchOperation.MODIFY) {
            baseChecksum = this.input.readInt();
        }
        if ((dataLength = this.input.readInt()) < 0) {
            throw new IOException("Invalid data length: " + dataLength);
        }
        if (type == PatchOperation.REMOVE && dataLength != 0) {
            throw new IOException("REMOVE entry must have data length of 0");
        }
        byte[] data = new byte[dataLength];
        if (dataLength > 0) {
            this.input.readFully(data);
        }
        ++this.entriesRead;
        return new Patch(type, targetPath, entryDists, baseChecksum, data);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.input.close();
            this.closed = true;
        }
    }

    private String readString() throws IOException {
        int length = this.input.readUnsignedShort();
        byte[] bytes = new byte[length];
        this.input.readFully(bytes);
        for (byte b : bytes) {
            if (b >= 32 && b <= 126) continue;
            throw new IOException("String contains invalid character: 0x" + Integer.toHexString(b & 0xFF));
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private class EntryIterator
    implements Iterator<Patch> {
        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return PatchBundleReader.this.hasMoreEntries();
        }

        @Override
        public Patch next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more entries");
            }
            try {
                return PatchBundleReader.this.readEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading entry", e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

