/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.binarypatcher.ConsoleTool;
import net.neoforged.binarypatcher.DiffOptions;
import net.neoforged.binarypatcher.Patch;
import net.neoforged.binarypatcher.PatchBase;
import net.neoforged.binarypatcher.PatchBundleWriter;
import net.neoforged.binarypatcher.PatchOperation;
import net.neoforged.binarypatcher.Util;

public final class Generator {
    private Generator() {
    }

    public static void createPatchBundle(Map<PatchBase, File> baseFiles, Map<PatchBase, File> modifiedFiles, File patchBundleFile, DiffOptions diffOptions) throws IOException {
        Set<PatchBase> bases = baseFiles.keySet();
        if (!bases.equals(modifiedFiles.keySet())) {
            throw new IllegalArgumentException("The same set of base and modified files must be provided: " + baseFiles.keySet() + " != " + modifiedFiles.keySet());
        }
        LinkedHashMap<DiffTask, DiffTask> tasks = new LinkedHashMap<DiffTask, DiffTask>();
        for (PatchBase base : bases) {
            File baseFile = baseFiles.get((Object)base);
            File modifiedFile = modifiedFiles.get((Object)base);
            ZipFile baseZip = new ZipFile(baseFile);
            Throwable throwable = null;
            try {
                ZipFile modifiedZip = new ZipFile(modifiedFile);
                Throwable throwable2 = null;
                try {
                    DiffTask previousTask;
                    DiffTask task;
                    ZipEntry modifiedEntry;
                    Enumeration<? extends ZipEntry> baseEntries = baseZip.entries();
                    while (baseEntries.hasMoreElements()) {
                        ZipEntry baseEntry = baseEntries.nextElement();
                        if (baseEntry.isDirectory()) continue;
                        modifiedEntry = modifiedZip.getEntry(baseEntry.getName());
                        if (modifiedEntry == null) {
                            task = new DiffTask(baseEntry.getName(), PatchOperation.REMOVE, null, null);
                        } else {
                            byte[] modifiedContent;
                            byte[] baseContent = Util.toByteArray(baseZip, baseEntry);
                            if (Arrays.equals(baseContent, modifiedContent = Util.toByteArray(modifiedZip, modifiedEntry))) continue;
                            task = new DiffTask(baseEntry.getName(), PatchOperation.MODIFY, baseContent, modifiedContent);
                        }
                        previousTask = tasks.putIfAbsent(task, task);
                        if (previousTask != null) {
                            task = previousTask;
                        }
                        task.bases.add(base);
                    }
                    Enumeration<? extends ZipEntry> modifiedEntries = modifiedZip.entries();
                    while (modifiedEntries.hasMoreElements()) {
                        modifiedEntry = modifiedEntries.nextElement();
                        if (modifiedEntry.isDirectory() || baseZip.getEntry(modifiedEntry.getName()) != null) continue;
                        task = new DiffTask(modifiedEntry.getName(), PatchOperation.CREATE, null, Util.toByteArray(modifiedZip, modifiedEntry));
                        previousTask = tasks.putIfAbsent(task, task);
                        if (previousTask != null) {
                            task = previousTask;
                        }
                        task.bases.add(base);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (modifiedZip == null) continue;
                    if (throwable2 != null) {
                        try {
                            modifiedZip.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    modifiedZip.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (baseZip == null) continue;
                if (throwable != null) {
                    try {
                        baseZip.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                baseZip.close();
            }
        }
        try (BufferedOutputStream bundleOut = new BufferedOutputStream(new FileOutputStream(patchBundleFile));
             PatchBundleWriter bundleWriter = new PatchBundleWriter(bundleOut, baseFiles.keySet());){
            Generator.log("Processing " + tasks.size() + " diff tasks");
            for (DiffTask task : tasks.values()) {
                bundleWriter.write(task.createPatch(diffOptions));
            }
        }
    }

    private static void log(String message) {
        ConsoleTool.log(message);
    }

    private static class DiffTask {
        private final String targetPath;
        private final int hashCode;
        private final PatchOperation operation;
        private final byte[] baseContent;
        private final byte[] modifiedContent;
        private final EnumSet<PatchBase> bases = EnumSet.noneOf(PatchBase.class);

        public DiffTask(String targetPath, PatchOperation operation, byte[] baseContent, byte[] modifiedContent) {
            this.targetPath = targetPath;
            this.operation = operation;
            this.baseContent = baseContent;
            this.modifiedContent = modifiedContent;
            this.hashCode = Objects.hash(new Object[]{targetPath, operation, Arrays.hashCode(baseContent), Arrays.hashCode(modifiedContent)});
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffTask other = (DiffTask)o;
            return this.operation == other.operation && this.targetPath.equals(other.targetPath) && Objects.deepEquals(this.baseContent, other.baseContent) && Objects.deepEquals(this.modifiedContent, other.modifiedContent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public Patch createPatch(DiffOptions diffOptions) throws IOException {
            switch (this.operation) {
                case CREATE: {
                    return Patch.createAdd(this.targetPath, this.modifiedContent, this.bases);
                }
                case REMOVE: {
                    return Patch.createRemove(this.targetPath, this.bases);
                }
                case MODIFY: {
                    return Patch.createModified(this.targetPath, this.baseContent, this.modifiedContent, this.bases, diffOptions);
                }
            }
            throw new IllegalStateException("Unknown task operation: " + (Object)((Object)this.operation));
        }
    }
}

