/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.binarypatcher.DiffOptions;
import net.neoforged.binarypatcher.Generator;
import net.neoforged.binarypatcher.Patch;
import net.neoforged.binarypatcher.PatchBase;
import net.neoforged.binarypatcher.PatchBundleReader;
import net.neoforged.binarypatcher.PatchOperation;
import net.neoforged.binarypatcher.Patcher;

public class ConsoleTool {
    public static final boolean DEBUG = Boolean.getBoolean("net.neoforged.binarypatcher.debug");

    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder diffO = parser.accepts("diff");
        OptionSpecBuilder patchO = parser.accepts("patch");
        OptionSpecBuilder listO = parser.accepts("list");
        parser.mutuallyExclusive(diffO, patchO, listO);
        ArgumentAcceptingOptionSpec<File> clientBaseO = parser.accepts("base-client").availableIf(diffO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> serverBaseO = parser.accepts("base-server").availableIf(diffO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> joinedBaseO = parser.accepts("base-joined").availableIf(diffO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> clientModifiedO = parser.accepts("modified-client").availableIf(diffO, clientBaseO).requiredIf(clientBaseO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> serverModifiedO = parser.accepts("modified-server").availableIf(diffO, serverBaseO).requiredIf(serverBaseO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> joinedModifiedO = parser.accepts("modified-joined").availableIf(diffO, joinedBaseO).requiredIf(joinedBaseO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        OptionSpecBuilder optimizeConstantPoolO = parser.accepts("optimize-constantpool").availableIf(diffO, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec<File> patchesO = parser.accepts("patches").requiredIf(patchO, listO).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> baseFileO = parser.accepts("base").requiredIf(patchO, new OptionSpec[0]).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<PatchBase> baseTypeO = parser.accepts("base-type").requiredIf(patchO, new OptionSpec[0]).withRequiredArg().ofType(PatchBase.class);
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output").availableIf(diffO, patchO).requiredIf(diffO, patchO).withRequiredArg().ofType(File.class);
        AbstractOptionSpec helpO = parser.acceptsAll(Arrays.asList("?", "help")).forHelp();
        try {
            OptionSet options = parser.parse(args);
            if (options.has(helpO)) {
                parser.printHelpOn(System.out);
                return;
            }
            if (options.has(listO)) {
                ConsoleTool.listPatchBundle(options.valueOf(patchesO));
                return;
            }
            File output = options.valueOf(outputO).getAbsoluteFile();
            boolean optimizeConstantPool = options.has(optimizeConstantPoolO);
            if (output.exists() && !output.delete()) {
                ConsoleTool.err("Could not delete output file: " + output);
            }
            if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                ConsoleTool.err("Could not make output folders: " + output.getParentFile());
            }
            if (options.has(diffO)) {
                File joinedBase;
                File serverBase;
                EnumMap<PatchBase, File> baseFiles = new EnumMap<PatchBase, File>(PatchBase.class);
                EnumMap<PatchBase, File> modifiedFiles = new EnumMap<PatchBase, File>(PatchBase.class);
                File clientBase = options.valueOf(clientBaseO);
                if (clientBase != null) {
                    baseFiles.put(PatchBase.CLIENT, clientBase);
                    modifiedFiles.put(PatchBase.CLIENT, Objects.requireNonNull(options.valueOf(clientModifiedO)));
                }
                if ((serverBase = options.valueOf(serverBaseO)) != null) {
                    baseFiles.put(PatchBase.SERVER, serverBase);
                    modifiedFiles.put(PatchBase.SERVER, Objects.requireNonNull(options.valueOf(serverModifiedO)));
                }
                if ((joinedBase = options.valueOf(joinedBaseO)) != null) {
                    baseFiles.put(PatchBase.JOINED, joinedBase);
                    modifiedFiles.put(PatchBase.JOINED, Objects.requireNonNull(options.valueOf(joinedModifiedO)));
                }
                if (baseFiles.isEmpty()) {
                    ConsoleTool.err("A base file must be given via any combination of --base-client, --base-server, --base-joined");
                }
                ConsoleTool.log("Generating: ");
                ConsoleTool.log("  Bases:  " + baseFiles);
                ConsoleTool.log("  Modified:  " + modifiedFiles);
                ConsoleTool.log("  Output:  " + output);
                ConsoleTool.log("Diff Options: ");
                ConsoleTool.log("  Optimize Constant Table: " + optimizeConstantPool);
                DiffOptions diffOptions = new DiffOptions();
                diffOptions.setOptimizeConstantPool(optimizeConstantPool);
                Generator.createPatchBundle(baseFiles, modifiedFiles, output, diffOptions);
            } else if (options.has(patchO)) {
                File baseFile = options.valueOf(baseFileO);
                PatchBase baseType = options.valueOf(baseTypeO);
                List<File> patches = options.valuesOf(patchesO);
                long start = System.currentTimeMillis();
                ConsoleTool.log("Applying: ");
                ConsoleTool.log("  Base:      " + baseFile);
                ConsoleTool.log("  Base Type: " + (Object)((Object)baseType));
                ConsoleTool.log("  Output:    " + output);
                ConsoleTool.log("  Patches:   " + patches);
                long startLoadingPatches = System.currentTimeMillis();
                ConsoleTool.debug("Loaded patches in " + (System.currentTimeMillis() - startLoadingPatches) + "ms");
                Patcher.patch(baseFile, baseType, patches, output);
                ConsoleTool.debug("Completed in " + (System.currentTimeMillis() - start) + "ms");
            } else {
                parser.printHelpOn(System.out);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }

    private static void listPatchBundle(File patchBundleFile) throws IOException {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        try (PatchBundleReader reader = new PatchBundleReader(patchBundleFile);){
            int i;
            ArrayList<PatchBase> bases = new ArrayList<PatchBase>(reader.getSupportedBaseTypes());
            int colCount = 3 + bases.size();
            String[] headerRow = new String[colCount];
            headerRow[0] = "Path";
            headerRow[1] = "Operation";
            headerRow[2] = "Base Checksum";
            for (int i2 = 0; i2 < bases.size(); ++i2) {
                headerRow[3 + i2] = ((PatchBase)((Object)bases.get(i2))).name();
            }
            rows.add(headerRow);
            for (Object patch : reader) {
                String[] col = new String[colCount];
                col[0] = ((Patch)patch).getTargetPath();
                col[1] = ((Patch)patch).getOperation().name();
                col[2] = ((Patch)patch).getOperation() == PatchOperation.MODIFY ? Long.toHexString(((Patch)patch).getBaseChecksumUnsigned()) : "";
                for (i = 0; i < bases.size(); ++i) {
                    col[3 + i] = ((Patch)patch).getBaseTypes().contains(bases.get(i)) ? "X" : "";
                }
                rows.add(col);
            }
            int[] colWidths = new int[colCount];
            for (String[] row : rows) {
                for (i = 0; i < row.length; ++i) {
                    colWidths[i] = Math.max(colWidths[i], row[i].length());
                }
            }
            boolean printingHeaderRow = true;
            for (String[] row : rows) {
                for (int i3 = 0; i3 < row.length; ++i3) {
                    String s = row[i3];
                    System.out.print("| ");
                    System.out.print(s);
                    System.out.print(ConsoleTool.repeat(' ', colWidths[i3] - s.length()));
                    System.out.print(" ");
                }
                System.out.print(" |");
                System.out.println();
                if (!printingHeaderRow) continue;
                for (int colWidth : colWidths) {
                    System.out.print("| ");
                    System.out.print(ConsoleTool.repeat('-', colWidth));
                    System.out.print(" ");
                }
                System.out.println(" |");
                printingHeaderRow = false;
            }
        }
    }

    private static String repeat(char ch, int repeat) {
        char[] buffer = new char[repeat];
        Arrays.fill(buffer, ch);
        return String.valueOf(buffer);
    }

    public static void log(String message) {
        System.out.println(message);
    }

    public static void debug(String message) {
        if (DEBUG) {
            ConsoleTool.log(message);
        }
    }

    public static void err(String message) {
        System.out.println(message);
        throw new IllegalStateException(message);
    }
}

