/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.internal.binarypatchapplier.xdelta;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.neoforged.internal.binarypatchapplier.xdelta.SeekableSource;

public final class ByteBufferSeekableSource
implements SeekableSource {
    private ByteBuffer bb;
    private ByteBuffer cur;

    /*
     * WARNING - void declaration
     */
    public ByteBufferSeekableSource(byte[] source) {
        this(ByteBuffer.wrap((byte[])var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBufferSeekableSource(ByteBuffer bb) {
        if (bb == null) {
            throw new NullPointerException("bb");
        }
        this.bb = bb;
        ((Buffer)bb).rewind();
        try {
            this.seek(0L);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void seek(long pos) throws IOException {
        void var1_1;
        this.cur = this.bb.slice();
        if (pos > (long)this.cur.limit()) {
            throw new IOException("pos " + pos + " cannot seek " + this.cur.limit());
        }
        ((Buffer)this.cur).position((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int read(ByteBuffer dest) throws IOException {
        void var2_2;
        if (!this.cur.hasRemaining()) {
            return -1;
        }
        int c = 0;
        while (this.cur.hasRemaining() && dest.hasRemaining()) {
            dest.put(this.cur.get());
            ++c;
        }
        return (int)var2_2;
    }

    public final void close() throws IOException {
        this.bb = null;
        this.cur = null;
    }

    public final String toString() {
        return "BBSeekable bb=" + this.bb.position() + "-" + this.bb.limit() + " cur=" + this.cur.position() + "-" + this.cur.limit();
    }
}

