/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.internal.binarypatchapplier;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.neoforged.internal.binarypatchapplier.Patch;
import net.neoforged.internal.binarypatchapplier.PatchBase;
import net.neoforged.internal.binarypatchapplier.PatchBundleReader;
import net.neoforged.internal.binarypatchapplier.xdelta.GDiffPatcher;

public class Patcher {
    private static byte[] DELETION_MARKER = new byte[0];

    private Patcher() {
    }

    /*
     * WARNING - void declaration
     */
    public static void patch(File baseFile, PatchBase baseType, String inputName, InputStream input, File outputFile, Consumer<String> debugOutput) {
        void var2_2;
        void var1_1;
        File file;
        void var3_3;
        List<StreamInput> inputs = Collections.singletonList(new StreamInput(inputName, (InputStream)var3_3));
        Patcher.patchInternal(file, (PatchBase)var1_1, (List<Input>)var2_2, outputFile, debugOutput);
    }

    /*
     * WARNING - void declaration
     */
    public static void patch(File baseFile, PatchBase baseType, List<File> patchBundleFiles, File outputFile, Consumer<String> debugOutput) {
        void var3_3;
        void var2_2;
        void var1_1;
        File file;
        List fileInputs = patchBundleFiles.stream().map(FileInput::new).collect(Collectors.toList());
        Patcher.patchInternal(file, (PatchBase)var1_1, (List<Input>)var2_2, (File)var3_3, debugOutput);
    }

    /*
     * WARNING - void declaration
     */
    private static void patchInternal(File baseFile, PatchBase baseType, List<Input> patchBundles, File outputFile, Consumer<String> debugOutput) {
        try {
            ZipFile baseZip2 = new ZipFile(baseFile);
            Throwable throwable = null;
            try {
                HashMap patchedContent = new HashMap();
                patchBundles = patchBundles.iterator();
                while (patchBundles.hasNext()) {
                    InputStream inputStream;
                    Input patchBundleInput = (Input)patchBundles.next();
                    String patchBundleName = patchBundleInput.name();
                    try {
                        inputStream = patchBundleInput.open();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to open patch bundle ".concat(String.valueOf(patchBundleName)), e);
                    }
                    try {
                        try {
                            Patcher.applyPatchBundle$20693536((PatchBase)e, patchBundleName, inputStream, patchedContent, baseZip2, debugOutput);
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (Throwable e) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            debugOutput.accept("Failed to close patch bundle ".concat(String.valueOf(patchBundleName)));
                        }
                        throw e;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        debugOutput.accept("Failed to close patch bundle ".concat(String.valueOf(patchBundleName)));
                    }
                }
                ZipOutputStream zOut2 = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                Throwable throwable2 = null;
                try {
                    Enumeration<? extends ZipEntry> entries = baseZip2.entries();
                    while (entries.hasMoreElements()) {
                        void var3_10;
                        byte[] patched;
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory() || (patched = (byte[])patchedContent.remove(entry.getName())) == DELETION_MARKER) continue;
                        ZipEntry newEntry = PatchBundleReader.1.copyEntry(entry);
                        zOut2.putNextEntry((ZipEntry)var3_10);
                        if (patched != null) {
                            ((OutputStream)zOut2).write(patched);
                        } else {
                            PatchBundleReader.1.copy$aaf7a41(baseZip2, entry, zOut2);
                        }
                        zOut2.closeEntry();
                    }
                    for (Map.Entry entry : patchedContent.entrySet()) {
                        void var1_3;
                        if (entry.getValue() == DELETION_MARKER) {
                            throw new IllegalStateException("Somehow " + (String)entry.getKey() + " was deleted although it does not exist.");
                        }
                        zOut2.putNextEntry(Patcher.getNewEntry((String)entry.getKey()));
                        ((OutputStream)zOut2).write((byte[])var1_3.getValue());
                        zOut2.closeEntry();
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        Throwable throwable4 = throwable3;
                        throwable2 = throwable3;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)zOut2).close();
                            }
                            catch (Throwable zOut2) {
                                throwable2.addSuppressed(zOut2);
                            }
                        } else {
                            void var2_8;
                            var2_8.close();
                        }
                        throw throwable5;
                    }
                }
                ((OutputStream)zOut2).close();
            }
            catch (Throwable throwable6) {
                try {
                    Throwable throwable7 = throwable6;
                    throwable = throwable6;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    if (throwable != null) {
                        try {
                            baseZip2.close();
                        }
                        catch (Throwable baseZip2) {
                            throwable.addSuppressed(baseZip2);
                        }
                    } else {
                        baseZip2.close();
                    }
                    throw throwable8;
                }
            }
            baseZip2.close();
            return;
        }
        catch (IOException e) {
            void var0_2;
            throw new UncheckedIOException((IOException)var0_2);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    private static void applyPatchBundle$20693536(PatchBase baseType, String patchBundleName, InputStream patchBundleData, HashMap patchedContent, ZipFile baseZip, Consumer debugOutput) throws IOException {
        Throwable throwable;
        PatchBundleReader patchBundle = new PatchBundleReader(patchBundleData);
        Throwable throwable2 = null;
        try {
            if (!patchBundle.getSupportedBaseTypes().contains((Object)baseType)) {
                throw new IllegalArgumentException("Cannot apply patch bundle " + (String)((Object)throwable) + " to " + baseZip.getName() + " because it only applies to the base types " + patchBundle.getSupportedBaseTypes());
            }
            for (Patch patch : patchBundle) {
                if (!patch.getBaseTypes().contains((Object)baseType)) continue;
                switch (patch.getOperation()) {
                    case CREATE: {
                        debugOutput.accept("Adding " + patch.getTargetPath());
                        patchedContent.put(patch.getTargetPath(), patch.getData());
                        break;
                    }
                    case MODIFY: {
                        debugOutput.accept("Patching " + patch.getTargetPath());
                        Patcher.applyPatch$143caf3c(patch, baseZip, patchedContent);
                        break;
                    }
                    case REMOVE: {
                        debugOutput.accept("Deleting " + patch.getTargetPath());
                        patchedContent.put(patch.getTargetPath(), DELETION_MARKER);
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                if (throwable2 != null) {
                    try {
                        patchBundle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                } else {
                    void var2_4;
                    var2_4.close();
                }
                throw throwable4;
            }
        }
        patchBundle.close();
        return;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    private static void applyPatch$143caf3c(Patch patch, ZipFile baseZip, HashMap patchedContent) throws IOException {
        void var1_1;
        Patch patch2;
        void var2_2;
        void var3_3;
        byte[] currentData = (byte[])patchedContent.get(patch.getTargetPath());
        if (currentData == null) {
            ZipEntry entry = baseZip.getEntry(patch.getTargetPath());
            if (entry == null) {
                throw new IllegalStateException("Patch targets " + patch.getTargetPath() + ", but it does not exist in the base.");
            }
            currentData = PatchBundleReader.1.toByteArray(baseZip, entry);
        } else if (currentData == DELETION_MARKER) {
            throw new IllegalStateException("Patch targets " + patch.getTargetPath() + ", but it was deleted by an earlier patch bundle.");
        }
        long checksum = Patch.checksum(currentData);
        if (checksum != patch.getBaseChecksumUnsigned()) {
            throw new IOException("Patch expected " + patch.getTargetPath() + " to have the checksum " + Long.toHexString(patch.getBaseChecksumUnsigned()) + " but it was " + Long.toHexString(checksum));
        }
        byte[] patchedData = new GDiffPatcher().patch((byte[])var3_3, patch.getData());
        var2_2.put(patch2.getTargetPath(), var1_1);
    }

    private static ZipEntry getNewEntry(String name) {
        ZipEntry zipEntry;
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(628041600000L);
        return zipEntry;
    }

    static final class StreamInput
    implements Input {
        private final String name;
        private InputStream stream;

        /*
         * WARNING - void declaration
         */
        public StreamInput(String name, InputStream stream) {
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.stream = (InputStream)Objects.requireNonNull(var2_2, "stream");
        }

        @Override
        public final String name() {
            return this.name;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final InputStream open() throws IOException {
            void var1_1;
            if (this.stream == null) {
                throw new IOException("Can only be opened once.");
            }
            InputStream result = this.stream;
            this.stream = null;
            return var1_1;
        }
    }

    static final class FileInput
    implements Input {
        private final File file;

        /*
         * WARNING - void declaration
         */
        public FileInput(File file) {
            void var1_1;
            this.file = var1_1;
        }

        @Override
        public final String name() {
            return this.file.getName();
        }

        @Override
        public final InputStream open() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
    }

    static interface Input {
        public InputStream open() throws IOException;

        public String name();
    }
}

