/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.internal.binarypatchapplier;

import java.util.EnumSet;
import java.util.Objects;
import java.util.zip.Adler32;
import net.neoforged.internal.binarypatchapplier.PatchBase;
import net.neoforged.internal.binarypatchapplier.PatchOperation;

public final class Patch {
    private final PatchOperation operation;
    private final String targetPath;
    private final EnumSet<PatchBase> baseTypes;
    private final long baseChecksum;
    private final byte[] data;

    /*
     * WARNING - void declaration
     */
    Patch(PatchOperation operation, String targetPath, EnumSet<PatchBase> baseTypes, Long baseChecksum, byte[] data) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.operation = operation;
        this.targetPath = var2_2;
        this.baseTypes = var3_3;
        this.baseChecksum = var1_1 == PatchOperation.MODIFY ? Objects.requireNonNull(baseChecksum, "baseChecksum") : -1L;
        this.data = data;
    }

    public final PatchOperation getOperation() {
        return this.operation;
    }

    public final String getTargetPath() {
        return this.targetPath;
    }

    public final EnumSet<PatchBase> getBaseTypes() {
        return this.baseTypes;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final long getBaseChecksumUnsigned() {
        if (this.baseChecksum == -1L) {
            throw new IllegalStateException("Base checksum not available for " + (Object)((Object)this.operation) + " entries");
        }
        return this.baseChecksum & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    public static long checksum(byte[] input) {
        void var1_1;
        byte[] byArray;
        Adler32 hasher = new Adler32();
        hasher.update(byArray);
        return var1_1.getValue();
    }
}

