/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.internal.binarypatchapplier.xz.lz;

import java.io.IOException;
import net.neoforged.internal.binarypatchapplier.xz.ArrayCache;
import net.neoforged.internal.binarypatchapplier.xz.CorruptedInputException;

public final class LZDecoder {
    private final byte[] buf;
    private final int bufSize;
    private int start = 0;
    private int pos = 0;
    private int full = 0;
    private int limit = 0;
    private int pendingLen = 0;
    private int pendingDist = 0;

    /*
     * WARNING - void declaration
     */
    public LZDecoder(int dictSize, ArrayCache arrayCache) {
        void var2_2;
        void var1_1;
        this.bufSize = var1_1;
        this.buf = var2_2.getByteArray$48701b37(this.bufSize);
    }

    public final void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    /*
     * WARNING - void declaration
     */
    public final void setLimit(int outMax) {
        void var1_1;
        if (this.bufSize - this.pos <= outMax) {
            this.limit = this.bufSize;
            return;
        }
        this.limit = this.pos + var1_1;
    }

    public final boolean hasSpace() {
        return this.pos < this.limit;
    }

    public final boolean hasPending() {
        return this.pendingLen > 0;
    }

    public final int getPos() {
        return this.pos;
    }

    /*
     * WARNING - void declaration
     */
    public final int getByte(int dist) {
        void var2_2;
        void var1_1;
        int offset = this.pos - dist - 1;
        if (var1_1 >= this.pos) {
            offset += this.bufSize;
        }
        return this.buf[var2_2] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final void putByte(byte b) {
        void var1_1;
        this.buf[this.pos++] = var1_1;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void repeat(int dist, int len) throws IOException {
        int copySize;
        if (dist < 0 || dist >= this.full) {
            throw new CorruptedInputException();
        }
        int left = Math.min(this.limit - this.pos, len);
        this.pendingLen = len - left;
        this.pendingDist = dist;
        int back = this.pos - dist - 1;
        if (back < 0) {
            void var1_1;
            assert (this.full == this.bufSize);
            copySize = Math.min(this.bufSize - (back += this.bufSize), left);
            assert (copySize <= var1_1 + true);
            System.arraycopy(this.buf, back, this.buf, this.pos, copySize);
            this.pos += copySize;
            back = 0;
            if ((left -= copySize) == 0) {
                return;
            }
        }
        assert (back < this.pos);
        assert (left > 0);
        do {
            copySize = Math.min(left, this.pos - back);
            System.arraycopy(this.buf, back, this.buf, this.pos, copySize);
            this.pos += copySize;
        } while ((left -= copySize) > 0);
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public final void repeatPending() throws IOException {
        if (this.pendingLen > 0) {
            LZDecoder lZDecoder = this;
            lZDecoder.repeat(lZDecoder.pendingDist, this.pendingLen);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int flush(byte[] out, int outOff) {
        void var3_3;
        void var2_2;
        void var1_1;
        int copySize = this.pos - this.start;
        if (this.pos == this.bufSize) {
            this.pos = 0;
        }
        System.arraycopy(this.buf, this.start, var1_1, (int)var2_2, copySize);
        this.start = this.pos;
        return (int)var3_3;
    }
}

