/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.internal.binarypatchapplier.xz;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.neoforged.internal.binarypatchapplier.xz.ArrayCache;
import net.neoforged.internal.binarypatchapplier.xz.CorruptedInputException;
import net.neoforged.internal.binarypatchapplier.xz.UnsupportedOptionsException;
import net.neoforged.internal.binarypatchapplier.xz.XZIOException;
import net.neoforged.internal.binarypatchapplier.xz.lz.LZDecoder;
import net.neoforged.internal.binarypatchapplier.xz.lzma.LZMADecoder;
import net.neoforged.internal.binarypatchapplier.xz.rangecoder.RangeDecoder;
import net.neoforged.internal.binarypatchapplier.xz.rangecoder.RangeDecoderFromStream;

public class LZMAInputStream
extends InputStream {
    private BufferedInputStream in$6e004ba7;
    private ArrayCache arrayCache;
    private LZDecoder lz;
    private RangeDecoderFromStream rc;
    private LZMADecoder lzma;
    private boolean endReached = false;
    private boolean relaxedEndCondition = false;
    private final byte[] tempBuf = new byte[1];
    private long remainingSize;
    private IOException exception = null;

    private static int getDictSize(int dictSize) {
        int n;
        if (dictSize < 0 || dictSize > 0x7FFFFFF0) {
            throw new IllegalArgumentException("LZMA dictionary is too big for this implementation");
        }
        if (dictSize < 4096) {
            dictSize = 4096;
        }
        return n + 15 & 0xFFFFFFF0;
    }

    /*
     * WARNING - void declaration
     */
    public LZMAInputStream(BufferedInputStream in) throws IOException {
        this((BufferedInputStream)var1_1, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private LZMAInputStream(BufferedInputStream in, byte by) throws IOException {
        this((BufferedInputStream)var1_1, ArrayCache.getDefaultCache());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private LZMAInputStream(BufferedInputStream in, ArrayCache arrayCache) throws IOException {
        int n;
        int n2;
        void var1_1;
        void var2_4;
        int n3;
        int n4;
        DataInputStream inData = new DataInputStream(in);
        byte propsByte = inData.readByte();
        int dictSize = 0;
        for (int i = 0; i < 4; ++i) {
            dictSize |= inData.readUnsignedByte() << (i << 3);
        }
        long uncompSize = 0L;
        for (int i = 0; i < 8; ++i) {
            uncompSize |= (long)inData.readUnsignedByte() << (i << 3);
        }
        int n5 = dictSize;
        if (n5 < 0 || n5 > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        int n6 = propsByte & 0xFF;
        if (n6 > 224) {
            throw new CorruptedInputException("Invalid LZMA properties byte");
        }
        if ((n4 = (n6 %= 45) - (n3 = n6 / 9) * 9) < 0 || n4 > 8 || n3 < 0 || n3 > 4) {
            throw new IllegalArgumentException("Invalid lc or lp");
        }
        LZMAInputStream.getDictSize(n5);
        this.relaxedEndCondition = true;
        void var7_14 = var2_4;
        long l = uncompSize;
        void var9_16 = var1_1;
        LZMAInputStream lZMAInputStream = this;
        if (l < -1L) {
            throw new UnsupportedOptionsException("Uncompressed size is too big");
        }
        int n7 = n2 & 0xFF;
        if (n7 > 224) {
            throw new CorruptedInputException("Invalid LZMA properties byte");
        }
        n4 = n7 / 45;
        int n8 = (n7 -= n4 * 9 * 5) / 9;
        n7 -= n8 * 9;
        if (n < 0 || n > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        void var8_22 = var7_14;
        n2 = n4;
        int n9 = n8;
        n8 = n7;
        long l2 = l;
        void var3_21 = var9_16;
        LZMAInputStream lZMAInputStream2 = lZMAInputStream;
        if (l2 < -1L || n8 < 0 || n8 > 8 || n9 < 0 || n9 > 4 || n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException();
        }
        lZMAInputStream2.in$6e004ba7 = var3_21;
        lZMAInputStream2.arrayCache = var8_22;
        n = LZMAInputStream.getDictSize(n);
        if (l2 >= 0L && (long)n > l2) {
            n = LZMAInputStream.getDictSize((int)l2);
        }
        lZMAInputStream2.lz = new LZDecoder(LZMAInputStream.getDictSize(n), (ArrayCache)var8_22);
        lZMAInputStream2.rc = new RangeDecoderFromStream((BufferedInputStream)var3_21);
        lZMAInputStream2.lzma = new LZMADecoder(lZMAInputStream2.lz, lZMAInputStream2.rc, n8, n9, n2);
        lZMAInputStream2.remainingSize = l2;
    }

    @Override
    public int read() throws IOException {
        LZMAInputStream lZMAInputStream = this;
        if (((InputStream)lZMAInputStream).read(lZMAInputStream.tempBuf, 0, 1) == -1) {
            return -1;
        }
        return this.tempBuf[0] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.in$6e004ba7 == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached) {
            return -1;
        }
        try {
            int size = 0;
            while (len > 0) {
                int copySizeMax = len;
                if (this.remainingSize >= 0L && this.remainingSize < (long)len) {
                    copySizeMax = (int)this.remainingSize;
                }
                this.lz.setLimit(copySizeMax);
                try {
                    this.lzma.decode();
                }
                catch (CorruptedInputException e) {
                    if (this.remainingSize != -1L || !this.lzma.endMarkerDetected()) {
                        throw e;
                    }
                    this.endReached = true;
                    ((RangeDecoder)this.rc).normalize();
                }
                int copiedSize = this.lz.flush(buf, off);
                off += copiedSize;
                len -= copiedSize;
                size += copiedSize;
                if (this.remainingSize >= 0L) {
                    this.remainingSize -= (long)copiedSize;
                    assert (this.remainingSize >= 0L);
                    if (this.remainingSize == 0L) {
                        this.endReached = true;
                    }
                }
                if (!this.endReached) continue;
                if (this.lz.hasPending()) {
                    throw new CorruptedInputException();
                }
                if (!this.rc.isFinished()) {
                    boolean bl;
                    if (this.remainingSize == -1L || !this.relaxedEndCondition) {
                        throw new CorruptedInputException();
                    }
                    this.lz.setLimit(1);
                    boolean endMarkerDetected = false;
                    try {
                        this.lzma.decode();
                    }
                    catch (CorruptedInputException e) {
                        if (!this.lzma.endMarkerDetected()) {
                            void var1_3;
                            throw var1_3;
                        }
                        bl = true;
                        ((RangeDecoder)this.rc).normalize();
                    }
                    if (!bl || !this.rc.isFinished()) {
                        throw new CorruptedInputException();
                    }
                    assert (!this.lz.hasPending());
                    assert (this.lz.hasSpace());
                }
                this.putArraysToCache();
                if (size == 0) {
                    return -1;
                }
                return size;
            }
            return size;
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    private void putArraysToCache() {
        if (this.lz != null) {
            this.lz.putArraysToCache(this.arrayCache);
            this.lz = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in$6e004ba7 != null) {
            this.putArraysToCache();
            try {
                ((InputStream)this.in$6e004ba7).close();
                return;
            }
            finally {
                this.in$6e004ba7 = null;
            }
        }
    }
}

