/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.internal.binarypatchapplier.xdelta;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.neoforged.internal.binarypatchapplier.xdelta.ByteBufferSeekableSource;
import net.neoforged.internal.binarypatchapplier.xdelta.PatchException;

public final class GDiffPatcher {
    private ByteBuffer buf = ByteBuffer.allocate(1024);
    private byte[] buf2 = this.buf.array();

    /*
     * WARNING - void declaration
     */
    public final void patch$44c03a90$24a95178(ByteBufferSeekableSource source, ByteArrayInputStream patch, ByteArrayOutputStream out) throws IOException {
        void var3_3;
        int command;
        DataOutputStream outOS = new DataOutputStream(out);
        DataInputStream patchIS = new DataInputStream(patch);
        if (patchIS.readUnsignedByte() != 209 || patchIS.readUnsignedByte() != 255 || patchIS.readUnsignedByte() != 209 || patchIS.readUnsignedByte() != 255 || patchIS.readUnsignedByte() != 4) {
            throw new PatchException("magic string not found, aborting!");
        }
        block11: while ((command = patchIS.readUnsignedByte()) != 0) {
            void var4_4;
            if (command <= 246) {
                this.append$2f3fcea9(command, patchIS, outOS);
                continue;
            }
            switch (command) {
                case 247: {
                    int length = patchIS.readUnsignedShort();
                    this.append$2f3fcea9(length, patchIS, outOS);
                    continue block11;
                }
                case 248: {
                    int length = patchIS.readInt();
                    this.append$2f3fcea9(length, patchIS, outOS);
                    continue block11;
                }
                case 249: {
                    int offset = patchIS.readUnsignedShort();
                    int length = patchIS.readUnsignedByte();
                    this.copy$33356988$4ef86002(offset, length, source, outOS);
                    continue block11;
                }
                case 250: {
                    int offset = patchIS.readUnsignedShort();
                    int length = patchIS.readUnsignedShort();
                    this.copy$33356988$4ef86002(offset, length, source, outOS);
                    continue block11;
                }
                case 251: {
                    int offset = patchIS.readUnsignedShort();
                    int length = patchIS.readInt();
                    this.copy$33356988$4ef86002(offset, length, source, outOS);
                    continue block11;
                }
                case 252: {
                    int offset = patchIS.readInt();
                    int length = patchIS.readUnsignedByte();
                    this.copy$33356988$4ef86002(offset, length, source, outOS);
                    continue block11;
                }
                case 253: {
                    int offset = patchIS.readInt();
                    int length = patchIS.readUnsignedShort();
                    this.copy$33356988$4ef86002(offset, length, source, outOS);
                    continue block11;
                }
                case 254: {
                    int offset = patchIS.readInt();
                    int length = patchIS.readInt();
                    this.copy$33356988$4ef86002(offset, length, source, outOS);
                    continue block11;
                }
                case 255: {
                    long loffset = patchIS.readLong();
                    int length = patchIS.readInt();
                    this.copy$33356988$4ef86002(loffset, length, source, outOS);
                    continue block11;
                }
            }
            throw new IllegalStateException("command ".concat(String.valueOf((int)var4_4)));
        }
        var3_3.flush();
    }

    private void copy$33356988$4ef86002(long offset, int length, ByteBufferSeekableSource source, DataOutputStream output) throws IOException {
        source.seek(offset);
        while (length > 0) {
            int len = Math.min(this.buf.capacity(), length);
            ((Buffer)this.buf).clear().limit(len);
            int res = source.read(this.buf);
            if (res == -1) {
                throw new EOFException("in copy " + offset + " " + length);
            }
            ((OutputStream)output).write(this.buf.array(), 0, res);
            length -= res;
        }
    }

    private void append$2f3fcea9(int length, DataInputStream patch, DataOutputStream output) throws IOException {
        while (length > 0) {
            int len = Math.min(this.buf2.length, length);
            int res = ((InputStream)patch).read(this.buf2, 0, len);
            if (res == -1) {
                throw new EOFException("cannot read ".concat(String.valueOf(length)));
            }
            ((OutputStream)output).write(this.buf2, 0, res);
            length -= res;
        }
    }
}

