/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.internal.binarypatchapplier;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.neoforged.internal.binarypatchapplier.PatchBase;
import net.neoforged.internal.binarypatchapplier.PatchBundleReader;
import net.neoforged.internal.binarypatchapplier.xdelta.ByteBufferSeekableSource;
import net.neoforged.internal.binarypatchapplier.xdelta.GDiffPatcher;

public class Patcher {
    private static byte[] DELETION_MARKER = new byte[0];

    private Patcher() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void patch(File baseFile, PatchBase baseType, List<File> patchBundleFiles, File outputFile, Consumer<String> debugOutput) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        try {
            baseZip = new ZipFile(baseFile);
            var6_16 = null;
            try {
                patchedContent = new HashMap<String, Object>();
                patchBundleFiles = patchBundleFiles.iterator();
                while (patchBundleFiles.hasNext()) {
                    patchBundleFile = (File)patchBundleFiles.next();
                    var14_25 = debugOutput;
                    var13_24 = baseZip;
                    var12_23 = patchedContent;
                    var11_22 = patchBundleFile;
                    var10_21 = baseType;
                    var9_20 = baseFile;
                    var15_26 = new PatchBundleReader((File)var11_22);
                    var16_28 = null;
                    try {
                        if (!var15_26.getSupportedBaseTypes().contains(var10_21)) {
                            throw new IllegalArgumentException("Cannot apply patch bundle " + var11_22 + " to " + var9_20 + " because it only applies to the base types " + var15_26.getSupportedBaseTypes());
                        }
                        for (Object var11_22 : var15_26) {
                            if (!var11_22.getBaseTypes().contains(var10_21)) continue;
                            switch (1.$SwitchMap$net$neoforged$binarypatcher$PatchOperation[var11_22.getOperation().ordinal()]) {
                                case 1: {
                                    var14_25.accept((String)("Adding " + var11_22.getTargetPath()));
                                    var12_23.put(var11_22.getTargetPath(), var11_22.getData());
                                    break;
                                }
                                case 2: {
                                    var14_25.accept((String)("Patching " + var11_22.getTargetPath()));
                                    v0 = var11_22;
                                    var17_30 = var12_23;
                                    var11_22 = var13_24;
                                    var8_19 = v0;
                                    var18_31 /* !! */  = (byte[])var17_30.get(var8_19.getTargetPath());
                                    if (var18_31 /* !! */  == null) {
                                        var21_35 = var11_22.getEntry(var8_19.getTargetPath());
                                        if (var21_35 == null) {
                                            throw new IllegalStateException("Patch targets " + var8_19.getTargetPath() + ", but it does not exist in the base.");
                                        }
                                        var18_31 /* !! */  = PatchBundleReader.1.toByteArray((ZipFile)var11_22, var21_35);
                                    } else if (var18_31 /* !! */  == Patcher.DELETION_MARKER) {
                                        throw new IllegalStateException("Patch targets " + var8_19.getTargetPath() + ", but it was deleted by an earlier patch bundle.");
                                    }
                                    var11_22 = var18_31 /* !! */ ;
                                    var19_32 = new Adler32();
                                    var19_32.update((byte[])var11_22);
                                    var21_34 = var19_32.getValue();
                                    if (var21_34 != var8_19.getBaseChecksumUnsigned()) {
                                        throw new IOException("Patch expected " + var8_19.getTargetPath() + " to have the checksum " + Long.toHexString(var8_19.getBaseChecksumUnsigned()) + " but it was " + Long.toHexString(var21_34));
                                    }
                                    v1 = var18_31 /* !! */ ;
                                    var18_31 /* !! */  = var8_19.getData();
                                    var19_32 = v1;
                                    var11_22 = new GDiffPatcher();
                                    var20_33 = new ByteArrayOutputStream();
                                    v2 = var11_22;
                                    v3 = var19_32;
                                    var11_22 = var20_33;
                                    var19_32 = new ByteArrayInputStream(var18_31 /* !! */ );
                                    var18_31 /* !! */  = (byte[])v3;
                                    v2.patch$44c03a90$24a95178(new ByteBufferSeekableSource(var18_31 /* !! */ ), (ByteArrayInputStream)var19_32, (ByteArrayOutputStream)var11_22);
                                    var11_22 = var20_33.toByteArray();
                                    var17_30.put(var8_19.getTargetPath(), var11_22);
                                    break;
                                }
                                case 3: {
                                    var14_25.accept((String)("Deleting " + var11_22.getTargetPath()));
                                    var12_23.put(var11_22.getTargetPath(), Patcher.DELETION_MARKER);
                                }
                            }
                        }
                    }
                    catch (Throwable v4) {
                        try {
                            var9_20 = v4;
                            var16_28 = v4;
                            throw var9_20;
                        }
                        catch (Throwable baseType) {
                            if (var16_28 != null) {
                                try {
                                    var15_26.close();
                                }
                                catch (Throwable outputFile) {
                                    var16_28.addSuppressed(outputFile);
                                }
                            } else {
                                var15_26.close();
                            }
                            throw baseType;
                        }
                    }
                    var15_26.close();
                }
                zOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                var8_19 = null;
                try {
                    entries = baseZip.entries();
                    while (entries.hasMoreElements()) {
                        entry = (ZipEntry)entries.nextElement();
                        if (entry.isDirectory() || (patched = (byte[])patchedContent.remove(entry.getName())) == Patcher.DELETION_MARKER) continue;
                        var9_20 = entry;
                        var10_21 = new ZipEntry(var9_20.getName());
                        var10_21.setTime(var9_20.getTime());
                        if (var9_20.getLastModifiedTime() != null) {
                            var10_21.setLastModifiedTime(var9_20.getLastModifiedTime());
                        }
                        if (var9_20.getLastAccessTime() != null) {
                            var10_21.setLastAccessTime(var9_20.getLastAccessTime());
                        }
                        if (var9_20.getCreationTime() != null) {
                            var10_21.setCreationTime(var9_20.getCreationTime());
                        }
                        newEntry = var10_21;
                        zOut.putNextEntry((ZipEntry)newEntry);
                        if (patched != null) {
                            zOut.write(patched);
                        } else {
                            var11_22 = zOut;
                            var12_23 = baseZip.getInputStream((ZipEntry)var1_3);
                            var13_24 = null;
                            try {
                                var9_20 = var12_23;
                                var1_3 = new byte[8192];
                                while ((patched = var9_20.read((byte[])var1_3)) != -1) {
                                    var11_22.write((byte[])var1_3, 0, patched);
                                }
                                ** if (var12_23 == null) goto lbl-1000
                            }
                            catch (Throwable v5) {
                                try {
                                    var14_25 = v5;
                                    var13_24 = v5;
                                    throw var14_25;
                                }
                                catch (Throwable var15_27) {
                                    if (var12_23 != null) {
                                        if (var13_24 != null) {
                                            try {
                                                var12_23.close();
                                            }
                                            catch (Throwable var16_29) {
                                                var13_24.addSuppressed(var16_29);
                                            }
                                        } else {
                                            var12_23.close();
                                        }
                                    }
                                    throw var15_27;
                                }
                            }
lbl-1000:
                            // 1 sources

                            {
                                var12_23.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        zOut.closeEntry();
                    }
                    for (Map.Entry<K, V> entry : patchedContent.entrySet()) {
                        if (entry.getValue() == Patcher.DELETION_MARKER) {
                            throw new IllegalStateException("Somehow " + (String)entry.getKey() + " was deleted although it does not exist.");
                        }
                        var9_20 = (String)entry.getKey();
                        var10_21 = new ZipEntry((String)var9_20);
                        var10_21.setTime(628041600000L);
                        zOut.putNextEntry((ZipEntry)var10_21);
                        zOut.write((byte[])var3_12.getValue());
                        zOut.closeEntry();
                    }
                }
                catch (Throwable v6) {
                    try {
                        var0 = v6;
                        var8_19 = v6;
                        throw var0;
                    }
                    catch (Throwable var0_1) {
                        if (var8_19 != null) {
                            try {
                                zOut.close();
                            }
                            catch (Throwable var1_5) {
                                var8_19.addSuppressed(var1_5);
                            }
                        } else {
                            var2_7.close();
                        }
                        throw var0_1;
                    }
                }
                zOut.close();
            }
            catch (Throwable v7) {
                try {
                    var7_18 = v7;
                    var6_16 = v7;
                    throw var7_18;
                }
                catch (Throwable var0_2) {
                    if (var6_16 != null) {
                        try {
                            baseZip.close();
                        }
                        catch (Throwable var1_6) {
                            var6_16.addSuppressed(var1_6);
                        }
                    } else {
                        baseZip.close();
                    }
                    throw var0_2;
                }
            }
            baseZip.close();
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

