/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.internal.binarypatchapplier;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.neoforged.internal.binarypatchapplier.Patch;
import net.neoforged.internal.binarypatchapplier.PatchBase;
import net.neoforged.internal.binarypatchapplier.PatchBundleConstants;
import net.neoforged.internal.binarypatchapplier.PatchOperation;
import net.neoforged.internal.binarypatchapplier.xz.LZMAInputStream;

public final class PatchBundleReader
implements AutoCloseable,
Iterable<Patch> {
    private final DataInputStream input;
    private final EnumSet<PatchBase> supportedBaseTypes;
    private final int entryCount;
    private int entriesRead;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    public PatchBundleReader(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream((File)var1_1)));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private PatchBundleReader(BufferedInputStream input) throws IOException {
        void var1_2;
        this.input = new DataInputStream(new LZMAInputStream(input));
        byte[] signature = new byte[PatchBundleConstants.BUNDLE_SIGNATURE.length];
        this.input.readFully(signature);
        if (!Arrays.equals(signature, PatchBundleConstants.BUNDLE_SIGNATURE)) {
            throw new IOException("Invalid bundle signature");
        }
        this.entryCount = this.input.readInt();
        if (this.entryCount < 0) {
            throw new IOException("Invalid entry count: " + this.entryCount);
        }
        int distBitfield = this.input.readUnsignedByte();
        this.supportedBaseTypes = PatchBase.fromBitfield((int)var1_2);
        this.entriesRead = 0;
        this.closed = false;
    }

    public final EnumSet<PatchBase> getSupportedBaseTypes() {
        return EnumSet.copyOf(this.supportedBaseTypes);
    }

    public final boolean hasMoreEntries() {
        return this.entriesRead < this.entryCount;
    }

    @Override
    public final Iterator<Patch> iterator() {
        if (this.entriesRead > 0) {
            throw new IllegalStateException("Cannot create multiple iterators or iterate after manual read");
        }
        return new EntryIterator(this, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final Patch readEntry() throws IOException {
        void var1_2;
        void var2_4;
        int dataLength;
        PatchOperation type;
        if (this.closed) {
            throw new IllegalStateException("Reader is closed");
        }
        if (!this.hasMoreEntries()) {
            return null;
        }
        int flags = this.input.readUnsignedByte();
        int entryTypeBits = flags & 0x18;
        int distBitfield = flags & 7;
        switch (entryTypeBits) {
            case 0: {
                type = PatchOperation.CREATE;
                break;
            }
            case 8: {
                type = PatchOperation.MODIFY;
                break;
            }
            case 16: {
                type = PatchOperation.REMOVE;
                break;
            }
            default: {
                void type2;
                throw new IOException("Unknown entry type: ".concat(String.valueOf((int)type2)));
            }
        }
        EnumSet<PatchBase> entryDists = PatchBase.fromBitfield(distBitfield);
        for (PatchBase dist : entryDists) {
            if (this.supportedBaseTypes.contains((Object)dist)) continue;
            throw new IOException("Entry targets distribution " + (Object)((Object)dist) + " not declared in bundle");
        }
        Object object = this;
        int dist = ((PatchBundleReader)object).input.readUnsignedShort();
        byte[] byArray = new byte[dist];
        ((PatchBundleReader)object).input.readFully(byArray);
        object = byArray;
        for (int i = 0; i < dist; ++i) {
            Object object2 = object[i];
            if (object2 >= 32 && object2 <= 126) continue;
            throw new IOException("String contains invalid character: 0x" + Integer.toHexString(object2 & 0xFF));
        }
        String targetPath = new String(byArray, StandardCharsets.US_ASCII);
        Long baseChecksum = null;
        if (type == PatchOperation.MODIFY) {
            baseChecksum = this.input.readInt();
        }
        if ((dataLength = this.input.readInt()) < 0) {
            throw new IOException("Invalid data length: ".concat(String.valueOf(dataLength)));
        }
        if (type == PatchOperation.REMOVE && dataLength != 0) {
            throw new IOException("REMOVE entry must have data length of 0");
        }
        byte[] data = new byte[dataLength];
        if (dataLength > 0) {
            this.input.readFully(data);
        }
        ++this.entriesRead;
        return new Patch((PatchOperation)var2_4, (String)object, (EnumSet<PatchBase>)var1_2, baseChecksum, data);
    }

    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            ((InputStream)this.input).close();
            this.closed = true;
        }
    }

    final class EntryIterator
    implements Iterator<Patch> {
        private /* synthetic */ PatchBundleReader this$0;

        private EntryIterator(PatchBundleReader patchBundleReader) {
            this.this$0 = patchBundleReader;
        }

        @Override
        public final boolean hasNext() {
            return this.this$0.hasMoreEntries();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private Patch next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more entries");
            }
            try {
                return this.this$0.readEntry();
            }
            catch (IOException e) {
                void var1_1;
                throw new UncheckedIOException("Error reading entry", (IOException)var1_1);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntryIterator(PatchBundleReader x0, byte by) {
            this((PatchBundleReader)var1_1);
            void var1_1;
        }
    }
}

