/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gdi.runtime;

import java.util.Map;
import java.util.function.BiConsumer;
import org.gradle.api.provider.MapProperty;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MapUtils {
    public static <K, V> void put(Class<K> keyType, Class<V> valueType, Map<K, V> map, Object values) {
        MapUtils.put(keyType, valueType, map::put, values);
    }

    public static <K, V> void put(Class<K> keyType, Class<V> valueType, MapProperty<K, V> map, Object values) {
        MapUtils.put(keyType, valueType, (arg_0, arg_1) -> map.put(arg_0, arg_1), values);
    }

    public static <K, V> void put(Class<K> keyType, Class<V> valueType, BiConsumer<K, V> putter, Object values) {
        if (!values.getClass().isArray()) {
            throw new IllegalArgumentException("Expecting array, but got: " + values.getClass());
        }
        Object[] array = (Object[])values;
        if (array.length % 2 != 0) {
            throw new IllegalArgumentException("Expected even number of arguments, but got odd number of arguments. Vararg map.put operations must be provided an array of keys, each followed by their value!");
        }
        for (int i = 0; i < array.length; i += 2) {
            Object key = array[i];
            if (!keyType.isInstance(key)) {
                throw new ClassCastException("Key at position " + i + " is not a " + keyType);
            }
            Object value = array[i + 1];
            if (!valueType.isInstance(value)) {
                throw new ClassCastException("Value at position " + (i + 1) + " is not a " + value);
            }
            putter.accept(key, value);
        }
    }
}

