/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradleutils.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import net.neoforged.gradleutils.GradleUtilsExtension;
import net.neoforged.gradleutils.InternalAccessor;
import net.neoforged.gradleutils.specs.VersionSpec;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;

@UntrackedTask(because="This Git state is not an Input")
public abstract class GenerateChangelogTask
extends DefaultTask {
    public GenerateChangelogTask() {
        GradleUtilsExtension extension = (GradleUtilsExtension)this.getProject().getExtensions().getByType(GradleUtilsExtension.class);
        this.getVersionSpec().convention((Object)extension.getVersionSpec());
        this.getOutputFile().convention(this.getProject().getLayout().getBuildDirectory().file("changelog.txt"));
    }

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    public abstract Property<String> getStartingRevision();

    @Nested
    public abstract Property<VersionSpec> getVersionSpec();

    @TaskAction
    public void generate() {
        String startingRev = (String)this.getStartingRevision().get();
        String changelog = InternalAccessor.generateChangelog(this.getProviders(), (VersionSpec)this.getVersionSpec().get(), this.getLayout().getProjectDirectory(), startingRev);
        File outputFile = (File)this.getOutputFile().getAsFile().get();
        if (outputFile.getParentFile() != null) {
            outputFile.getParentFile().mkdirs();
        }
        if (outputFile.exists()) {
            outputFile.delete();
        }
        try {
            Files.write(outputFile.toPath(), changelog.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write changelog to file: " + outputFile.getAbsolutePath());
        }
    }
}

