/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradleutils.tasks;

import groovy.text.GStringTemplateEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.neoforged.gradleutils.tasks.CIConfigExtractionTask;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.options.Option;

public abstract class ExtractActionsWorkflowsTask
extends CIConfigExtractionTask {
    private boolean withPRPublishing;
    private boolean withJCC;

    public ExtractActionsWorkflowsTask() {
        super(".github-workflows.zip", ".github/workflows");
        this.setDescription("Creates (or recreates) default GitHub Action workflows");
    }

    @Override
    protected void extractZip(String fileZip, File destDir) throws Exception {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("project", this.getProject());
        binding.put("jdkVersion", this.determineJDKVersion());
        binding.put("commonGroup", ExtractActionsWorkflowsTask.findCommonPrefix(this.getProject().getAllprojects().stream().filter(project -> !project.getGroup().toString().isEmpty()).filter(project -> project.getExtensions().findByType(BasePluginExtension.class) != null).map(project -> project.getGroup() + "/" + (String)((BasePluginExtension)project.getExtensions().getByType(BasePluginExtension.class)).getArchivesName().get() + "/").map(group -> group.replace('.', '/')).collect(Collectors.toList())));
        binding.put("withPRPublishing", this.withPRPublishing);
        binding.put("withJCC", this.withJCC);
        String gitCommit = ExtractActionsWorkflowsTask.class.getPackage().getImplementationVersion();
        GStringTemplateEngine engine = new GStringTemplateEngine();
        ZipInputStream zis = new ZipInputStream(new FileInputStream(fileZip));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = ExtractActionsWorkflowsTask.newFile(destDir, zipEntry);
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + newFile);
                }
            } else {
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent);
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                if (gitCommit != null) {
                    fos.write(String.format("# File generated by the GradleUtils `%s` task, avoid modifying it directly\n# The template can be found at https://github.com/neoforged/GradleUtils/blob/%s/src/actionsTemplate/resources/%s\n\n", this.getName(), gitCommit, zipEntry.getName()).getBytes(StandardCharsets.UTF_8));
                }
                fos.write(engine.createTemplate((Reader)new InputStreamReader(zis)).make(binding).toString().getBytes(StandardCharsets.UTF_8));
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    @Input
    public boolean getWithPRPublishing() {
        return this.withPRPublishing;
    }

    @Input
    public boolean getWithJCC() {
        return this.withJCC;
    }

    @Option(option="pr-publishing", description="If the workflow for publishing PRs should be enabled")
    public void setWithPRPublishing(boolean withPRPublishing) {
        this.withPRPublishing = withPRPublishing;
    }

    @Option(option="jcc", description="If the workflow for JarCompatibilityChecker should be enabled")
    public void setWithJCC(boolean withJCC) {
        this.withJCC = withJCC;
    }
}

