/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradleutils.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public abstract class CIConfigExtractionTask
extends DefaultTask {
    private final String templateZipName;
    private final String targetDirName;
    private boolean deleteExisting;

    protected CIConfigExtractionTask(String templateZipName, String targetDirName) {
        this.templateZipName = templateZipName;
        this.targetDirName = targetDirName;
        this.getDestination().convention(this.getProject().getRootProject().getLayout().getProjectDirectory().dir(this.getProject().provider(() -> "./")));
        this.setGroup("publishing");
    }

    @TaskAction
    public void run() throws Exception {
        File destDir = (File)this.getDestination().getAsFile().get();
        File targetDir = new File(destDir, this.targetDirName);
        String fileZip = this.exportResource();
        if (targetDir.exists() && this.deleteExisting) {
            boolean couldDelete = true;
            for (File file : targetDir.listFiles()) {
                couldDelete &= file.delete();
            }
            if (!couldDelete || !targetDir.delete()) {
                throw new IllegalStateException("Could not delete the existing " + this.targetDirName + " project directory!");
            }
        }
        this.extractZip(fileZip, destDir);
    }

    protected abstract void extractZip(String var1, File var2) throws Exception;

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getDestination();

    protected static File newFile(File destinationDir, ZipEntry zipEntry) throws Exception {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    protected String determineJDKVersion() {
        if (this.getProject().getExtensions().findByType(JavaPluginExtension.class) == null) {
            this.getProject().getLogger().warn("Could not find the Java extension, falling back to JDK 8.");
            return "8";
        }
        return ((JavaLanguageVersion)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion().orElse(this.getProject().provider(() -> JavaLanguageVersion.of((int)8))).get()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exportResource() throws Exception {
        String jarFolder;
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            int readBytes;
            stream = CIConfigExtractionTask.class.getResourceAsStream("/" + this.templateZipName);
            if (stream == null) {
                throw new Exception("Cannot get resource \"" + this.templateZipName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            jarFolder = new File(CIConfigExtractionTask.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getPath().replace('\\', '/');
            resStreamOut = new FileOutputStream(jarFolder + this.templateZipName);
            while ((readBytes = stream.read(buffer)) > 0) {
                resStreamOut.write(buffer, 0, readBytes);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (resStreamOut != null) {
                resStreamOut.close();
            }
        }
        return jarFolder + this.templateZipName;
    }

    @Input
    public boolean getDeleteExisting() {
        return this.deleteExisting;
    }

    @Option(option="delete-existing", description="Delete existing workflows")
    public void setDeleteExisting(boolean deleteExisting) {
        this.deleteExisting = deleteExisting;
    }

    protected static String findCommonPrefix(List<String> groups) {
        if (groups.isEmpty()) {
            return "";
        }
        ArrayDeque firstGroup = new ArrayDeque();
        groups.stream().min(Comparator.comparing(String::length)).get().chars().forEach(ch -> firstGroup.add(Character.valueOf((char)ch)));
        String common = "";
        while (!firstGroup.isEmpty()) {
            String current = common + firstGroup.pop();
            if (!groups.stream().allMatch(group -> group.startsWith(current))) break;
            common = current;
        }
        return common;
    }
}

