/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradleutils;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.KnownImmutable;
import groovy.transform.ToString;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.neoforged.gradleutils.GradleUtils;
import net.neoforged.gradleutils.specs.VersionSpec;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.eclipse.jgit.api.DescribeCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.gradle.api.GradleException;

class VersionCalculator
implements GroovyObject {
    static final char GENERAL_SEPARATOR = '-';
    static final char VERSION_SEPARATOR = '.';
    private final VersionSpec spec;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public VersionCalculator(VersionSpec spec) {
        VersionSpec versionSpec;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.spec = versionSpec = spec;
    }

    public String calculate(Git git, String rev, boolean skipVersionPrefix, boolean skipBranchSuffix) {
        DescribeOutput describe = this.findTag(git, rev);
        String tag = describe.getTag();
        Object object = this.spec.getTags().getStripTagLabel().get();
        if (object == null ? false : (Boolean)object) {
            int sepIdx = describe.getTag().lastIndexOf(GENERAL_SEPARATOR);
            if (sepIdx != -1) {
                tag = describe.getTag().substring(0, sepIdx);
            }
        }
        StringBuilder version = new StringBuilder();
        String prefix = ShortTypeHandling.castToString((Object)this.spec.getVersionPrefix().getOrNull());
        if (!skipVersionPrefix && prefix != null) {
            version.append(prefix).append(GENERAL_SEPARATOR);
        }
        version.append(tag);
        Object object2 = this.spec.getTags().getAppendCommitOffset().get();
        if (object2 == null ? false : (Boolean)object2) {
            version.append(VERSION_SEPARATOR).append(describe.getOffset());
        }
        if (describe.getLabel() != null) {
            version.append(GENERAL_SEPARATOR).append(describe.getLabel());
        }
        if (!skipBranchSuffix && DefaultTypeTransformation.booleanUnbox((Object)this.spec.getBranches().getSuffixBranch().get())) {
            String branchSuffix = this.getBranchSuffix(git);
            if (branchSuffix != null) {
                version.append(GENERAL_SEPARATOR).append(branchSuffix);
            }
        }
        return version.toString();
    }

    private DescribeOutput findTag(Git git, String startingRev) {
        TagContextImpl context = new TagContextImpl();
        Object object = this.spec.getTags().getLabel().getOrNull();
        context.setLabel(ShortTypeHandling.castToString((Object)object));
        int trackedCommitCount = 0;
        String currentRev = startingRev;
        while (true) {
            Object object2;
            String described = this.describe(git).setTarget(currentRev).call();
            if (ScriptBytecodeAdapter.compareIdentical((Object)described, null)) {
                throw (Throwable)new GradleException("Cannot calculate the project version without a previous Git tag. Did you forget to run \"git fetch --tags\"?");
            }
            List<String> describeSplit = GradleUtils.rsplit(described, "-", 2);
            DefaultGroovyMethods.getAt(describeSplit, (int)0);
            context.setTag(ShortTypeHandling.castToString((Object)object2));
            trackedCommitCount = trackedCommitCount + Integer.parseUnsignedInt(ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(describeSplit, (int)1)));
            Object object3 = this.spec.getTags().getExtractLabel().get();
            if (object3 == null ? false : (Boolean)object3) {
                int separatorIndex = context.getTag().lastIndexOf(GENERAL_SEPARATOR);
                if (separatorIndex != -1) {
                    String string;
                    context.getTag().substring(separatorIndex + 1);
                    context.setLabel(string);
                }
            }
            String markerLabel = ShortTypeHandling.castToString((Object)this.spec.getTags().getCleanMarkerLabel().getOrNull());
            if (markerLabel == null || !context.endsWithLabel(markerLabel)) break;
            Object var13_13 = null;
            context.setLabel(ShortTypeHandling.castToString(var13_13));
            StringGroovyMethods.plus((String)context.getTag(), (CharSequence)"~1");
            trackedCommitCount = trackedCommitCount + 1;
        }
        if (context.getTag().isEmpty()) {
            throw (Throwable)new RuntimeException("Somehow got left with no tag?");
        }
        return new DescribeOutput(context.getTag(), trackedCommitCount, context.getLabel());
    }

    @Nullable
    private String getBranchSuffix(Git git) {
        String string;
        Object object;
        Ref ref;
        Ref ref2;
        Ref head = git.getRepository().exactRef("HEAD");
        String longBranch = ShortTypeHandling.castToString(head.isSymbolic() ? ((ref2 = (ref = head) != null ? ref.getTarget() : null) != null ? ref2.getName() : null) : null);
        Reference branch = new Reference((Object)(longBranch != null ? Repository.shortenRefName((String)longBranch) : ""));
        boolean bl = this.spec.getBranches().getSuffixExemptedBranches().get() == null ? (String)branch.get() == null : DefaultGroovyMethods.isCase((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)this.spec.getBranches().getSuffixExemptedBranches().get(), Collection.class)), (Object)((String)branch.get()));
        public final class _getBranchSuffix_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference branch;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getBranchSuffix_closure1(Object _outerInstance, Object _thisObject, Reference branch) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.branch = reference = branch;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.matchRegex((Object)ShortTypeHandling.castToString((Object)this.branch.get()), (Object)new GStringImpl(new Object[]{it}, new String[]{"", ""}));
            }

            @Generated
            public String getBranch() {
                return ShortTypeHandling.castToString((Object)this.branch.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                CallSite[] callSiteArray = _getBranchSuffix_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getBranchSuffix_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getBranchSuffix_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getBranchSuffix_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (bl || DefaultTypeTransformation.booleanUnbox((object = this.spec.getBranches().getSuffixExemptedBranchPatterns().getOrNull()) != null ? Boolean.valueOf(DefaultGroovyMethods.any((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)object, Iterable.class)), (Closure)new _getBranchSuffix_closure1(this, this, branch))) : null)) {
            return ShortTypeHandling.castToString(null);
        }
        String string2 = (String)branch.get();
        Boolean bl2 = string2 != null ? Boolean.valueOf(string2.startsWith("pulls/")) : null;
        if (bl2 == null ? false : bl2) {
            branch.set((Object)StringGroovyMethods.plus((String)"pr", (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(GradleUtils.rsplit((String)branch.get(), "/", 1), (int)1), CharSequence.class))));
        }
        branch.set((Object)((string = (String)branch.get()) != null ? string.replaceAll("[\\\\/]", "-") : null));
        return (String)branch.get();
    }

    private DescribeCommand describe(Git git) {
        String[] includeFilters = (String[])ScriptBytecodeAdapter.castToType((Object)((Set)this.spec.getTags().getIncludeFilters().get()).toArray(new String[0]), String[].class);
        return git.describe().setLong(true).setTags(DefaultTypeTransformation.booleanUnbox((Object)this.spec.getTags().getIncludeLightweightTags().get())).setMatch(includeFilters);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != VersionCalculator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(VersionCalculator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(VersionCalculator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(VersionCalculator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, VersionCalculator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(VersionCalculator.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public String calculate(Git git, String rev, boolean skipVersionPrefix) {
        CallSite[] callSiteArray = VersionCalculator.$getCallSiteArray();
        return this.calculate(git, rev, skipVersionPrefix, false);
    }

    @Generated
    public String calculate(Git git, String rev) {
        CallSite[] callSiteArray = VersionCalculator.$getCallSiteArray();
        return this.calculate(git, rev, false, false);
    }

    @Generated
    public String calculate(Git git) {
        CallSite[] callSiteArray = VersionCalculator.$getCallSiteArray();
        return this.calculate(git, ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(Constants.class)), false, false);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[1];
        stringArray[0] = "HEAD";
        return new CallSiteArray(VersionCalculator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = VersionCalculator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    @ToString(cache=true, includeSuperProperties=true)
    @EqualsAndHashCode(cache=true)
    @KnownImmutable
    public static final class DescribeOutput
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private /* synthetic */ String $to$string;
        private /* synthetic */ int $hash$code;
        private final String tag;
        private final int offset;
        private final String label;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public DescribeOutput(String tag, int offset, String label) {
            String string;
            int n;
            String string2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.tag = string2 = tag;
            this.offset = n = offset;
            this.label = string = label;
        }

        @Generated
        public DescribeOutput(Map args) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (args == null) {
                args = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }
            ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
            if (args.containsKey("tag")) {
                String string;
                this.tag = string = ShortTypeHandling.castToString(args.get("tag"));
            } else {
                Object var4_4 = null;
                this.tag = ShortTypeHandling.castToString(var4_4);
            }
            if (args.containsKey("offset")) {
                int n;
                this.offset = n = DefaultTypeTransformation.intUnbox(args.get("offset"));
            }
            if (args.containsKey("label")) {
                String string;
                this.label = string = ShortTypeHandling.castToString(args.get("label"));
            } else {
                Object var7_7 = null;
                this.label = ShortTypeHandling.castToString(var7_7);
            }
        }

        @Generated
        public DescribeOutput() {
            this(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DescribeOutput.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("net.neoforged.gradleutils.VersionCalculator$DescribeOutput(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getTag()));
            Boolean bl2 = $toStringFirst;
            if (bl2 == null ? false : bl2) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getOffset()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getLabel()));
            _result.append(")");
            if (this.$to$string == null) {
                String string;
                this.$to$string = string = _result.toString();
            }
            return this.$to$string;
        }

        @Generated
        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getTag(), (Object)this)) {
                    _result = HashCodeHelper.updateHash((int)_result, (Object)this.getTag());
                }
                if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getOffset(), (Object)this)) {
                    _result = HashCodeHelper.updateHash((int)_result, (int)this.getOffset());
                }
                if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getLabel(), (Object)this)) {
                    _result = HashCodeHelper.updateHash((int)_result, (Object)this.getLabel());
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof DescribeOutput;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof DescribeOutput)) {
                return false;
            }
            DescribeOutput otherTyped = (DescribeOutput)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getTag(), (Object)otherTyped.getTag())) {
                return false;
            }
            if (!(this.getOffset() == otherTyped.getOffset())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getLabel(), (Object)otherTyped.getLabel()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(DescribeOutput.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(DescribeOutput.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(DescribeOutput.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(DescribeOutput.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(DescribeOutput.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(DescribeOutput.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DescribeOutput.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DescribeOutput.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final String getTag() {
            return this.tag;
        }

        @Generated
        public final int getOffset() {
            return this.offset;
        }

        @Generated
        public final String getLabel() {
            return this.label;
        }
    }

    public static class TagContextImpl
    implements GroovyObject {
        @Nullable
        private String label;
        private String tag;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public TagContextImpl() {
            MetaClass metaClass;
            String string;
            Object var1_1 = null;
            this.label = ShortTypeHandling.castToString(var1_1);
            this.tag = string = "";
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public boolean endsWithLabel(String label) {
            return this.tag.endsWith(StringGroovyMethods.plus((String)((Character)ScriptBytecodeAdapter.getField(TagContextImpl.class, VersionCalculator.class, (String)"GENERAL_SEPARATOR")).toString(), (CharSequence)label));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != TagContextImpl.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(TagContextImpl.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(TagContextImpl.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(TagContextImpl.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(TagContextImpl.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(TagContextImpl.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(TagContextImpl.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TagContextImpl.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TagContextImpl.class, VersionCalculator.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public void setLabel(String string) {
            this.label = string;
        }

        @Generated
        public String getTag() {
            return this.tag;
        }

        @Generated
        public void setTag(String string) {
            this.tag = string;
        }
    }
}

