/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradleutils;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.gradleutils.GradleUtils;
import net.neoforged.gradleutils.tasks.GenerateChangelogTask;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.GeneratedLambda;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

class ChangelogUtils
implements GroovyObject {
    private static final String CHANGELOG_GENERATION_TASK_NAME = "createChangelog";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ChangelogUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String generateChangelog(File projectDirectory, String repositoryUrl, boolean justText) {
        Git git = GradleUtils.openGit(projectDirectory);
        RevCommit headCommit = ChangelogUtils.getHead(git);
        RevCommit logFromCommit = ChangelogUtils.getMergeBaseCommit(git);
        if (ScriptBytecodeAdapter.compareIdentical((Object)logFromCommit, null)) {
            logFromCommit = ChangelogUtils.getFirstCommitInRepository(git);
        }
        return ChangelogUtils.generateChangelogFromTo(git, repositoryUrl, justText, logFromCommit, headCommit);
    }

    public static String generateChangelog(File projectDirectory, String repositoryUrl, boolean justText, String sourceTag) {
        Git git = GradleUtils.openGit(projectDirectory);
        Map<String, String> tagMap = ChangelogUtils.getTagToCommitMap(git);
        if (!tagMap.containsKey(sourceTag)) {
            throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"The tag: ", (CharSequence)sourceTag), (CharSequence)" does not exist in the repository"));
        }
        String commitHash = ShortTypeHandling.castToString((Object)tagMap.get(sourceTag));
        RevCommit commit = ChangelogUtils.getCommitFromId(git, ObjectId.fromString((String)commitHash));
        RevCommit headCommit = ChangelogUtils.getHead(git);
        return ChangelogUtils.generateChangelogFromTo(git, repositoryUrl, justText, commit, headCommit);
    }

    public static String generateChangelogFromCommit(File projectDirectory, String repositoryUrl, boolean justText, String commitHash) {
        Git git = GradleUtils.openGit(projectDirectory);
        RevCommit commit = ChangelogUtils.getCommitFromId(git, ObjectId.fromString((String)commitHash));
        RevCommit headCommit = ChangelogUtils.getHead(git);
        return ChangelogUtils.generateChangelogFromTo(git, repositoryUrl, justText, commit, headCommit);
    }

    public static String generateChangelogFromTo(Git git, String repositoryUrl, boolean justText, RevCommit start, RevCommit end) {
        String endCommitHash = end.toObjectId().getName();
        String startCommitHash = start.toObjectId().getName();
        String changeLogName = git.getRepository().getFullBranch();
        if (changeLogName != null) {
            changeLogName = changeLogName.replace("refs/heads/", "");
        }
        Iterable<RevCommit> log = ChangelogUtils.getCommitLogFromTo(git, start, end);
        List logList = DefaultGroovyMethods.toList(log);
        Map<String, String> tagMap = ChangelogUtils.getCommitToTagMap(git);
        Map<String, String> versionMap = ChangelogUtils.buildVersionMap(logList, tagMap);
        Map<String, String> primaryVersionMap = ChangelogUtils.getPrimaryVersionMap(logList, tagMap);
        Map<String, Integer> primaryVersionPrefixLengthMap = ChangelogUtils.determinePrefixLengthPerPrimaryVersion(versionMap.values(), new HashSet<String>(primaryVersionMap.values()));
        GStringImpl changelog = new GStringImpl(new Object[]{changeLogName, repositoryUrl, startCommitHash, endCommitHash}, new String[]{"### [", " Changelog](", "/compare/", "...", ")\n"});
        if (justText) {
            changelog = new GStringImpl(new Object[]{changeLogName}, new String[]{"", " Changelog\n"});
        }
        String currentPrimaryVersion = "";
        Pattern pullRequestPattern = Pattern.compile("\\(#(?<pullNumber>[0-9]+)\\)");
        List list = logList;
        Iterator iterator = list != null ? list.iterator() : null;
        RevCommit commit = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                commit = (RevCommit)ScriptBytecodeAdapter.castToType(iterator2.next(), RevCommit.class);
                String commitHash = commit.toObjectId().name();
                boolean requiresVersionHeader = false;
                if (primaryVersionMap.containsKey(commitHash)) {
                    String versionsPrimaryVersion = ShortTypeHandling.castToString((Object)primaryVersionMap.get(commitHash));
                    requiresVersionHeader = ScriptBytecodeAdapter.compareNotEqual((Object)versionsPrimaryVersion, (Object)currentPrimaryVersion);
                }
                if (requiresVersionHeader && justText) {
                    String header = currentPrimaryVersion;
                    String headerMarker = header.replaceAll(".", "=");
                    changelog = changelog.plus((GString)new GStringImpl(new Object[]{header}, new String[]{"", "\n"}));
                    changelog = changelog.plus((GString)new GStringImpl(new Object[]{headerMarker}, new String[]{"", "\n"}));
                }
                String commitHeader = " - ";
                if (versionMap.containsKey(commitHash)) {
                    String version = ShortTypeHandling.castToString((Object)versionMap.get(commitHash));
                    commitHeader = tagMap.containsKey(commitHash) && !justText ? StringGroovyMethods.plus((String)commitHeader, (CharSequence)new GStringImpl(new Object[]{StringGroovyMethods.padRight((CharSequence)version, (Number)((Number)ScriptBytecodeAdapter.castToType((Object)primaryVersionPrefixLengthMap.get(currentPrimaryVersion), Number.class))), repositoryUrl, version}, new String[]{"[", "](", "/tree/", ")"})) : StringGroovyMethods.plus((String)commitHeader, (CharSequence)new GStringImpl(new Object[]{StringGroovyMethods.padRight((CharSequence)version, (Number)((Number)ScriptBytecodeAdapter.castToType((Object)primaryVersionPrefixLengthMap.get(currentPrimaryVersion), Number.class)))}, new String[]{"", ""}));
                }
                int commitHeaderLength = commitHeader.length();
                commitHeader = StringGroovyMethods.plus((String)commitHeader, (CharSequence)" ");
                String noneCommitHeaderPrefix = StringGroovyMethods.plus((String)String.join((CharSequence)"", Collections.nCopies(commitHeaderLength, " ")), (CharSequence)" ");
                String subject = ChangelogUtils.processCommitBody(commit.getFullMessage().trim());
                if (!justText) {
                    Matcher matcher = pullRequestPattern.matcher(subject);
                    if (matcher.find()) {
                        String pullRequestNumber = matcher.group("pullNumber");
                        subject = subject.replace((CharSequence)new GStringImpl(new Object[]{pullRequestNumber}, new String[]{"#", ""}), (CharSequence)new GStringImpl(new Object[]{pullRequestNumber, repositoryUrl, pullRequestNumber}, new String[]{"[#", "](", "/pull/", ")"}));
                    }
                }
                subject = subject.replaceAll("\\n", StringGroovyMethods.plus((String)"\n", (CharSequence)noneCommitHeaderPrefix));
                changelog = changelog.plus((GString)new GStringImpl(new Object[]{commitHeader, subject}, new String[]{"", "", ""}));
                changelog = changelog.plus("\n");
                if (!(tagMap.containsKey(commitHash) && justText)) continue;
                changelog = changelog.plus("\n");
            }
        }
        return ShortTypeHandling.castToString((Object)changelog);
    }

    private static RevCommit getMergeBaseCommit(Git git) {
        Reference git2 = new Reference((Object)git);
        Reference headCommit = new Reference((Object)ChangelogUtils.getHead((Git)git2.get()));
        List<Ref> remoteBranches = ChangelogUtils.getAvailableRemoteBranches((Git)git2.get());
        public final class _getMergeBaseCommit_lambda3
        extends Closure
        implements GeneratedLambda {
            private /* synthetic */ Reference headCommit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getMergeBaseCommit_lambda3(Object _outerInstance, Object _thisObject, Reference headCommit) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.headCommit = reference = headCommit;
            }

            public boolean doCall(RevCommit revCommit) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)revCommit.toObjectId().getName(), (Object)((RevCommit)ScriptBytecodeAdapter.castToType((Object)this.headCommit.get(), RevCommit.class)).toObjectId().getName());
            }

            @Generated
            public RevCommit getHeadCommit() {
                return (RevCommit)ScriptBytecodeAdapter.castToType((Object)this.headCommit.get(), RevCommit.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMergeBaseCommit_lambda3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _getMergeBaseCommit_lambda2
        extends Closure
        implements GeneratedLambda {
            private /* synthetic */ Reference git;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getMergeBaseCommit_lambda2(Object _outerInstance, Object _thisObject, Reference git) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.git = reference = git;
            }

            public R doCall(Ref branch) {
                return ChangelogUtils.getMergeBase((Git)ScriptBytecodeAdapter.castToType((Object)this.git.get(), Git.class), branch);
            }

            @Generated
            public Git getGit() {
                return (Git)ScriptBytecodeAdapter.castToType((Object)this.git.get(), Git.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMergeBaseCommit_lambda2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _getMergeBaseCommit_lambda1
        extends Closure
        implements GeneratedLambda {
            private /* synthetic */ Reference headCommit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getMergeBaseCommit_lambda1(Object _outerInstance, Object _thisObject, Reference headCommit) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.headCommit = reference = headCommit;
            }

            public boolean doCall(Ref branch) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)branch.getObjectId().getName(), (Object)((RevCommit)ScriptBytecodeAdapter.castToType((Object)this.headCommit.get(), RevCommit.class)).toObjectId().getName());
            }

            @Generated
            public RevCommit getHeadCommit() {
                return (RevCommit)ScriptBytecodeAdapter.castToType((Object)this.headCommit.get(), RevCommit.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMergeBaseCommit_lambda1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (RevCommit)ScriptBytecodeAdapter.castToType(remoteBranches.stream().filter(new _getMergeBaseCommit_lambda1(ChangelogUtils.class, ChangelogUtils.class, headCommit)::doCall).map(new _getMergeBaseCommit_lambda2(ChangelogUtils.class, ChangelogUtils.class, git2)::doCall).filter(new _getMergeBaseCommit_lambda3(ChangelogUtils.class, ChangelogUtils.class, headCommit)::doCall).sorted(Comparator.comparing(new Function<RevCommit, Integer>(){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public Integer apply(RevCommit revCommit) {
                return Integer.MAX_VALUE - revCommit.getCommitTime();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        })).findFirst().orElse(null), RevCommit.class);
    }

    private static List<Ref> getAvailableRemoteBranches(Git git) {
        ListBranchCommand command = git.branchList();
        ListBranchCommand.ListMode listMode = ListBranchCommand.ListMode.REMOTE;
        command.setListMode(listMode);
        return command.call();
    }

    /*
     * Loose catch block
     */
    private static RevCommit getMergeBase(Git git, Ref other) {
        RevCommit revCommit;
        Throwable __$$primaryExc0;
        RevWalk walk;
        block30: {
            Object v2;
            block29: {
                walk = new RevWalk(git.getRepository());
                __$$primaryExc0 = null;
                walk.setRevFilter(RevFilter.MERGE_BASE);
                walk.markStart(ChangelogUtils.getCommitFromRef(git, other));
                walk.markStart(ChangelogUtils.getHead(git));
                RevCommit mergeBase = null;
                RevCommit current = null;
                while (ScriptBytecodeAdapter.compareNotIdentical((Object)(current = walk.next()), null)) {
                }
                revCommit = mergeBase;
                if (!(__$$primaryExc0 != null)) break block29;
                try {
                    Object v0;
                    RevWalk revWalk = walk;
                    if (revWalk != null) {
                        revWalk.close();
                        v0 = null;
                        break block30;
                    }
                    v0 = null;
                }
                catch (Throwable __$$suppressedExc0) {
                    Object v1;
                    Throwable throwable = __$$primaryExc0;
                    if (throwable != null) {
                        throwable.addSuppressed(__$$suppressedExc0);
                        v1 = null;
                        break block30;
                    }
                    v1 = null;
                }
                break block30;
            }
            RevWalk revWalk = walk;
            if (revWalk != null) {
                revWalk.close();
                v2 = null;
                break block30;
            }
            v2 = null;
        }
        return revCommit;
        {
            catch (Throwable __$$t0) {
                try {
                    __$$primaryExc0 = __$$t0;
                    throw __$$t0;
                }
                catch (Throwable throwable) {
                    try {
                        if (__$$primaryExc0 != null) {
                            try {
                                Object v3;
                                RevWalk revWalk = walk;
                                if (revWalk != null) {
                                    revWalk.close();
                                    v3 = null;
                                }
                                v3 = null;
                            }
                            catch (Throwable __$$suppressedExc0) {
                                Object v4;
                                Throwable throwable2 = __$$primaryExc0;
                                if (throwable2 != null) {
                                    throwable2.addSuppressed(__$$suppressedExc0);
                                    v4 = null;
                                }
                                v4 = null;
                            }
                        } else {
                            Object v5;
                            RevWalk revWalk = walk;
                            if (revWalk != null) {
                                revWalk.close();
                                v5 = null;
                            } else {
                                v5 = null;
                            }
                        }
                        throw throwable;
                    }
                    catch (MissingObjectException ignored) {
                        RevCommit revCommit2 = (RevCommit)ScriptBytecodeAdapter.castToType(null, RevCommit.class);
                        return revCommit2;
                    }
                }
            }
        }
    }

    private static RevCommit getHead(Git git) {
        ObjectId headId = git.getRepository().resolve(Constants.HEAD);
        return ChangelogUtils.getCommitFromId(git, headId);
    }

    private static RevCommit getCommitFromRef(Git git, Ref other) {
        Object v2;
        RevCommit revCommit;
        Throwable __$$primaryExc1;
        RevWalk revWalk;
        block23: {
            revWalk = new RevWalk(git.getRepository());
            __$$primaryExc1 = null;
            revCommit = revWalk.parseCommit((AnyObjectId)other.getObjectId());
            if (!(__$$primaryExc1 != null)) break block23;
            try {
                Object v0;
                RevWalk revWalk2 = revWalk;
                if (revWalk2 != null) {
                    revWalk2.close();
                    v0 = null;
                }
                v0 = null;
            }
            catch (Throwable __$$suppressedExc1) {
                Object v1;
                Throwable throwable = __$$primaryExc1;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc1);
                    v1 = null;
                }
                v1 = null;
            }
        }
        RevWalk revWalk3 = revWalk;
        if (revWalk3 != null) {
            revWalk3.close();
            v2 = null;
        } else {
            v2 = null;
        }
        try {
            return revCommit;
        }
        catch (Throwable __$$t1) {
            try {
                __$$primaryExc1 = __$$t1;
                throw __$$t1;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc1 != null) {
                    try {
                        Object v3;
                        RevWalk revWalk4 = revWalk;
                        if (revWalk4 != null) {
                            revWalk4.close();
                            v3 = null;
                        }
                        v3 = null;
                    }
                    catch (Throwable __$$suppressedExc1) {
                        Object v4;
                        Throwable throwable2 = __$$primaryExc1;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc1);
                            v4 = null;
                        }
                        v4 = null;
                    }
                } else {
                    Object v5;
                    RevWalk revWalk5 = revWalk;
                    if (revWalk5 != null) {
                        revWalk5.close();
                        v5 = null;
                    } else {
                        v5 = null;
                    }
                }
                throw throwable;
            }
        }
    }

    private static RevCommit getCommitFromId(Git git, ObjectId other) {
        Object v2;
        RevCommit revCommit;
        Throwable __$$primaryExc2;
        RevWalk revWalk;
        block23: {
            revWalk = new RevWalk(git.getRepository());
            __$$primaryExc2 = null;
            revCommit = revWalk.parseCommit((AnyObjectId)other);
            if (!(__$$primaryExc2 != null)) break block23;
            try {
                Object v0;
                RevWalk revWalk2 = revWalk;
                if (revWalk2 != null) {
                    revWalk2.close();
                    v0 = null;
                }
                v0 = null;
            }
            catch (Throwable __$$suppressedExc2) {
                Object v1;
                Throwable throwable = __$$primaryExc2;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc2);
                    v1 = null;
                }
                v1 = null;
            }
        }
        RevWalk revWalk3 = revWalk;
        if (revWalk3 != null) {
            revWalk3.close();
            v2 = null;
        } else {
            v2 = null;
        }
        try {
            return revCommit;
        }
        catch (Throwable __$$t2) {
            try {
                __$$primaryExc2 = __$$t2;
                throw __$$t2;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc2 != null) {
                    try {
                        Object v3;
                        RevWalk revWalk4 = revWalk;
                        if (revWalk4 != null) {
                            revWalk4.close();
                            v3 = null;
                        }
                        v3 = null;
                    }
                    catch (Throwable __$$suppressedExc2) {
                        Object v4;
                        Throwable throwable2 = __$$primaryExc2;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc2);
                            v4 = null;
                        }
                        v4 = null;
                    }
                } else {
                    Object v5;
                    RevWalk revWalk5 = revWalk;
                    if (revWalk5 != null) {
                        revWalk5.close();
                        v5 = null;
                    } else {
                        v5 = null;
                    }
                }
                throw throwable;
            }
        }
    }

    private static Iterable<RevCommit> getCommitLogFromTo(Git git, RevCommit start, RevCommit end) {
        LogCommand log = git.log().add((AnyObjectId)end);
        RevCommit parent2 = null;
        RevCommit[] revCommitArray = start.getParents();
        if (revCommitArray != null) {
            for (RevCommit parent2 : revCommitArray) {
                log.not((AnyObjectId)parent2);
            }
        }
        return log.call();
    }

    private static Map<String, String> getCommitToTagMap(Git git) {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        List list = git.tagList().call();
        Iterator iterator = list != null ? list.iterator() : null;
        Ref tag = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                tag = (Ref)ScriptBytecodeAdapter.castToType(iterator2.next(), Ref.class);
                ObjectId objectId = git.getRepository().getRefDatabase().peel(tag).getPeeledObjectId();
                ObjectId tagId = DefaultTypeTransformation.booleanUnbox((Object)objectId) ? objectId : tag.getObjectId();
                versionMap.put(tagId.name(), tag.getName().replace(Constants.R_TAGS, ""));
            }
        }
        return versionMap;
    }

    private static Map<String, String> getTagToCommitMap(Git git) {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        List list = git.tagList().call();
        Iterator iterator = list != null ? list.iterator() : null;
        Ref tag = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                tag = (Ref)ScriptBytecodeAdapter.castToType(iterator2.next(), Ref.class);
                ObjectId objectId = git.getRepository().getRefDatabase().peel(tag).getPeeledObjectId();
                ObjectId tagId = DefaultTypeTransformation.booleanUnbox((Object)objectId) ? objectId : tag.getObjectId();
                versionMap.put(tag.getName().replace(Constants.R_TAGS, ""), tagId.name());
            }
        }
        return versionMap;
    }

    private static Map<String, String> buildVersionMap(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        String prereleaseTargetVersion = ChangelogUtils.getFirstReleasedVersion(commits, commitHashToVersions);
        List reversedCommits = DefaultGroovyMethods.reverse(commits);
        String currentVersion = "";
        int offset = 0;
        HashMap<String, String> versionMap = new HashMap<String, String>();
        List list = reversedCommits;
        Iterator iterator = list != null ? list.iterator() : null;
        RevCommit commit = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                commit = (RevCommit)ScriptBytecodeAdapter.castToType(iterator2.next(), RevCommit.class);
                String commitHash = commit.toObjectId().name();
                String version = ShortTypeHandling.castToString((Object)commitHashToVersions.get(commitHash));
                if (version != null) {
                    offset = 0;
                } else {
                    int n = offset;
                    int cfr_ignored_0 = n + 1;
                }
                String releasedVersion = StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)currentVersion, (CharSequence)"."), (Object)offset);
                if (currentVersion.isEmpty()) {
                    releasedVersion = StringGroovyMethods.plus((String)prereleaseTargetVersion, (CharSequence)new GStringImpl(new Object[]{offset}, new String[]{"-pre-", ""}));
                }
                versionMap.put(commitHash, releasedVersion);
            }
        }
        return versionMap;
    }

    private static String getFirstReleasedVersion(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        String currentVersion = "1.0";
        List<RevCommit> list = commits;
        Iterator<RevCommit> iterator = list != null ? list.iterator() : null;
        RevCommit commit = null;
        Iterator<RevCommit> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                commit = (RevCommit)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), RevCommit.class);
                String commitHash = commit.toObjectId().name();
                String version = ShortTypeHandling.castToString((Object)commitHashToVersions.get(commitHash));
                if (!(version != null)) continue;
            }
        }
        return currentVersion;
    }

    private static Map<String, String> getPrimaryVersionMap(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        String lastVersion = null;
        ArrayList<String> currentVersionCommitHashes = new ArrayList<String>();
        HashMap<String, String> primaryVersionMap = new HashMap<String, String>();
        List<RevCommit> list = commits;
        Iterator<RevCommit> iterator = list != null ? list.iterator() : null;
        RevCommit commit = null;
        Iterator<RevCommit> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                commit = (RevCommit)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), RevCommit.class);
                String commitHash = commit.toObjectId().name();
                currentVersionCommitHashes.add(commitHash);
                String version = ShortTypeHandling.castToString((Object)commitHashToVersions.get(commitHash));
                if (!(version != null)) continue;
                String combinedHash = null;
                ArrayList<String> arrayList = currentVersionCommitHashes;
                Iterator iterator3 = arrayList != null ? arrayList.iterator() : null;
                if (iterator3 != null) {
                    while (iterator3.hasNext()) {
                        combinedHash = ShortTypeHandling.castToString(iterator3.next());
                        primaryVersionMap.put(combinedHash, version);
                    }
                }
                currentVersionCommitHashes.clear();
            }
        }
        if (commitHashToVersions.isEmpty()) {
            lastVersion = "1.0";
        }
        if (lastVersion != null) {
            ArrayList<String> arrayList = currentVersionCommitHashes;
            Iterator iterator4 = arrayList != null ? arrayList.iterator() : null;
            String combinedHash = null;
            Iterator iterator5 = iterator4;
            if (iterator5 != null) {
                while (iterator5.hasNext()) {
                    combinedHash = ShortTypeHandling.castToString(iterator5.next());
                    primaryVersionMap.put(combinedHash, StringGroovyMethods.plus((String)lastVersion, (CharSequence)"-pre"));
                }
            }
        }
        return primaryVersionMap;
    }

    private static Map<String, Integer> determinePrefixLengthPerPrimaryVersion(Collection<String> availableVersions, Set<String> availablePrimaryVersions) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ArrayList<String> sortedVersions = new ArrayList<String>(availablePrimaryVersions);
        Collections.sort(sortedVersions);
        List workingPrimaryVersions = DefaultGroovyMethods.reverse(sortedVersions);
        Collection<String> collection = availableVersions;
        String version = null;
        Iterator<String> iterator = collection != null ? collection.iterator() : null;
        if (iterator != null) {
            block0: while (iterator.hasNext()) {
                version = ShortTypeHandling.castToString((Object)iterator.next());
                String primaryVersion = null;
                List list = workingPrimaryVersions;
                Iterator iterator2 = list != null ? list.iterator() : null;
                if (iterator2 == null) continue;
                while (iterator2.hasNext()) {
                    primaryVersion = ShortTypeHandling.castToString(iterator2.next());
                    if (!version.startsWith(primaryVersion)) continue;
                    int length = version.trim().length();
                    if (!(!result.containsKey(primaryVersion) || ScriptBytecodeAdapter.compareLessThan((Object)result.get(primaryVersion), (Object)length))) continue block0;
                    result.put(primaryVersion, length);
                    continue block0;
                }
            }
        }
        return result;
    }

    private static String processCommitBody(String body) {
        String[] bodyLines = body.split("\n");
        ArrayList<String> resultingLines = new ArrayList<String>();
        String bodyLine2 = null;
        String[] stringArray = bodyLines;
        if (bodyLines != null) {
            for (String bodyLine2 : stringArray) {
                if (bodyLine2.startsWith("Signed-off-by: ") || bodyLine2.trim().isEmpty()) continue;
                resultingLines.add(bodyLine2);
            }
        }
        return String.join((CharSequence)"\n", resultingLines).trim();
    }

    private static RevCommit getFirstCommitInRepository(Git git) {
        Iterable commits = git.log().call();
        List commitList = DefaultGroovyMethods.toList((Iterable)commits);
        if (commitList.isEmpty()) {
            return (RevCommit)ScriptBytecodeAdapter.castToType(null, RevCommit.class);
        }
        return (RevCommit)ScriptBytecodeAdapter.castToType(commitList.get(commitList.size() - 1), RevCommit.class);
    }

    /*
     * WARNING - void declaration
     */
    public static void setupChangelogGeneration(Project project, String rev) {
        void var1_1;
        Reference project2 = new Reference((Object)project);
        Reference rev2 = new Reference((Object)var1_1);
        public final class _setupChangelogGeneration_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rev;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setupChangelogGeneration_closure4(Object _outerInstance, Object _thisObject, Reference rev) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.rev = reference = rev;
            }

            public Void doCall(Object it) {
                ((GenerateChangelogTask)((Object)it)).getStartingRevision().set((Object)ShortTypeHandling.castToString((Object)this.rev.get()));
                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
            }

            @Generated
            public String getRev() {
                return ShortTypeHandling.castToString((Object)this.rev.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Void doCall() {
                CallSite[] callSiteArray = _setupChangelogGeneration_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupChangelogGeneration_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_setupChangelogGeneration_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setupChangelogGeneration_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference task = new Reference((Object)((Project)project2.get()).getTasks().register(CHANGELOG_GENERATION_TASK_NAME, GenerateChangelogTask.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _setupChangelogGeneration_closure4(ChangelogUtils.class, ChangelogUtils.class, rev2)), Action.class)));
        public final class _setupChangelogGeneration_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference task;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setupChangelogGeneration_closure5(Object _outerInstance, Object _thisObject, Reference project, Reference task) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.project = reference2 = project;
                this.task = reference = task;
            }

            public Void doCall(Object it) {
                public final class _closure8
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference task;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure8(Object _outerInstance, Object _thisObject, Reference task) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.task = reference = task;
                    }

                    public Task doCall(Task assembleTask) {
                        return assembleTask.dependsOn(new Object[]{(TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.task.get(), TaskProvider.class)});
                    }

                    @Generated
                    public Task call(Task assembleTask) {
                        return this.doCall(assembleTask);
                    }

                    @Generated
                    public TaskProvider getTask() {
                        return (TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.task.get(), TaskProvider.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure8.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class)).getTasks().named(LifecycleBasePlugin.ASSEMBLE_TASK_NAME).configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure8((Object)this, this.getThisObject(), this.task)), Action.class));
                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            @Generated
            public TaskProvider getTask() {
                return (TaskProvider)ScriptBytecodeAdapter.castToType((Object)this.task.get(), TaskProvider.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Void doCall() {
                CallSite[] callSiteArray = _setupChangelogGeneration_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupChangelogGeneration_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_setupChangelogGeneration_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setupChangelogGeneration_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ((Project)project2.get()).getPlugins().withType(LifecycleBasePlugin.class).configureEach((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _setupChangelogGeneration_closure5(ChangelogUtils.class, ChangelogUtils.class, project2, task)), Action.class));
    }

    public static void setupChangelogGenerationOnAllPublishTasks(Project project) {
        Reference project2 = new Reference((Object)project);
        public final class _setupChangelogGenerationOnAllPublishTasks_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setupChangelogGenerationOnAllPublishTasks_closure6(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Void doCall(Object it) {
                PublishingExtension extension = (PublishingExtension)ScriptBytecodeAdapter.castToType((Object)((Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class)).getExtensions().getByType(PublishingExtension.class), PublishingExtension.class);
                public final class _closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference project;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure9(Object _outerInstance, Object _thisObject, Reference project) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.project = reference = project;
                    }

                    public Void doCall(MavenPublication publication) {
                        ChangelogUtils.setupChangelogGenerationForPublishing((Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class), publication);
                        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
                    }

                    @Generated
                    public Void call(MavenPublication publication) {
                        return this.doCall(publication);
                    }

                    @Generated
                    public Project getProject() {
                        return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                extension.getPublications().withType(MavenPublication.class).configureEach((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure9((Object)this, this.getThisObject(), this.project)), Action.class));
                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Void doCall() {
                CallSite[] callSiteArray = _setupChangelogGenerationOnAllPublishTasks_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupChangelogGenerationOnAllPublishTasks_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_setupChangelogGenerationOnAllPublishTasks_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setupChangelogGenerationOnAllPublishTasks_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ((Project)project2.get()).getPlugins().withType(PublishingPlugin.class).configureEach((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _setupChangelogGenerationOnAllPublishTasks_closure6(ChangelogUtils.class, ChangelogUtils.class, project2)), Action.class));
    }

    /*
     * WARNING - void declaration
     */
    public static void setupChangelogGenerationForPublishing(Project project, MavenPublication publication) {
        void var1_1;
        Reference project2 = new Reference((Object)project);
        Reference publication2 = new Reference((Object)var1_1);
        try {
            ((Project)project2.get()).afterEvaluate((Action)new Action<Project>(project2, publication2){
                public /* synthetic */ Reference publication;
                public /* synthetic */ Reference project;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Reference reference;
                    Reference reference2;
                    this.project = reference2 = p0;
                    this.publication = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public void execute(Project evaluatedProject) {
                    ChangelogUtils.setupChangelogGenerationForPublishingAfterEvaluation((Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class), (MavenPublication)ScriptBytecodeAdapter.castToType((Object)this.publication.get(), MavenPublication.class));
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    if (!(args instanceof Object[])) {
                        return ScriptBytecodeAdapter.invokeMethodN(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                    }
                    if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                        return ScriptBytecodeAdapter.invokeMethodN(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                    }
                    return ScriptBytecodeAdapter.invokeMethodN(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    if (!(args instanceof Object[])) {
                        return ScriptBytecodeAdapter.invokeMethodN(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                    }
                    if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                        return ScriptBytecodeAdapter.invokeMethodN(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                    }
                    return ScriptBytecodeAdapter.invokeMethodN(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                @Transient
                public MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }
            });
        }
        catch (InvalidUserCodeException ignored) {
            ChangelogUtils.setupChangelogGenerationForPublishingAfterEvaluation((Project)project2.get(), (MavenPublication)publication2.get());
        }
    }

    private static void setupChangelogGenerationForPublishingAfterEvaluation(Project project, MavenPublication publication) {
        Reference task = new Reference((Object)project.getTasks().named(CHANGELOG_GENERATION_TASK_NAME, GenerateChangelogTask.class));
        public final class _setupChangelogGenerationForPublishingAfterEvaluation_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setupChangelogGenerationForPublishingAfterEvaluation_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public RegularFileProperty doCall(Object it) {
                return ((GenerateChangelogTask)((Object)it)).getOutputFile();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public RegularFileProperty doCall() {
                CallSite[] callSiteArray = _setupChangelogGenerationForPublishingAfterEvaluation_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupChangelogGenerationForPublishingAfterEvaluation_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_setupChangelogGenerationForPublishingAfterEvaluation_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setupChangelogGenerationForPublishingAfterEvaluation_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        publication.artifact((Object)((TaskProvider)task.get()).flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _setupChangelogGenerationForPublishingAfterEvaluation_closure7(ChangelogUtils.class, ChangelogUtils.class)), Transformer.class)), (Action)new Action<MavenArtifact>(task){
            public /* synthetic */ Reference task;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                this.task = reference = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void execute(MavenArtifact mavenArtifact) {
                mavenArtifact.builtBy(new Object[]{this.task.get()});
                String string = "changelog";
                mavenArtifact.setClassifier(string);
                String string2 = "txt";
                mavenArtifact.setExtension(string2);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        });
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ChangelogUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ChangelogUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ChangelogUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ChangelogUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ChangelogUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ChangelogUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

