/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraftforge.gradleutils.ChangelogUtils;
import net.minecraftforge.gradleutils.GradleUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateChangelogTask
extends DefaultTask {
    public GenerateChangelogTask() {
        this.getGitDirectory().fileValue(GradleUtils.getGitDirectory(this.getProject().getProjectDir()));
        this.getBuildMarkdown().convention((Object)false);
        this.getOutputFile().convention(this.getProject().getLayout().getBuildDirectory().file("changelog.txt"));
        this.getStartingCommit().convention((Object)"");
        this.getStartingTag().convention((Object)"");
        this.getProjectUrl().convention((Object)GradleUtils.buildProjectUrl(this.getProject().getProjectDir()));
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getGitDirectory();

    @Input
    public abstract Property<Boolean> getBuildMarkdown();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    public abstract Property<String> getStartingCommit();

    @Input
    public abstract Property<String> getStartingTag();

    @Input
    public abstract Property<String> getProjectUrl();

    @TaskAction
    public void generate() {
        String startingCommit = (String)this.getStartingCommit().getOrElse((Object)"");
        String startingTag = (String)this.getStartingTag().getOrElse((Object)"");
        if (!startingCommit.isEmpty() && !startingTag.isEmpty()) {
            throw new IllegalStateException("Both starting commit and tag are supplied to the task: " + this.getName() + ". Only supply one!");
        }
        String changelog = "";
        changelog = startingCommit.isEmpty() && startingTag.isEmpty() ? ChangelogUtils.generateChangelog((File)this.getGitDirectory().getAsFile().get(), (String)this.getProjectUrl().get(), (Boolean)this.getBuildMarkdown().get() == false) : (startingCommit.isEmpty() ? ChangelogUtils.generateChangelog((File)this.getGitDirectory().getAsFile().get(), (String)this.getProjectUrl().get(), (Boolean)this.getBuildMarkdown().get() == false, startingTag) : ChangelogUtils.generateChangelogFromCommit((File)this.getGitDirectory().getAsFile().get(), (String)this.getProjectUrl().get(), (Boolean)this.getBuildMarkdown().get() == false, startingCommit));
        File outputFile = (File)this.getOutputFile().getAsFile().get();
        outputFile.getParentFile().mkdirs();
        if (outputFile.exists()) {
            outputFile.delete();
        }
        try {
            Files.write(outputFile.toPath(), changelog.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write changelog to file: " + outputFile.getAbsolutePath());
        }
    }
}

