/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraftforge.gradleutils.tasks.GenerateChangelogTask;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;

public class ChangelogUtils
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public ChangelogUtils() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String generateChangelog(File projectDirectory, String repositoryUrl, boolean justText) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object git = callSiteArray[0].call(Git.class, (Object)projectDirectory);
        Object headCommit = callSiteArray[1].callStatic(ChangelogUtils.class, git);
        Object logFromCommit = callSiteArray[2].callStatic(ChangelogUtils.class, git);
        if (ScriptBytecodeAdapter.compareEqual((Object)logFromCommit, null)) {
            Object object;
            logFromCommit = object = callSiteArray[3].callStatic(ChangelogUtils.class, git);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[4].callStatic(ChangelogUtils.class, ArrayUtil.createArray((Object)git, (Object)repositoryUrl, (Object)justText, (Object)logFromCommit, (Object)headCommit)));
    }

    public static String generateChangelog(File projectDirectory, String repositoryUrl, boolean justText, String sourceTag) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object git = callSiteArray[5].call(Git.class, (Object)projectDirectory);
        Object tagMap = callSiteArray[6].callStatic(ChangelogUtils.class, git);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call(tagMap, (Object)sourceTag))) {
            throw (Throwable)callSiteArray[8].callConstructor(IllegalArgumentException.class, callSiteArray[9].call(callSiteArray[10].call((Object)"The tag: ", (Object)sourceTag), (Object)" does not exist in the repository"));
        }
        Object commitHash = callSiteArray[11].call(tagMap, (Object)sourceTag);
        Object commit = callSiteArray[12].callStatic(ChangelogUtils.class, git, callSiteArray[13].call(ObjectId.class, commitHash));
        Object headCommit = callSiteArray[14].callStatic(ChangelogUtils.class, git);
        return ShortTypeHandling.castToString((Object)callSiteArray[15].callStatic(ChangelogUtils.class, ArrayUtil.createArray((Object)git, (Object)repositoryUrl, (Object)justText, (Object)commit, (Object)headCommit)));
    }

    public static String generateChangelogFromCommit(File projectDirectory, String repositoryUrl, boolean justText, String commitHash) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object git = callSiteArray[16].call(Git.class, (Object)projectDirectory);
        Object commit = callSiteArray[17].callStatic(ChangelogUtils.class, git, callSiteArray[18].call(ObjectId.class, (Object)commitHash));
        Object headCommit = callSiteArray[19].callStatic(ChangelogUtils.class, git);
        return ShortTypeHandling.castToString((Object)callSiteArray[20].callStatic(ChangelogUtils.class, ArrayUtil.createArray((Object)git, (Object)repositoryUrl, (Object)justText, (Object)commit, (Object)headCommit)));
    }

    public static String generateChangelogFromTo(Git git, String repositoryUrl, boolean justText, RevCommit start, RevCommit end) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object endCommitHash = callSiteArray[21].call(callSiteArray[22].call((Object)end));
        Object startCommitHash = callSiteArray[23].call(callSiteArray[24].call((Object)start));
        Object changeLogName = callSiteArray[25].callGetProperty(callSiteArray[26].callGetProperty((Object)git));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)changeLogName, null)) {
            Object object;
            changeLogName = object = callSiteArray[27].call(changeLogName, (Object)"refs/heads/", (Object)"");
        }
        Object log = callSiteArray[28].callStatic(ChangelogUtils.class, (Object)git, (Object)start, (Object)end);
        Object logList = callSiteArray[29].call(log);
        Object tagMap = callSiteArray[30].callStatic(ChangelogUtils.class, (Object)git);
        Object versionMap = callSiteArray[31].callStatic(ChangelogUtils.class, logList, tagMap);
        Object primaryVersionMap = callSiteArray[32].callStatic(ChangelogUtils.class, logList, tagMap);
        Object primaryVersionPrefixLengthMap = callSiteArray[33].callStatic(ChangelogUtils.class, callSiteArray[34].call(versionMap), callSiteArray[35].callConstructor(HashSet.class, callSiteArray[36].call(primaryVersionMap)));
        Object changelog = new GStringImpl(new Object[]{changeLogName, repositoryUrl, startCommitHash, endCommitHash}, new String[]{"### [", " Changelog](", "/compare/", "...", ")\n"});
        if (justText) {
            GStringImpl gStringImpl;
            changelog = gStringImpl = new GStringImpl(new Object[]{changeLogName}, new String[]{"", " Changelog\n"});
        }
        Object currentPrimaryVersion = "";
        Object pullRequestPattern = callSiteArray[37].call(Pattern.class, (Object)"\\(#(?<pullNumber>[0-9]+)\\)");
        RevCommit commit = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call(logList), Iterator.class);
        while (iterator.hasNext()) {
            Object object;
            commit = (RevCommit)ScriptBytecodeAdapter.castToType(iterator.next(), RevCommit.class);
            Object commitHash = callSiteArray[39].call(callSiteArray[40].call((Object)commit));
            Boolean requiresVersionHeader = false;
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].call(primaryVersionMap, commitHash))) {
                Object object2;
                Object versionsPrimaryVersion = callSiteArray[42].call(primaryVersionMap, commitHash);
                boolean bl = ScriptBytecodeAdapter.compareNotEqual((Object)versionsPrimaryVersion, (Object)currentPrimaryVersion);
                requiresVersionHeader = bl;
                currentPrimaryVersion = object2 = versionsPrimaryVersion;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)requiresVersionHeader) && justText) {
                String header = currentPrimaryVersion;
                Object headerMarker = callSiteArray[43].call((Object)header, (Object)".", (Object)"=");
                changelog = callSiteArray[44].call(changelog, (Object)new GStringImpl(new Object[]{header}, new String[]{"", "\n"}));
                changelog = callSiteArray[45].call(changelog, (Object)new GStringImpl(new Object[]{headerMarker}, new String[]{"", "\n"}));
            }
            Object commitHeader = " - ";
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].call(versionMap, commitHash))) {
                Object version = callSiteArray[47].call(versionMap, commitHash);
                commitHeader = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call(tagMap, commitHash)) && !justText ? callSiteArray[49].call(commitHeader, (Object)new GStringImpl(new Object[]{callSiteArray[50].call(version, callSiteArray[51].call(primaryVersionPrefixLengthMap, currentPrimaryVersion)), repositoryUrl, version}, new String[]{"[", "](", "/tree/", ")"})) : callSiteArray[52].call(commitHeader, (Object)new GStringImpl(new Object[]{callSiteArray[53].call(version, callSiteArray[54].call(primaryVersionPrefixLengthMap, currentPrimaryVersion))}, new String[]{"", ""}));
            }
            Object commitHeaderLength = callSiteArray[55].call(commitHeader);
            commitHeader = callSiteArray[56].call(commitHeader, (Object)" ");
            Object noneCommitHeaderPrefix = callSiteArray[57].call(callSiteArray[58].call(String.class, (Object)"", callSiteArray[59].call(Collections.class, commitHeaderLength, (Object)" ")), (Object)" ");
            Object subject = callSiteArray[60].callStatic(ChangelogUtils.class, callSiteArray[61].call(callSiteArray[62].call((Object)commit)));
            if (!justText) {
                Object matcher = callSiteArray[63].call(pullRequestPattern, subject);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call(matcher))) {
                    Object object3;
                    Object pullRequestNumber = callSiteArray[65].call(matcher, (Object)"pullNumber");
                    subject = object3 = callSiteArray[66].call(subject, (Object)new GStringImpl(new Object[]{pullRequestNumber}, new String[]{"#", ""}), (Object)new GStringImpl(new Object[]{pullRequestNumber, repositoryUrl, pullRequestNumber}, new String[]{"[#", "](", "/pull/", ")"}));
                }
            }
            subject = object = callSiteArray[67].call(subject, (Object)"\\n", callSiteArray[68].call((Object)"\n", noneCommitHeaderPrefix));
            changelog = callSiteArray[69].call(changelog, (Object)new GStringImpl(new Object[]{commitHeader, subject}, new String[]{"", "", ""}));
            changelog = callSiteArray[70].call(changelog, (Object)"\n");
            if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call(tagMap, commitHash)) && justText)) continue;
            changelog = callSiteArray[72].call(changelog, (Object)"\n");
        }
        return ShortTypeHandling.castToString((Object)changelog);
    }

    private static RevCommit getMergeBaseCommit(Git git) {
        Reference git2 = new Reference((Object)git);
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Reference headCommit = new Reference(callSiteArray[73].callStatic(ChangelogUtils.class, (Object)((Git)git2.get())));
        Object remoteBranches = callSiteArray[74].callStatic(ChangelogUtils.class, (Object)((Git)git2.get()));
        public final class _getMergeBaseCommit_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference headCommit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getMergeBaseCommit_closure1(Object _outerInstance, Object _thisObject, Reference headCommit) {
                Reference reference;
                CallSite[] callSiteArray = _getMergeBaseCommit_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.headCommit = reference = headCommit;
            }

            public Object doCall(Object branch) {
                CallSite[] callSiteArray = _getMergeBaseCommit_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].call(callSiteArray[1].call(branch)), (Object)callSiteArray[2].call(callSiteArray[3].call(this.headCommit.get())));
            }

            @Generated
            public Object getHeadCommit() {
                CallSite[] callSiteArray = _getMergeBaseCommit_closure1.$getCallSiteArray();
                return this.headCommit.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMergeBaseCommit_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getName";
                stringArray[1] = "getObjectId";
                stringArray[2] = "getName";
                stringArray[3] = "toObjectId";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _getMergeBaseCommit_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getMergeBaseCommit_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getMergeBaseCommit_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _getMergeBaseCommit_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference git;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getMergeBaseCommit_closure2(Object _outerInstance, Object _thisObject, Reference git) {
                Reference reference;
                CallSite[] callSiteArray = _getMergeBaseCommit_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.git = reference = git;
            }

            public Object doCall(Object branch) {
                CallSite[] callSiteArray = _getMergeBaseCommit_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, this.git.get(), branch);
            }

            @Generated
            public Git getGit() {
                CallSite[] callSiteArray = _getMergeBaseCommit_closure2.$getCallSiteArray();
                return (Git)ScriptBytecodeAdapter.castToType((Object)this.git.get(), Git.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMergeBaseCommit_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "getMergeBase";
                return new CallSiteArray(_getMergeBaseCommit_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getMergeBaseCommit_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _getMergeBaseCommit_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference headCommit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getMergeBaseCommit_closure3(Object _outerInstance, Object _thisObject, Reference headCommit) {
                Reference reference;
                CallSite[] callSiteArray = _getMergeBaseCommit_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.headCommit = reference = headCommit;
            }

            public Object doCall(Object revCommit) {
                CallSite[] callSiteArray = _getMergeBaseCommit_closure3.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].call(callSiteArray[1].call(revCommit)), (Object)callSiteArray[2].call(callSiteArray[3].call(this.headCommit.get())));
            }

            @Generated
            public Object getHeadCommit() {
                CallSite[] callSiteArray = _getMergeBaseCommit_closure3.$getCallSiteArray();
                return this.headCommit.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMergeBaseCommit_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getName";
                stringArray[1] = "toObjectId";
                stringArray[2] = "getName";
                stringArray[3] = "toObjectId";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _getMergeBaseCommit_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getMergeBaseCommit_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getMergeBaseCommit_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (RevCommit)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].call(callSiteArray[78].call(callSiteArray[79].call(callSiteArray[80].call(callSiteArray[81].call(remoteBranches), (Object)new _getMergeBaseCommit_closure1(ChangelogUtils.class, ChangelogUtils.class, headCommit)), (Object)new _getMergeBaseCommit_closure2(ChangelogUtils.class, ChangelogUtils.class, git2)), (Object)new _getMergeBaseCommit_closure3(ChangelogUtils.class, ChangelogUtils.class, headCommit)), callSiteArray[82].call(Comparator.class, (Object)new Function<RevCommit, Integer>(){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public Integer apply(RevCommit revCommit) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(Integer.class), callSiteArray[2].call((Object)revCommit)), Integer.class);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "minus";
                stringArray[1] = "MAX_VALUE";
                stringArray[2] = "getCommitTime";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }))), null), RevCommit.class);
    }

    private static List<Ref> getAvailableRemoteBranches(Git git) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object command = callSiteArray[83].call((Object)git);
        Object object = callSiteArray[84].callGetProperty(ListBranchCommand.ListMode.class);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)command, (String)"listMode");
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].call(command), List.class);
    }

    /*
     * Loose catch block
     */
    private static RevCommit getMergeBase(Git git, Ref other) {
        RevCommit revCommit;
        Throwable __$$primaryExc0;
        RevWalk walk;
        CallSite[] callSiteArray;
        block23: {
            callSiteArray = ChangelogUtils.$getCallSiteArray();
            walk = (RevWalk)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callConstructor(RevWalk.class, callSiteArray[87].callGetProperty((Object)git)), RevWalk.class);
            __$$primaryExc0 = null;
            callSiteArray[88].call((Object)walk, callSiteArray[89].callGetProperty(RevFilter.class));
            callSiteArray[90].call((Object)walk, callSiteArray[91].callStatic(ChangelogUtils.class, (Object)git, (Object)other));
            callSiteArray[92].call((Object)walk, callSiteArray[93].callStatic(ChangelogUtils.class, (Object)git));
            RevCommit mergeBase = null;
            RevCommit current = null;
            while (true) {
                RevCommit revCommit2;
                Object object = callSiteArray[94].call((Object)walk);
                current = (RevCommit)ScriptBytecodeAdapter.castToType((Object)object, RevCommit.class);
                if (!ScriptBytecodeAdapter.compareNotEqual((Object)object, null)) break;
                mergeBase = revCommit2 = current;
            }
            revCommit = mergeBase;
            if (ScriptBytecodeAdapter.compareNotEqual((Object)__$$primaryExc0, null)) {
                try {
                    callSiteArray[95].callSafe((Object)walk);
                }
                catch (Throwable __$$suppressedExc0) {
                    callSiteArray[96].callSafe((Object)__$$primaryExc0, (Object)__$$suppressedExc0);
                }
                break block23;
            }
            callSiteArray[97].callSafe((Object)walk);
        }
        return revCommit;
        {
            catch (Throwable __$$t0) {
                try {
                    Throwable throwable;
                    __$$primaryExc0 = throwable = __$$t0;
                    throw __$$t0;
                }
                catch (Throwable throwable) {
                    try {
                        if (ScriptBytecodeAdapter.compareNotEqual(__$$primaryExc0, null)) {
                            try {
                                callSiteArray[101].callSafe((Object)walk);
                            }
                            catch (Throwable __$$suppressedExc0) {
                                callSiteArray[102].callSafe((Object)__$$primaryExc0, (Object)__$$suppressedExc0);
                            }
                        } else {
                            callSiteArray[103].callSafe((Object)walk);
                        }
                        throw throwable;
                    }
                    catch (MissingObjectException ignored) {
                        RevCommit revCommit3 = (RevCommit)ScriptBytecodeAdapter.castToType(null, RevCommit.class);
                        return revCommit3;
                    }
                }
            }
        }
    }

    private static RevCommit getHead(Git git) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object headId = callSiteArray[104].call(callSiteArray[105].callGetProperty((Object)git), callSiteArray[106].callGetProperty(Constants.class));
        return (RevCommit)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].callStatic(ChangelogUtils.class, (Object)git, headId), RevCommit.class);
    }

    private static RevCommit getCommitFromRef(Git git, Ref other) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        RevWalk revWalk = (RevWalk)ScriptBytecodeAdapter.castToType((Object)callSiteArray[108].callConstructor(RevWalk.class, callSiteArray[109].callGetProperty((Object)git)), RevWalk.class);
        Throwable __$$primaryExc1 = null;
        RevCommit revCommit = (RevCommit)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].call((Object)revWalk, callSiteArray[111].callGetProperty((Object)other)), RevCommit.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)__$$primaryExc1, null)) {
            try {
                callSiteArray[112].callSafe((Object)revWalk);
            }
            catch (Throwable __$$suppressedExc1) {
                callSiteArray[113].callSafe((Object)__$$primaryExc1, (Object)__$$suppressedExc1);
            }
        } else {
            callSiteArray[114].callSafe((Object)revWalk);
        }
        try {
            return revCommit;
        }
        catch (Throwable __$$t1) {
            try {
                Throwable throwable;
                __$$primaryExc1 = throwable = __$$t1;
                throw __$$t1;
            }
            catch (Throwable throwable) {
                if (ScriptBytecodeAdapter.compareNotEqual(__$$primaryExc1, null)) {
                    try {
                        callSiteArray[118].callSafe((Object)revWalk);
                    }
                    catch (Throwable __$$suppressedExc1) {
                        callSiteArray[119].callSafe((Object)__$$primaryExc1, (Object)__$$suppressedExc1);
                    }
                } else {
                    callSiteArray[120].callSafe((Object)revWalk);
                }
                throw throwable;
            }
        }
    }

    private static RevCommit getCommitFromId(Git git, ObjectId other) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        RevWalk revWalk = (RevWalk)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].callConstructor(RevWalk.class, callSiteArray[122].callGetProperty((Object)git)), RevWalk.class);
        Throwable __$$primaryExc2 = null;
        RevCommit revCommit = (RevCommit)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call((Object)revWalk, (Object)other), RevCommit.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)__$$primaryExc2, null)) {
            try {
                callSiteArray[124].callSafe((Object)revWalk);
            }
            catch (Throwable __$$suppressedExc2) {
                callSiteArray[125].callSafe((Object)__$$primaryExc2, (Object)__$$suppressedExc2);
            }
        } else {
            callSiteArray[126].callSafe((Object)revWalk);
        }
        try {
            return revCommit;
        }
        catch (Throwable __$$t2) {
            try {
                Throwable throwable;
                __$$primaryExc2 = throwable = __$$t2;
                throw __$$t2;
            }
            catch (Throwable throwable) {
                if (ScriptBytecodeAdapter.compareNotEqual(__$$primaryExc2, null)) {
                    try {
                        callSiteArray[130].callSafe((Object)revWalk);
                    }
                    catch (Throwable __$$suppressedExc2) {
                        callSiteArray[131].callSafe((Object)__$$primaryExc2, (Object)__$$suppressedExc2);
                    }
                } else {
                    callSiteArray[132].callSafe((Object)revWalk);
                }
                throw throwable;
            }
        }
    }

    private static Iterable<RevCommit> getCommitLogFromTo(Git git, RevCommit start, RevCommit end) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object log = callSiteArray[133].call(callSiteArray[134].call((Object)git), (Object)end);
        RevCommit parent = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].call(callSiteArray[136].call((Object)start)), Iterator.class);
        while (iterator.hasNext()) {
            parent = (RevCommit)ScriptBytecodeAdapter.castToType(iterator.next(), RevCommit.class);
            callSiteArray[137].call(log, (Object)parent);
        }
        return (Iterable)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].call(log), Iterable.class);
    }

    private static Map<String, String> getCommitToTagMap(Git git) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Map versionMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].callConstructor(HashMap.class), Map.class);
        Ref tag = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[140].call(callSiteArray[141].call(callSiteArray[142].call((Object)git))), Iterator.class);
        while (iterator.hasNext()) {
            tag = (Ref)ScriptBytecodeAdapter.castToType(iterator.next(), Ref.class);
            Object object = callSiteArray[143].callGetProperty(callSiteArray[144].call(callSiteArray[145].call(callSiteArray[146].call((Object)git)), (Object)tag));
            ObjectId tagId = (ObjectId)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[147].callGetProperty((Object)tag)), ObjectId.class);
            callSiteArray[148].call((Object)versionMap, callSiteArray[149].call((Object)tagId), callSiteArray[150].call(callSiteArray[151].call((Object)tag), callSiteArray[152].callGetProperty(Constants.class), (Object)""));
        }
        return versionMap;
    }

    private static Map<String, String> getTagToCommitMap(Git git) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Map versionMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[153].callConstructor(HashMap.class), Map.class);
        Ref tag = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[154].call(callSiteArray[155].call(callSiteArray[156].call((Object)git))), Iterator.class);
        while (iterator.hasNext()) {
            tag = (Ref)ScriptBytecodeAdapter.castToType(iterator.next(), Ref.class);
            Object object = callSiteArray[157].callGetProperty(callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].call((Object)git)), (Object)tag));
            ObjectId tagId = (ObjectId)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[161].callGetProperty((Object)tag)), ObjectId.class);
            callSiteArray[162].call((Object)versionMap, callSiteArray[163].call(callSiteArray[164].call((Object)tag), callSiteArray[165].callGetProperty(Constants.class), (Object)""), callSiteArray[166].call((Object)tagId));
        }
        return versionMap;
    }

    private static Map<String, String> buildVersionMap(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object prereleaseTargetVersion = callSiteArray[167].callStatic(ChangelogUtils.class, commits, commitHashToVersions);
        Object reversedCommits = callSiteArray[168].call(commits);
        String currentVersion = "";
        int offset = 0;
        Map versionMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[169].callConstructor(HashMap.class), Map.class);
        RevCommit commit = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[170].call(reversedCommits), Iterator.class);
        while (iterator.hasNext()) {
            commit = (RevCommit)ScriptBytecodeAdapter.castToType(iterator.next(), RevCommit.class);
            Object commitHash = callSiteArray[171].call(callSiteArray[172].call((Object)commit));
            Object version = callSiteArray[173].call(commitHashToVersions, commitHash);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)version, null)) {
                int n;
                offset = n = 0;
                Object object = version;
                currentVersion = ShortTypeHandling.castToString((Object)object);
            } else {
                int n = offset;
                offset = DefaultTypeTransformation.intUnbox((Object)callSiteArray[174].call((Object)n));
            }
            Object releasedVersion = callSiteArray[175].call(callSiteArray[176].call((Object)currentVersion, (Object)"."), (Object)offset);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[177].call((Object)currentVersion))) {
                Object object;
                releasedVersion = object = callSiteArray[178].call(prereleaseTargetVersion, (Object)new GStringImpl(new Object[]{offset}, new String[]{"-pre-", ""}));
            }
            callSiteArray[179].call((Object)versionMap, commitHash, releasedVersion);
        }
        return versionMap;
    }

    private static String getFirstReleasedVersion(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        String currentVersion = "1.0";
        RevCommit commit = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[180].call(commits), Iterator.class);
        while (iterator.hasNext()) {
            commit = (RevCommit)ScriptBytecodeAdapter.castToType(iterator.next(), RevCommit.class);
            Object commitHash = callSiteArray[181].call(callSiteArray[182].call((Object)commit));
            Object version = callSiteArray[183].call(commitHashToVersions, commitHash);
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)version, null)) continue;
            Object object = version;
            currentVersion = ShortTypeHandling.castToString((Object)object);
        }
        return currentVersion;
    }

    private static Map<String, String> getPrimaryVersionMap(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object lastVersion = null;
        List currentVersionCommitHashes = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].callConstructor(ArrayList.class), List.class);
        Map primaryVersionMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[185].callConstructor(HashMap.class), Map.class);
        RevCommit commit = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[186].call(commits), Iterator.class);
        while (iterator.hasNext()) {
            commit = (RevCommit)ScriptBytecodeAdapter.castToType(iterator.next(), RevCommit.class);
            Object commitHash = callSiteArray[187].call(callSiteArray[188].call((Object)commit));
            callSiteArray[189].call((Object)currentVersionCommitHashes, commitHash);
            Object version = callSiteArray[190].call(commitHashToVersions, commitHash);
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)version, null)) continue;
            String combinedHash = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[191].call((Object)currentVersionCommitHashes), Iterator.class);
            while (iterator2.hasNext()) {
                Object object;
                combinedHash = ShortTypeHandling.castToString(iterator2.next());
                callSiteArray[192].call((Object)primaryVersionMap, (Object)combinedHash, version);
                lastVersion = object = version;
            }
            callSiteArray[193].call((Object)currentVersionCommitHashes);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[194].call(commitHashToVersions))) {
            String string = "1.0";
            lastVersion = string;
        }
        if (ScriptBytecodeAdapter.compareNotEqual(lastVersion, null)) {
            String combinedHash = null;
            Iterator iterator3 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[195].call((Object)currentVersionCommitHashes), Iterator.class);
            while (iterator3.hasNext()) {
                combinedHash = ShortTypeHandling.castToString(iterator3.next());
                callSiteArray[196].call((Object)primaryVersionMap, (Object)combinedHash, callSiteArray[197].call(lastVersion, (Object)"-pre"));
            }
        }
        return primaryVersionMap;
    }

    private static Map<String, Integer> determinePrefixLengthPerPrimaryVersion(Collection<String> availableVersions, Set<String> availablePrimaryVersions) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[198].callConstructor(HashMap.class), Map.class);
        ArrayList sortedVersions = (ArrayList)ScriptBytecodeAdapter.castToType((Object)callSiteArray[199].callConstructor(ArrayList.class, availablePrimaryVersions), ArrayList.class);
        callSiteArray[200].call(Collections.class, (Object)sortedVersions);
        List workingPrimaryVersions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[201].call((Object)sortedVersions), List.class);
        String version = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].call(availableVersions), Iterator.class);
        block0: while (iterator.hasNext()) {
            version = ShortTypeHandling.castToString(iterator.next());
            String primaryVersion = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].call((Object)workingPrimaryVersions), Iterator.class);
            while (iterator2.hasNext()) {
                primaryVersion = ShortTypeHandling.castToString(iterator2.next());
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[204].call((Object)version, (Object)primaryVersion))) continue;
                Object length = callSiteArray[205].call(callSiteArray[206].call((Object)version));
                if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[207].call((Object)result, (Object)primaryVersion)) || ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[208].call((Object)result, (Object)primaryVersion), (Object)length))) continue block0;
                callSiteArray[209].call((Object)result, (Object)primaryVersion, length);
                continue block0;
            }
        }
        return result;
    }

    private static String processCommitBody(String body) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        String[] bodyLines = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[210].call((Object)body, (Object)"\n"), String[].class);
        List resultingLines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].callConstructor(ArrayList.class), List.class);
        String bodyLine = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[212].call((Object)bodyLines), Iterator.class);
        while (iterator.hasNext()) {
            bodyLine = ShortTypeHandling.castToString(iterator.next());
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[213].call((Object)bodyLine, (Object)"Signed-off-by: ")) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[214].call(callSiteArray[215].call((Object)bodyLine)))) continue;
            callSiteArray[216].call((Object)resultingLines, (Object)bodyLine);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[217].call(callSiteArray[218].call(String.class, (Object)"\n", (Object)resultingLines)));
    }

    private static RevCommit getFirstCommitInRepository(Git git) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Iterable commits = (Iterable)ScriptBytecodeAdapter.castToType((Object)callSiteArray[219].call(callSiteArray[220].call((Object)git)), Iterable.class);
        List commitList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[221].call((Object)commits), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[222].call((Object)commitList))) {
            return (RevCommit)ScriptBytecodeAdapter.castToType(null, RevCommit.class);
        }
        return (RevCommit)ScriptBytecodeAdapter.castToType((Object)callSiteArray[223].call((Object)commitList, callSiteArray[224].call(callSiteArray[225].call((Object)commitList), (Object)1)), RevCommit.class);
    }

    public static void setupChangelogGeneration(Project project) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        GenerateChangelogTask task = (GenerateChangelogTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[226].call(callSiteArray[227].call((Object)project), (Object)"createChangelog", GenerateChangelogTask.class), GenerateChangelogTask.class));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[228].call(callSiteArray[229].call((Object)project), (Object)"build"), null)) {
            callSiteArray[230].call(callSiteArray[231].call(callSiteArray[232].call((Object)project), (Object)"build"), (Object)task);
        }
    }

    public static void setupChangelogGenerationFromTag(Project project, String tag) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        GenerateChangelogTask task = (GenerateChangelogTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[233].call(callSiteArray[234].call((Object)project), (Object)"createChangelog", GenerateChangelogTask.class), GenerateChangelogTask.class));
        callSiteArray[235].call(callSiteArray[236].call((Object)task), (Object)tag);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[237].call(callSiteArray[238].call((Object)project), (Object)"build"), null)) {
            callSiteArray[239].call(callSiteArray[240].call(callSiteArray[241].call((Object)project), (Object)"build"), (Object)task);
        }
    }

    public static void setupChangelogGenerationFromCommit(Project project, String commit) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        GenerateChangelogTask task = (GenerateChangelogTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[242].call(callSiteArray[243].call((Object)project), (Object)"createChangelog", GenerateChangelogTask.class), GenerateChangelogTask.class));
        callSiteArray[244].call(callSiteArray[245].call((Object)task), (Object)commit);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[246].call(callSiteArray[247].call((Object)project), (Object)"build"), null)) {
            callSiteArray[248].call(callSiteArray[249].call(callSiteArray[250].call((Object)project), (Object)"build"), (Object)task);
        }
    }

    public static void setupChangelogGenerationOnAllPublishTasks(Project project) {
        Reference project2 = new Reference((Object)project);
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        public final class _setupChangelogGenerationOnAllPublishTasks_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setupChangelogGenerationOnAllPublishTasks_closure4(Object _outerInstance, Object _thisObject, Reference project) {
                Reference reference;
                CallSite[] callSiteArray = _setupChangelogGenerationOnAllPublishTasks_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.project = reference = project;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _setupChangelogGenerationOnAllPublishTasks_closure4.$getCallSiteArray();
                public final class _closure5
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure5(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object innerProject) {
                        Reference innerProject2 = new Reference(innerProject);
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(callSiteArray[1].call(innerProject2.get()), (Object)"publishing"), null)) {
                            return null;
                        }
                        PublishingExtension publishingExtension = (PublishingExtension)ScriptBytecodeAdapter.asType((Object)callSiteArray[2].call(callSiteArray[3].call(innerProject2.get()), (Object)"publishing"), PublishingExtension.class);
                        public final class _closure6
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference innerProject;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure6(Object _outerInstance, Object _thisObject, Reference innerProject) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.innerProject = reference = innerProject;
                            }

                            public Object doCall(Object publication) {
                                CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                                if (publication instanceof MavenPublication) {
                                    return callSiteArray[0].call(ChangelogUtils.class, this.innerProject.get(), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((MavenPublication)ScriptBytecodeAdapter.asType((Object)publication, MavenPublication.class)), MavenPublication.class));
                                }
                                return null;
                            }

                            @Generated
                            public Object getInnerProject() {
                                CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                                return this.innerProject.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure6.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[1];
                                stringArray[0] = "setupChangelogGenerationForPublishing";
                                return new CallSiteArray(_closure6.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure6.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[4].call(callSiteArray[5].call((Object)publishingExtension), (Object)new _closure6((Object)this, this.getThisObject(), innerProject2));
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "findByName";
                        stringArray[1] = "getExtensions";
                        stringArray[2] = "getByName";
                        stringArray[3] = "getExtensions";
                        stringArray[4] = "all";
                        stringArray[5] = "getPublications";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[6];
                        _closure5.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(callSiteArray[1].call(this.project.get()), (Object)new _closure5((Object)this, this.getThisObject()));
            }

            @Generated
            public Project getProject() {
                CallSite[] callSiteArray = _setupChangelogGenerationOnAllPublishTasks_closure4.$getCallSiteArray();
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _setupChangelogGenerationOnAllPublishTasks_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupChangelogGenerationOnAllPublishTasks_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "forEach";
                stringArray[1] = "getAllprojects";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _setupChangelogGenerationOnAllPublishTasks_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_setupChangelogGenerationOnAllPublishTasks_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setupChangelogGenerationOnAllPublishTasks_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[251].call(callSiteArray[252].callGetProperty((Object)((Project)project2.get())), (Object)new _setupChangelogGenerationOnAllPublishTasks_closure4(ChangelogUtils.class, ChangelogUtils.class, project2));
    }

    private static GenerateChangelogTask findNearestChangelogTask(Project project) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if ((ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[253].call((Object)project), null) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[254].call((Object)project), (Object)project)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[255].call(callSiteArray[256].call((Object)project), (Object)"createChangelog"), null)) {
                throw (Throwable)callSiteArray[257].callConstructor(IllegalArgumentException.class, (Object)"The project tree does not have a createChangelog task.");
            }
        } else if ((ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[258].call((Object)project), null) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[259].call((Object)project), (Object)project)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[260].call(callSiteArray[261].call((Object)project), (Object)"createChangelog"), null)) {
            throw (Throwable)callSiteArray[262].callConstructor(IllegalArgumentException.class, (Object)"The project tree does not have a createChangelog task.");
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[263].call(callSiteArray[264].call((Object)project), (Object)"createChangelog"), null)) {
            return (GenerateChangelogTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[265].callStatic(ChangelogUtils.class, callSiteArray[266].call((Object)project)), GenerateChangelogTask.class));
        }
        return (GenerateChangelogTask)((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[267].call(callSiteArray[268].call((Object)project), (Object)"createChangelog"), GenerateChangelogTask.class));
    }

    /*
     * WARNING - void declaration
     */
    public static void setupChangelogGenerationForPublishing(Project project, MavenPublication publication) {
        void var1_1;
        Reference project2 = new Reference((Object)project);
        Reference publication2 = new Reference((Object)var1_1);
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        try {
            callSiteArray[269].call((Object)((Project)project2.get()), (Object)new Action<Project>(project2, publication2){
                public /* synthetic */ Reference publication;
                public /* synthetic */ Reference project;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    MetaClass metaClass;
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    this.project = reference2 = p0;
                    this.publication = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public void execute(Project evaluatedProject) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    callSiteArray[0].callCurrent((GroovyObject)this, this.project.get(), this.publication.get());
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return ScriptBytecodeAdapter.invokeMethodN(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return ScriptBytecodeAdapter.invokeMethodN(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object value) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return ScriptBytecodeAdapter.getProperty(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    CallSite[] callSiteArray = 2.$getCallSiteArray();
                    return ScriptBytecodeAdapter.getProperty(2.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                @Transient
                public MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "setupChangelogGenerationForPublishingAfterEvaluation";
                    return new CallSiteArray(2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = 2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
        }
        catch (InvalidUserCodeException ignored) {
            callSiteArray[270].callStatic(ChangelogUtils.class, (Object)((Project)project2.get()), (Object)((MavenPublication)publication2.get()));
        }
    }

    private static void setupChangelogGenerationForPublishingAfterEvaluation(Project project, MavenPublication publication) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Reference task = new Reference((Object)((GenerateChangelogTask)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[271].callStatic(ChangelogUtils.class, (Object)project), GenerateChangelogTask.class))));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[272].call(callSiteArray[273].callGetProperty(callSiteArray[274].callGetProperty((Object)((GenerateChangelogTask)((Object)task.get())))), (Object)"build"), null)) {
            callSiteArray[275].call(callSiteArray[276].call(callSiteArray[277].callGetProperty(callSiteArray[278].callGetProperty((Object)((GenerateChangelogTask)((Object)task.get())))), (Object)"build"), (Object)((GenerateChangelogTask)((Object)task.get())));
        }
        callSiteArray[279].call((Object)publication, callSiteArray[280].call(callSiteArray[281].call((Object)((GenerateChangelogTask)((Object)task.get())))), (Object)new Action<MavenArtifact>(task){
            public /* synthetic */ Reference task;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                this.task = reference = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void execute(MavenArtifact mavenArtifact) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                callSiteArray[0].call((Object)mavenArtifact, this.task.get());
                String string = "changelog";
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)mavenArtifact, (String)"classifier");
                String string2 = "txt";
                ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)mavenArtifact, (String)"extension");
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 3.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(3.class, ChangelogUtils.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "builtBy";
                return new CallSiteArray(3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ChangelogUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ChangelogUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ChangelogUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ChangelogUtils.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ChangelogUtils.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "open";
        stringArray[1] = "getHead";
        stringArray[2] = "getMergeBaseCommit";
        stringArray[3] = "getFirstCommitInRepository";
        stringArray[4] = "generateChangelogFromTo";
        stringArray[5] = "open";
        stringArray[6] = "getTagToCommitMap";
        stringArray[7] = "containsKey";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "get";
        stringArray[12] = "getCommitFromId";
        stringArray[13] = "fromString";
        stringArray[14] = "getHead";
        stringArray[15] = "generateChangelogFromTo";
        stringArray[16] = "open";
        stringArray[17] = "getCommitFromId";
        stringArray[18] = "fromString";
        stringArray[19] = "getHead";
        stringArray[20] = "generateChangelogFromTo";
        stringArray[21] = "getName";
        stringArray[22] = "toObjectId";
        stringArray[23] = "getName";
        stringArray[24] = "toObjectId";
        stringArray[25] = "fullBranch";
        stringArray[26] = "repository";
        stringArray[27] = "replace";
        stringArray[28] = "getCommitLogFromTo";
        stringArray[29] = "toList";
        stringArray[30] = "getCommitToTagMap";
        stringArray[31] = "buildVersionMap";
        stringArray[32] = "getPrimaryVersionMap";
        stringArray[33] = "determinePrefixLengthPerPrimaryVersion";
        stringArray[34] = "values";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "values";
        stringArray[37] = "compile";
        stringArray[38] = "iterator";
        stringArray[39] = "name";
        stringArray[40] = "toObjectId";
        stringArray[41] = "containsKey";
        stringArray[42] = "get";
        stringArray[43] = "replaceAll";
        stringArray[44] = "plus";
        stringArray[45] = "plus";
        stringArray[46] = "containsKey";
        stringArray[47] = "get";
        stringArray[48] = "containsKey";
        stringArray[49] = "plus";
        stringArray[50] = "padRight";
        stringArray[51] = "get";
        stringArray[52] = "plus";
        stringArray[53] = "padRight";
        stringArray[54] = "get";
        stringArray[55] = "length";
        stringArray[56] = "plus";
        stringArray[57] = "plus";
        stringArray[58] = "join";
        stringArray[59] = "nCopies";
        stringArray[60] = "processCommitBody";
        stringArray[61] = "trim";
        stringArray[62] = "getFullMessage";
        stringArray[63] = "matcher";
        stringArray[64] = "find";
        stringArray[65] = "group";
        stringArray[66] = "replace";
        stringArray[67] = "replaceAll";
        stringArray[68] = "plus";
        stringArray[69] = "plus";
        stringArray[70] = "plus";
        stringArray[71] = "containsKey";
        stringArray[72] = "plus";
        stringArray[73] = "getHead";
        stringArray[74] = "getAvailableRemoteBranches";
        stringArray[75] = "orElse";
        stringArray[76] = "findFirst";
        stringArray[77] = "sorted";
        stringArray[78] = "filter";
        stringArray[79] = "map";
        stringArray[80] = "filter";
        stringArray[81] = "stream";
        stringArray[82] = "comparing";
        stringArray[83] = "branchList";
        stringArray[84] = "REMOTE";
        stringArray[85] = "call";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "repository";
        stringArray[88] = "setRevFilter";
        stringArray[89] = "MERGE_BASE";
        stringArray[90] = "markStart";
        stringArray[91] = "getCommitFromRef";
        stringArray[92] = "markStart";
        stringArray[93] = "getHead";
        stringArray[94] = "next";
        stringArray[95] = "close";
        stringArray[96] = "addSuppressed";
        stringArray[97] = "close";
        stringArray[98] = "close";
        stringArray[99] = "addSuppressed";
        stringArray[100] = "close";
        stringArray[101] = "close";
        stringArray[102] = "addSuppressed";
        stringArray[103] = "close";
        stringArray[104] = "resolve";
        stringArray[105] = "repository";
        stringArray[106] = "HEAD";
        stringArray[107] = "getCommitFromId";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "repository";
        stringArray[110] = "parseCommit";
        stringArray[111] = "objectId";
        stringArray[112] = "close";
        stringArray[113] = "addSuppressed";
        stringArray[114] = "close";
        stringArray[115] = "close";
        stringArray[116] = "addSuppressed";
        stringArray[117] = "close";
        stringArray[118] = "close";
        stringArray[119] = "addSuppressed";
        stringArray[120] = "close";
        stringArray[121] = "<$constructor$>";
        stringArray[122] = "repository";
        stringArray[123] = "parseCommit";
        stringArray[124] = "close";
        stringArray[125] = "addSuppressed";
        stringArray[126] = "close";
        stringArray[127] = "close";
        stringArray[128] = "addSuppressed";
        stringArray[129] = "close";
        stringArray[130] = "close";
        stringArray[131] = "addSuppressed";
        stringArray[132] = "close";
        stringArray[133] = "add";
        stringArray[134] = "log";
        stringArray[135] = "iterator";
        stringArray[136] = "getParents";
        stringArray[137] = "not";
        stringArray[138] = "call";
        stringArray[139] = "<$constructor$>";
        stringArray[140] = "iterator";
        stringArray[141] = "call";
        stringArray[142] = "tagList";
        stringArray[143] = "peeledObjectId";
        stringArray[144] = "peel";
        stringArray[145] = "getRefDatabase";
        stringArray[146] = "getRepository";
        stringArray[147] = "objectId";
        stringArray[148] = "put";
        stringArray[149] = "name";
        stringArray[150] = "replace";
        stringArray[151] = "getName";
        stringArray[152] = "R_TAGS";
        stringArray[153] = "<$constructor$>";
        stringArray[154] = "iterator";
        stringArray[155] = "call";
        stringArray[156] = "tagList";
        stringArray[157] = "peeledObjectId";
        stringArray[158] = "peel";
        stringArray[159] = "getRefDatabase";
        stringArray[160] = "getRepository";
        stringArray[161] = "objectId";
        stringArray[162] = "put";
        stringArray[163] = "replace";
        stringArray[164] = "getName";
        stringArray[165] = "R_TAGS";
        stringArray[166] = "name";
        stringArray[167] = "getFirstReleasedVersion";
        stringArray[168] = "reverse";
        stringArray[169] = "<$constructor$>";
        stringArray[170] = "iterator";
        stringArray[171] = "name";
        stringArray[172] = "toObjectId";
        stringArray[173] = "get";
        stringArray[174] = "next";
        stringArray[175] = "plus";
        stringArray[176] = "plus";
        stringArray[177] = "isEmpty";
        stringArray[178] = "plus";
        stringArray[179] = "put";
        stringArray[180] = "iterator";
        stringArray[181] = "name";
        stringArray[182] = "toObjectId";
        stringArray[183] = "get";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "<$constructor$>";
        stringArray[186] = "iterator";
        stringArray[187] = "name";
        stringArray[188] = "toObjectId";
        stringArray[189] = "add";
        stringArray[190] = "get";
        stringArray[191] = "iterator";
        stringArray[192] = "put";
        stringArray[193] = "clear";
        stringArray[194] = "isEmpty";
        stringArray[195] = "iterator";
        stringArray[196] = "put";
        stringArray[197] = "plus";
        stringArray[198] = "<$constructor$>";
        stringArray[199] = "<$constructor$>";
        stringArray[200] = "sort";
        stringArray[201] = "reverse";
        stringArray[202] = "iterator";
        stringArray[203] = "iterator";
        stringArray[204] = "startsWith";
        stringArray[205] = "length";
        stringArray[206] = "trim";
        stringArray[207] = "containsKey";
        stringArray[208] = "get";
        stringArray[209] = "put";
        stringArray[210] = "split";
        stringArray[211] = "<$constructor$>";
        stringArray[212] = "iterator";
        stringArray[213] = "startsWith";
        stringArray[214] = "isEmpty";
        stringArray[215] = "trim";
        stringArray[216] = "add";
        stringArray[217] = "trim";
        stringArray[218] = "join";
        stringArray[219] = "call";
        stringArray[220] = "log";
        stringArray[221] = "toList";
        stringArray[222] = "isEmpty";
        stringArray[223] = "get";
        stringArray[224] = "minus";
        stringArray[225] = "size";
        stringArray[226] = "create";
        stringArray[227] = "getTasks";
        stringArray[228] = "findByName";
        stringArray[229] = "getTasks";
        stringArray[230] = "dependsOn";
        stringArray[231] = "getByName";
        stringArray[232] = "getTasks";
        stringArray[233] = "create";
        stringArray[234] = "getTasks";
        stringArray[235] = "set";
        stringArray[236] = "getStartingTag";
        stringArray[237] = "findByName";
        stringArray[238] = "getTasks";
        stringArray[239] = "dependsOn";
        stringArray[240] = "getByName";
        stringArray[241] = "getTasks";
        stringArray[242] = "create";
        stringArray[243] = "getTasks";
        stringArray[244] = "set";
        stringArray[245] = "getStartingCommit";
        stringArray[246] = "findByName";
        stringArray[247] = "getTasks";
        stringArray[248] = "dependsOn";
        stringArray[249] = "getByName";
        stringArray[250] = "getTasks";
        stringArray[251] = "projectsEvaluated";
        stringArray[252] = "gradle";
        stringArray[253] = "getParent";
        stringArray[254] = "getParent";
        stringArray[255] = "findByName";
        stringArray[256] = "getTasks";
        stringArray[257] = "<$constructor$>";
        stringArray[258] = "getParent";
        stringArray[259] = "getParent";
        stringArray[260] = "findByName";
        stringArray[261] = "getTasks";
        stringArray[262] = "<$constructor$>";
        stringArray[263] = "findByName";
        stringArray[264] = "getTasks";
        stringArray[265] = "findNearestChangelogTask";
        stringArray[266] = "getParent";
        stringArray[267] = "findByName";
        stringArray[268] = "getTasks";
        stringArray[269] = "afterEvaluate";
        stringArray[270] = "setupChangelogGenerationForPublishingAfterEvaluation";
        stringArray[271] = "findNearestChangelogTask";
        stringArray[272] = "findByName";
        stringArray[273] = "tasks";
        stringArray[274] = "project";
        stringArray[275] = "dependsOn";
        stringArray[276] = "findByName";
        stringArray[277] = "tasks";
        stringArray[278] = "project";
        stringArray[279] = "artifact";
        stringArray[280] = "get";
        stringArray[281] = "getOutputFile";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[282];
        ChangelogUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ChangelogUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ChangelogUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

