/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils;

import javax.inject.Inject;
import net.minecraftforge.gradleutils.ChangelogUtils;
import org.gradle.api.Project;
import org.gradle.api.publish.maven.MavenPublication;

public class ChangelogGenerationExtension {
    private final Project project;
    private boolean registerAllPublications = true;

    @Inject
    public ChangelogGenerationExtension(Project project) {
        this.project = project;
    }

    public void fromMergeBase() {
        ChangelogUtils.setupChangelogGeneration(this.project);
        this.project.afterEvaluate(this::afterEvaluate);
    }

    public void fromTag(String tag) {
        ChangelogUtils.setupChangelogGenerationFromTag(this.project, tag);
        this.project.afterEvaluate(this::afterEvaluate);
    }

    public void fromCommit(String commit) {
        ChangelogUtils.setupChangelogGenerationFromCommit(this.project, commit);
        this.project.afterEvaluate(this::afterEvaluate);
    }

    public void disableAutomaticPublicationRegistration() {
        this.registerAllPublications = false;
    }

    public void publish(MavenPublication mavenPublication) {
        ChangelogUtils.setupChangelogGenerationForPublishing(this.project, mavenPublication);
    }

    private void afterEvaluate(Project project) {
        if (this.registerAllPublications) {
            ChangelogUtils.setupChangelogGenerationOnAllPublishTasks(project);
        }
    }
}

