/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.util;

import java.util.concurrent.atomic.AtomicBoolean;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.Attribute;
import org.jetbrains.annotations.Nullable;

public class MinecraftDependencyUtil {
    @Nullable
    public static String resolveMinecraftDependenciesVersion(Project project, ExternalModuleDependency dependency) {
        Dependency minecraftDependenciesDependency = project.getDependencies().create((Object)("net.neoforged:minecraft-dependencies" + (String)(dependency.getVersion() != null ? ":" + dependency.getVersion() : "")));
        AtomicBoolean configured = new AtomicBoolean(dependency.getVersion() != null);
        if (minecraftDependenciesDependency instanceof ExternalModuleDependency) {
            ExternalModuleDependency emd = (ExternalModuleDependency)minecraftDependenciesDependency;
            emd.version(version -> {
                VersionConstraint versionConstraint = dependency.getVersionConstraint();
                if (versionConstraint.getPreferredVersion() != null && !versionConstraint.getPreferredVersion().isEmpty()) {
                    version.prefer(versionConstraint.getPreferredVersion());
                    configured.set(true);
                }
                if (versionConstraint.getRejectedVersions() != null && !versionConstraint.getRejectedVersions().isEmpty()) {
                    version.reject(versionConstraint.getRejectedVersions().toArray(new String[0]));
                    configured.set(true);
                }
                if (versionConstraint.getRequiredVersion() != null && !versionConstraint.getRequiredVersion().isEmpty()) {
                    version.require(versionConstraint.getRequiredVersion());
                    configured.set(true);
                }
                if (versionConstraint.getStrictVersion() != null && !versionConstraint.getStrictVersion().isEmpty()) {
                    version.strictly(versionConstraint.getStrictVersion());
                    configured.set(true);
                }
                if (versionConstraint.getBranch() != null && !versionConstraint.getBranch().isEmpty()) {
                    version.setBranch(versionConstraint.getBranch());
                    configured.set(true);
                }
            });
        }
        if (!configured.get()) {
            return null;
        }
        Configuration dependenciesLookup = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)project.getConfigurations(), (String)"ResolveRequestedMinecraftVersion", (Dependency[])new Dependency[]{minecraftDependenciesDependency});
        dependenciesLookup.attributes(attributes -> {
            attributes.attribute(Attribute.of((String)"net.neoforged.distribution", String.class), (Object)"client");
            attributes.attribute(Attribute.of((String)"net.neoforged.operatingsystem", String.class), (Object)"linux");
        });
        return ((ResolvedDependency)dependenciesLookup.getResolvedConfiguration().getFirstLevelModuleDependencies().iterator().next()).getModuleVersion();
    }
}

