/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.util;

import net.neoforged.gradle.common.util.BundledServerUtils;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class ServerLaunchInformation {
    private final Provider<String> mainClass;
    private final Provider<Boolean> isBundledServer;

    public static ServerLaunchInformation from(TaskProvider<? extends WithOutput> serverFile) {
        Provider isBundled = serverFile.flatMap(OutputSpecification::getOutput).map(RegularFile::getAsFile).map(BundledServerUtils::isBundledServer);
        Provider mainClass = serverFile.flatMap(OutputSpecification::getOutput).map(RegularFile::getAsFile).map(BundledServerUtils::getBundledMainClass).orElse((Object)"net.minecraft.server.Main");
        return new ServerLaunchInformation((Provider<String>)mainClass, (Provider<Boolean>)isBundled);
    }

    private ServerLaunchInformation(Provider<String> mainClass, Provider<Boolean> isBundledServer) {
        this.mainClass = mainClass;
        this.isBundledServer = isBundledServer;
    }

    public Provider<String> getMainClass() {
        return this.mainClass;
    }

    public Provider<Boolean> isBundledServer() {
        return this.isBundledServer;
    }
}

